{*
  Шаблон вычисления "История изменения поля"
*}

$log_fields = \CB\Calculation\SecondaryFunctions::logFields((int)$table_id, $table['name_table'] ?? '');

$field_id = {$field|substr:1};
if (isset($event['changed'][$field_id])) {
    $field = $table_fields[$field_id];

    $old_line = ['id' => $line_id, $field['int_name'] => $event['changed'][$field_id]['old']];
    $old_value = form_display_type($field, $old_line, 'text');
    $new_value = form_display_type($field, $line, 'text');

    $log_line_id = data_insert($log_fields['table_id'], EVENTS_ENABLE, [
        'f' . $log_fields['link' . $table_id] => $line_id,
        'f' . $log_fields['field_name'] => $field['name_field'],
        'f' . $log_fields['before_value'] => $old_value,
        'f' . $log_fields['after_value'] => $new_value,
    ]);

    if ($field['type_field'] == 6 || $field['type_field'] == 9) {
        $save_field = $field['type_field'] == 6 ? $log_fields['file'] : $log_fields['image'];
        $old_files = $event['changed'][$field_id]['old'] ? explode("\r\n", $event['changed'][$field_id]['old']) : [];
        $cur_files = $line[$field['int_name']] ? explode("\r\n", trim($line[$field['int_name']])) : [];
        $new_files = array_diff($cur_files, $old_files);
        $fieldId = $field_id;
        $lineId = $line_id;
        foreach ($new_files as $f_name) {
            if(!$f_name) {
            return;
        }
        // Получаем объект поля
        $fieldsRep = \CB\Data\Fields\FieldRepository::getInstance();
        $field = $fieldsRep->get($fieldId); // Находим поле по id поля. Чтобы получить id таблицы

        if (!$field) {
            return;
        }

        $tableId = $field->get('table_id'); // Получаем ID таблицы
        $commonData = \CB\Core::get(\CB\Core::COMMON_DATA); // Получаем объект работы с данными
        $tableModels = $commonData->getTable($tableId); // Получаем объект таблицы

        if (!$tableModels) {
            return;
        }

        if (!$lineId) {
            return;
        }

        $recordObject = $tableModels->getRecord($lineId); // Получаем объект записи

        if (!$recordObject) {
            return;
        }

        $curFilesObject = $recordObject->get('f' . $fieldId); // Получаем объект поля

        if (!$curFilesObject) {
            return;
        }
            save_data_file($save_field, $log_line_id, $f_name, $curFilesObject->getContent($f_name));
        }
        data_update($log_fields['table_id'], EVENTS_ENABLE, ['f' . $save_field => implode("\r\n", $new_files)], 'id = ', $log_line_id);
    }
}