<?php

require_once __DIR__.'/../vendor/autoload.php';

// Задать константы - имена служебных таблиц с учетом префикса
\CB\Tool\Naming::defineTableNamesWithPrefixes();

// Типы полей
define('FIELD_NUMBER', 1);          // числовое
define('FIELD_DATE', 2);            // дата
define('FIELD_TEXT', 3);            // текст
define('FIELD_LIST', 4);            // список
define('FIELD_LINK', 5);            // связь
define('FIELD_FILE', 6);            // файл
define('FIELD_USER', 7);            // пользователь
define('FIELD_IMAGE', 9);           // изображение
define('FIELD_GROUP', 14);          // группа

// Типы системных полей
define('SYS_FIELD_ID', 10);         // ID
define('SYS_FIELD_USER_ID', 11);    // Кто добавил/user_id
define('SYS_FIELD_ADD_TIME', 12);   // Время добавления/add_time
define('SYS_FIELD_STATUS', 13);     // Статус записи/status

// Константы событий
define('EVT_LINE_SAVE', 1);  // сохранение в таблице, параметр id таблицы
define('EVT_FIELD_SHOW', 2);  // просмотр поля, параметр id поля
define('EVT_FIELD_CHANGE', 3);  // изменение поля, параметр id поля
define('EVT_LINE_DROP', 4);  // удаление в таблице, параметр id таблицы
//     позволяет отменить действие через параметр
//       global $cancel_delete;
//       $cancel_delete=1;
define('EVT_TABLE_IMPORT', 5);  // импорт в таблице, параметр id таблицы
define('EVT_LINE_ARH', 6);  // архивирование в таблице, параметр id таблицы
define('EVT_LINE_RESTORE', 7);  // восстановление в таблице, параметр id таблицы
define('EVT_SCHEDULE', 8);  // "по расписанию", параметр id таблицы
define('EVT_FILE_DROP', 10);  // удаление файла, параметр id файла
define('EVT_FILE_ADD', 11);  // добавление файла, параметр id файла
define('EVT_FILE_CHANGE', 13);  // перезаливка существующего файла, параметр id файла
define('EVT_BUTTON_PRESS', 24);  // нажатие на кнопку (доп. действие), параметр id допдействия
define('EVT_USER_LOGIN', 16);  // логин/логout пользователся, параметр id пользователя.
define('EVT_USER_CHANGE', 17);  // изменение пользователя, параметр id пользователя, параметр 0 - изменение, 1 - добавление, 2 - удаление, 3 - архивирование, 4 - восстановление из архива. Также достуна глобальная переменная $old_user, в которой содержаться старые (до сохранения) данные пользователя.
define('EVT_NEW_QST', 18);  // новая анкета, данное вычисление может менять вывод результата анкеты через глобальную переменную $output
define('CLIENTBASE_DOMAIN', $config['clientbase_domain'] = $config['clientbase_domain'] ?? 'clientbase.ru'); // базовый домен
define('PARTNER_DOMAINS_URL', 'https://invite.' . CLIENTBASE_DOMAIN . '/classes/lk/get_partner_domains.php'); /// список сайтов партнеров
define('PARTNER_DOMAINS_CACHE', __DIR__ . '/../runtime/partner_domains.json');
define('PARTNER_DOMAINS_TTL', 15*60); /// срок жизни кеша, сек
define('PARTNER_DOMAINS_TIMEOUT', 1000); /// время ожидания ответа от сервиса, милисек

define('SYNC_STRINGS', 1000); // максимальное количество строк в файлах синхронизации

define('URL_LK', 'https://lk.' . CLIENTBASE_DOMAIN . '/');

define('FREE_TARIFF_ID', 1);

// Список всех кодировок
$charsets = array(
    'utf-8' => 'UTF-8',
    'cp1251' => 'Windows 1251 (Cyrillic)',
    'cp1252' => 'Windows 1252 (Latin-1)',
    'maccyrillic' => 'MacCyrillic',
    'cp866' => 'CP866 (DOS)',
    'koi8-r' => 'KOI8-R',
);


// Список таблиц, использующих autoincrement по каналам
$channel_tables = array(
    ACC_ADDIT_TABLES_TABLE,
    ACC_ADDIT_TABLES_TABLE . '_par',
    ACC_BUTTONS_TABLE,
    ACC_BUTTONS_TABLE . '_par',
    ACC_CALENDARS_TABLE,
    ACC_CALENDARS_TABLE . '_par',
    ACC_FIELDS_TABLE,
    ACC_FIELDS_TABLE . '_par',
    ACC_FILTERS_TABLE,
    ACC_FILTERS_TABLE . '_par',
    ACC_FORMS_TABLE,
    ACC_FORMS_TABLE . '_par',
    ACC_REPORTS_TABLE,
    ACC_REPORTS_TABLE . '_par',
    ACC_REPORTS_USERS_TABLE,
    ACC_RULES_TABLE,
    ACC_SUBADMIN_RULES_TABLE,
    ACC_SUBTABLE_RULES_TABLE,
    ACC_SUBTABLES_TABLE,
    ACC_SUBTABLES_TABLE . '_par',
    ACC_TABLES_TABLE,
    ACC_TABLES_TABLE . '_par',
    ACC_TIPS_TABLE,
    ACC_TIPS_TABLE . '_par',
    ADDIT_TABLES_TABLE,
    BUTTON_GROUPS,
    BUTTONS_TABLE,
    CALC_TABLE,
    CALENDARS_TABLE,
    CALENDAR_EVENTS,
    CALENDAR_FIELDS,
    CATS_TABLE,
    CRON_TABLE,
    EXT_FILES,
    FIELD_GROUPS,
    FIELDS_TABLE,
    FIELDS_LINKS_SHOW_TABLE,
    FILTERS_TABLE,
    FORMAT_TABLE,
    FORMS_TABLE,
    FORMS_VARS_TABLE,
    GROUPS_TABLE,
    IMPORT_TPL_TABLE,
    INFORMERS_TABLE,
    MAIL_FILES_LINKS_TABLE,
    MAIL_FILES_INFO_TABLE,
    MAIL_FILES_PART_TABLE,
    MAIL_TEMPLATES_TABLE,
    MODULES_TABLE,
    QST_TABLE,
    REPORTS_TABLE,
    SCHEMES_TABLE,
    SMTP_TABLE,
    SUBTABLES_TABLE,
    SYNC_TABLE,
    TABLES_TABLE,
    TIPS_TABLE,
    USERS_TABLE
);

// Список разрешённых bb-кодов с допустимыми параметрами (если они есть)
$allow_bbcode_tags = array(
    'noparse' => false, // этот тег всегда обрабатывается первым, не перемещать в списке
    'b' => false,
    'i' => false,
    'u' => false,
    'sup' => false,
    'sub' => false,
    'strike' => false,
    's' => false,
    'left' => false,
    'right' => false,
    'center' => false,
    'color' => array('color' => array('default' => 'black', 'values' => false)),
    'size' => array('size' => array('default' => '0', 'values' => false)),
    'email' => array('email' => array('default' => '', 'values' => false)),
    'url' => array('url' => array('default' => '#', 'values' => false)),
    'img' => array('img' => array('default' => '', 'values' => false)),
    'list' => array('list' => array('default' => '*', 'values' => array('a', 'A', '1', '*')))
);

// Форматы дат
$date_formats = [
    'dd.mm.yyyy' => [
        'date_format'          => 'd.m.Y',
        'date_js_format'       => 'dd.mm.yy',
        'date_placeholder'     => 'dd.mm.yyyy',
        'datetime_placeholder' => 'dd.mm.yyyy hh:mm',
        'date_full_format'     => 'j F Y',
        'date_to_timestamp'    => 'list($day, $month, $year, $hour, $min, $sec) = sscanf($local_time, "%d.%d.%d %d:%d:%d");',
    ],
    'mm/dd/yyyy' => [
        'date_format'          => 'm/d/Y',
        'date_js_format'       => 'mm/dd/yy',
        'date_placeholder'     => 'mm/dd/yyyy',
        'datetime_placeholder' => 'mm/dd/yyyy hh:mm',
        'date_full_format'     => 'F j, Y',
        'date_to_timestamp'    => 'list($month, $day, $year, $hour, $min, $sec) = sscanf($local_time, "%d/%d/%d %d:%d:%d");',
    ],
    'dd-mm-yyyy' => [
        'date_format'          => 'd-m-Y',
        'date_js_format'       => 'dd-mm-yy',
        'date_placeholder'     => 'dd-mm-yyyy',
        'datetime_placeholder' => 'dd-mm-yyyy hh:mm',
        'date_full_format'     => 'j F Y',
        'date_to_timestamp'    => 'list($day, $month, $year, $hour, $min, $sec) = sscanf($local_time, "%d-%d-%d %d:%d:%d");',
    ],
    'dd/mm/yyyy' => [
        'date_format'          => 'd/m/Y',
        'date_js_format'       => 'dd/mm/yy',
        'date_placeholder'     => 'dd/mm/yyyy',
        'datetime_placeholder' => 'dd/mm/yyyy hh:mm',
        'date_full_format'     => 'j F Y',
        'date_to_timestamp'    => 'list($day, $month, $year, $hour, $min, $sec) = sscanf($local_time, "%d/%d/%d %d:%d:%d");',
    ],
    'yyyy-mm-dd' => [
        'date_format'          => 'Y-m-d',
        'date_js_format'       => 'yy-mm-dd',
        'date_placeholder'     => 'yyyy-mm-dd',
        'datetime_placeholder' => 'yyyy-mm-dd hh:mm',
        'date_full_format'     => 'j F Y',
        'date_to_timestamp'    => 'list($year, $month, $day, $hour, $min, $sec) = sscanf($local_time, "%d-%d-%d %d:%d:%d");',
    ],
];

// Форматы чисел
$number_formats = [
    '1 999,99' => [
        'float_delimiter' => ',',
        'space_delimiter' => ' ',
    ],
    '1 999.99' => [
        'float_delimiter' => '.',
        'space_delimiter' => ' ',
    ],
    '1.999,99' => [
        'float_delimiter' => ',',
        'space_delimiter' => '.',
    ],
    '1,999.99' => [
        'float_delimiter' => '.',
        'space_delimiter' => ',',
    ],
];
