var lk_login;
var lk_plan_info;
var lk_space_used;
var lk_users_count;
var c_all_cost;
var c_addons_cost;
var c_conf_cost;
var lk_cm;
var lk_months_default;
var lk_tariff_default;
var lk_coupon_info;
var lk_discount;
var lk_recommend_number = 1;
var lk_update_start = false;

function find(array, value) {
    for (key in array) {
        if (array[key] === value) {
            return key;
        }
    }
    return -1;
}

function lk_connect(checkAjax) {
    $.ajax({
        type: 'POST',
        url: 'edit_saas.php',
        data: 'url_connect=lk.' + clientbase_domain + '&csrf=' + csrf,
        success: function (data) {
            checkAjax.html(data);
            bind_help_bt();
        }
    });
}

function function_exists(function_name) {
    if (typeof function_name === 'string') {
        return (typeof window[function_name] === 'function');
    } else {
        return (function_name instanceof Function);
    }
}

function lk_edit(module, task, key) {
    var element_v = $('#lk_' + module + '_' + key + '_v');
    var element_e = $('#lk_' + module + '_' + key + '_e');
    var element_c = $('#lk_' + module + '_' + key + '_c');
    var element_s = $('#lk_' + module + '_' + key + '_s');
    var element_f = $('#lk_' + module + '_' + key + '_f');
    if (element_f.attr('type') == 'checkbox') {
        var val = element_f.is(':checked')
    } else {
        var val = element_f.val();
    }

    if (module == 'contacts' && task == 'update' && val == '') {
        jalert(lang.lk_contact_data_alert);
        return;
    }

    if (typeof val.includes !== 'undefined' && val.includes('<script>')) {
        jalert(lang.script_found);
        return;
    }

    var run = true;
    if (function_exists('lk_check_' + module + '_' + task + '_' + key)) {
        run = window['lk_check_' + module + '_' + task + '_' + key]();
    }
    if (run) {
        element_c.html("<img src='images/indicator.gif' alt='' />");
        $.ajax({
            type: "POST",
            url: 'edit_saas.php',
            data: 'lk_edit=1&module=' + module + '&task=' + task + '&key=' + key + '&val=' + encodeURIComponent(val) + '&csrf=' + csrf,
            success: function (data) {
                if (data === 'OK!') {
                    element_c.html("&nbsp");
                    element_s.html(val);
                    element_v.toggleClass('hidden');
                    element_e.toggleClass('hidden');

                    if (function_exists('lk_edit_' + module + '_' + task + '_' + key)) {
                        window['lk_edit_' + module + '_' + task + '_' + key]();
                    }
                } else if (function_exists('lk_return_' + module + '_' + task + '_' + key)) {
                    window['lk_return_' + module + '_' + task + '_' + key](data);
                } else {
                    element_c.html(data);
                }
            }
        });
    }
}

function lk_change(module, task, key) {
    if (task === 'update') {
        var element_v = $('#lk_' + module + '_' + key + '_v');
        var element_e = $('#lk_' + module + '_' + key + '_e');

        element_v.toggleClass('hidden');
        element_e.toggleClass('hidden');

        if (function_exists('lk_change_' + module + '_' + task + '_' + key)) {
            window['lk_change_' + module + '_' + task + '_' + key]();
        }
    }
}

async function lk_only_contacts_save() {
    let fio = $('#lk_contacts_fio_f').val(),
        phone = $('#lk_contacts_phone_f').val(),
        email = $('#lk_contacts_email_f').val(),
        telegram = $('#lk_contacts_telegram_f').val(),
        email_match = email.match(/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/),
        comm_method = $('#lk_contacts_comm_method_f').val();

    if (!fio || !phone || !email || email_match == null || (comm_method == 'Telegram' && !telegram)) {
        if (!fio) {
            $('#lk_contacts_fio_f').css('border-color', '#f00');
            $('#lk_contacts_fio_f').on('input', () => $('#lk_contacts_fio_f').css('border-color', ''));
        }
        if (!phone) {
            $('#lk_contacts_phone_f').css('border-color', '#f00');
            $('#lk_contacts_phone_f').on('input', () => $('#lk_contacts_phone_f').css('border-color', ''));
        }
        if (!email || email_match == null) {
            $('#lk_contacts_email_f').css('border-color', '#f00');
            $('#lk_contacts_email_f').on('input', () => $('#lk_contacts_email_f').css('border-color', ''));
        }
        if (comm_method == 'Telegram' && !telegram) {
            $('#lk_contacts_telegram_f').css('border-color', '#f00');
            $('#lk_contacts_telegram_f').on('input', () => $('#lk_contacts_telegram_f').css('border-color', ''));
        }

        return;
    }

    let fio_try_save = await only_contacts_ajax($('#lk_contacts_fio_f'), $('#lk_contacts_fio_c'), 'fio', fio),
        phone_try_save = await only_contacts_ajax($('#lk_contacts_phone_f'), $('#lk_contacts_phone_c'), 'phone', phone),
        email_try_save = await only_contacts_ajax($('#lk_contacts_email_f'), $('#lk_contacts_email_c'), 'email', email);
        comm_method_try_save = await only_contacts_ajax($('#lk_contacts_comm_method_f'), $('#lk_contacts_comm_method_c'), 'comm_method', comm_method);
        telegram_try_save = await only_contacts_ajax($('#lk_contacts_telegram_f'), $('#lk_contacts_telegram_c'), 'telegram', telegram);

    if (fio_try_save && phone_try_save && email_try_save && comm_method_try_save && telegram_try_save) {
        location.href='login.php';
    } else {
        return;
    }
}

async function only_contacts_ajax(block, info_block, key, val){
    let is_ok = false;

    info_block.html("<img src='images/indicator.gif' alt='' />")
    let result = await $.ajax({
        type: "POST",
        url: 'edit_saas.php',
        data: 'lk_edit=1&module=contacts&task=update&key=' + key + '&val=' + encodeURIComponent(val) + '&csrf=' + csrf,
    });

    if (result === 'OK!') {
        info_block.html("&nbsp");
        is_ok = true;
    } else {
        info_block.html(result);
        block.css('border-color', '#f00');
        block.on('input', () => block.css('border-color', ''));
    }

    return is_ok;
}

$(document).ready(function () {
    lk_connect($('div#lk_content'));
});

function lk_edit_backup_update_ftp() {
    var element_s = $('#lk_backup_ftp_s');
    if (parseInt(element_s.text()) === 1) {
        element_s.text(lang.lk_not_activated);
        $('.lk_backup_ftp_d').addClass('hidden');
    } else {
        element_s.text(lang.lk_activated);
        $('.lk_backup_ftp_d').removeClass('hidden');
    }
}

function lk_edit_ftp1c_update_ftp() {
    var element_s = $('#lk_ftp1c_ftp_s');
    if (parseInt(element_s.text()) === 1) {
        element_s.text(lang.lk_not_activated);
        $('.lk_ftp1c_ftp_d').addClass('hidden');
    } else {
        element_s.text(lang.lk_activated);
        $('.lk_ftp1c_ftp_d').removeClass('hidden');
    }
}

function lk_return_backup_update_ftp(data) {
    var val = $('#lk_backup_ftp_f').val();
    var element_s = $('#lk_backup_ftp_s');
    var element_v = $('#lk_backup_ftp_v');
    var element_e = $('#lk_backup_ftp_e');
    var element_c = $('#lk_backup_ftp_c');
    element_s.html(val);
    element_v.toggleClass('hidden');
    element_e.toggleClass('hidden');
    if (typeof data === 'string' && data.slice(0, 1) !== '{') {
        element_c.html(data);
    } else {
        data = JSON.parse(data);
        lk_coupon_info = data;
        element_c.html("&nbsp");
    }
    if (parseInt(element_s.text()) === 1) {
        element_s.text(lang.lk_not_activated);
        $('.lk_backup_ftp_d').addClass('hidden');
    } else {
        element_s.text(lang.lk_activated);
        if (data.passwordraw !== undefined) {
            $('#lk_backup_ftp_passwordraw').text(data.passwordraw);
        }
        $('.lk_backup_ftp_d').removeClass('hidden');
    }
    $('#lk_ftp1c_ftp_s').text(lang.lk_not_activated);
    $('#lk_ftp1c_ftp_f option[value=1]').prop('selected', true);
    $('.lk_ftp1c_ftp_d').addClass('hidden');
}

function lk_return_ftp1c_update_ftp(data) {
    var val = $('#lk_ftp1c_ftp_f').val();
    var element_s = $('#lk_ftp1c_ftp_s');
    var element_v = $('#lk_ftp1c_ftp_v');
    var element_e = $('#lk_ftp1c_ftp_e');
    var element_c = $('#lk_ftp1c_ftp_c');
    element_s.html(val);
    element_v.toggleClass('hidden');
    element_e.toggleClass('hidden');
    if (typeof data === 'string' && data.slice(0, 1) !== '{') {
        element_c.html(data);
    } else {
        data = JSON.parse(data);
        lk_coupon_info = data;
        element_c.html("&nbsp");
    }
    if (parseInt(element_s.text()) === 1) {
        element_s.text(lang.lk_not_activated);
        $('.lk_ftp1c_ftp_d').addClass('hidden');
    } else {
        element_s.text(lang.lk_activated);
        if (data.passwordraw !== undefined) {
            $('#lk_ftp1c_ftp_passwordraw').text(data.passwordraw);
        }
        $('.lk_ftp1c_ftp_d').removeClass('hidden');
    }
    $('#lk_backup_ftp_s').text(lang.lk_not_activated);
    $('#lk_backup_ftp_f option[value=1]').prop('selected', true);
    $('.lk_backup_ftp_d').addClass('hidden');
}

function lk_edit_domains_update_master_domain() {
    var result = '';
    var element = $('#lk_domains_master_domain_f');
    var element_selected = $('#lk_domains_master_domain_f').find('option:selected').text();
    var element_system_domain_s = $('#lk_client_domain').text();
    var element_alia_s = $('#lk_domains_alias_s').text();
    var element_your_domain_s = $('#lk_domains_your_domain_s').text();
    var element_array = [element_system_domain_s, element_alia_s, element_your_domain_s];
    element_array.forEach(function (item) {
        result = result + '<option ' + ((element_selected === item) ? 'selected' : '') + '>' + item + '</option>';
    });
    element.html(result);
}

function lk_edit_domains_update_alias() {
    var element_alia_s = $('#lk_domains_alias_s');
    var element_system_domain_s = $('#lk_domains_system_domain_s');
    element_alia_s.text(element_alia_s.text() + '.' + element_system_domain_s.text());
    lk_edit_domains_update_master_domain();
}

function lk_edit_domains_update_your_domain() {
    lk_edit_domains_update_master_domain();
    if ($('#lk_domains_your_domain_block').css('display') == 'block') {
        jalert(lang.lk_update_your_domain);
    }
}

function lk_change_domains_update_your_domain() {
    var element_selected = $('#lk_domains_master_domain_f').find('option:selected').text();
    var element_your_domain_s = $('#lk_domains_your_domain_s').text();
    if (element_selected === element_your_domain_s) {
        alert(lang.lk_error_edit_domain);
        $('#lk_domains_your_domain_v').toggleClass('hidden');
        $('#lk_domains_your_domain_e').toggleClass('hidden');
        return false;
    }
}

function lk_change_domains_update_alias() {
    var element_selected = $('#lk_domains_master_domain_f').find('option:selected').text();
    var element_alia_s = $('#lk_domains_alias_s').text();
    if (element_selected === element_alia_s) {
        alert(lang.lk_error_edit_domain);
        $('#lk_domains_alias_v').toggleClass('hidden');
        $('#lk_domains_alias_e').toggleClass('hidden');
        return false;
    }
}

function lk_change_info_update_tariff() {
    // if ($('.ru-tariff').length > 0) $('#ru-tariff-button').show();
    if ($('.ru-tariff').length > 0 || $('.proru-tariff').length > 0) {
        document.getElementById('lk_ru_tariff_f').checked = true;
        lk_change_tariff_list(document.getElementById('lk_ru_tariff_f'), 0);
    }
    if (($('.pro-tariff').length > 0 || $('.proru-tariff').length > 0) && ($('.st-tariff').length > 0 || $('.ru-tariff').length > 0)) {
        $('#pro-tariff-button').show();
    }
}

function lk_edit_info_update_tariff() {
    // var new_plan_id = $('#lk_info_tariff_f').val();
    // $('#lk_info_tariff_s').html('<b>' + lk_plan_info[new_plan_id]['name'] + '</b>');
    // $('#lk_expire_v').html('<b>' + lk_plan_info[new_plan_id]['new_date'] + '</b>');
    location.reload();
}

function lk_check_info_update_tariff() {
    var new_plan_id = $('#lk_info_tariff_f').val();

    if (new_plan_id === '14') {
        if (confirm(lang.lk_change_plan_maximum))
            window.open("http://clientbase.ru/buy/form/", "max_form");
        return false;
    }

    if (parseFloat(lk_plan_info[new_plan_id]['disk_space']) <= parseFloat(lk_space_used)) {
        alert(lang.lk_change_plan_space_alert + ' ' + lk_plan_info[new_plan_id]['name'] + ".");
        return false;
    }

    if (parseInt(lk_plan_info[new_plan_id]['lk_users_count']) < parseInt(lk_users_count)) {
        alert(lang.lk_change_plan_users_alert1 + lk_plan_info[new_plan_id]['name'] + lang.lk_change_plan_users_alert2);
        return true;
    }

    return true;
}

function lk_change_info_update_expire() {
    var element = $('#lk_buy');

    element.toggleClass('hidden');
}

function lk_change_tariff_buy() {
    var tariff = lk_tariff_default;
    var months = lk_months_default;

    if ($('#lk_expire_k #lk_info_tariff_f').val()) {
        tariff = $('#lk_info_tariff_f').val();
    }

    if ($('#lk_info_months_f').val()) {
        months = $('#lk_info_months_f').val();
    }

    tariff = Number(tariff);
    months = Number(months);
    var a = Number(c_all_cost[tariff][1]);
    var e = Number(c_conf_cost[tariff][1]);
    var b = Number(c_all_cost[tariff][months]);
    var c = Number(c_conf_cost[tariff][months]);
    var d = Number(c_addons_cost[tariff][months]);
    var o = Number(options_cost * months);

    if (lk_coupon_info !== undefined) {
        if (lk_coupon_info.action.type == 'Продление') {
            $('#lk_info_tariff_f').val(lk_coupon_info.action.for_plan[0]);
            $('#lk_info_months_f').val(lk_coupon_info.action.for_date[0]);
            $('#lk_info_tariff_f').prop('readonly', true);
            $('#lk_info_months_f').prop('readonly', true);
            $('#lk_info_coupon_code_f').prop('readonly', true);
            $('#lk_payment').addClass('hidden');
            $('#lk_activate').removeClass('hidden');
        } else {
            $('#lk_info_tariff_f').prop('readonly', false);
            $('#lk_info_months_f').prop('readonly', false);
            $('#lk_info_coupon_code_f').prop('readonly', false);
            $('#lk_payment').removeClass('hidden');
            $('#lk_activate').addClass('hidden');
            var element_coupon_status = $('#lk_info_coupon_code_c');
            if (find(lk_coupon_info.action.for_date, String(months)) !== -1
                && find(lk_coupon_info.action.for_plan, String(tariff)) !== -1) {
                element_coupon_status.html(lang.lk_promo_code_active);
                element_coupon_status.css('color', '#00b500');
                if (lk_coupon_info.action.discount !== undefined) {
                    var discount = lk_coupon_info.action.discount/100;
                    if (lk_coupon_info.action.summarized !== undefined) {
                        if (lk_coupon_info.action.summarized) {
                            discount = 1 - (lk_discount[months] - discount);
                            discount = discount.toFixed(2);
                        }
                    }
                    b = Math.round((a * months) - ((a * months) * discount));
                    if (lk_coupon_info.action.including_configuration !== undefined) {
                        if (lk_coupon_info.action.including_configuration) {
                            c = Math.round((e * months) - ((e * months) * discount));
                        }
                    }
                }
            } else if ($('#lk_info_coupon_code_f').val() !== '') {
                element_coupon_status.html(lang.lk_promo_code_no_active);
                element_coupon_status.css('color', 'red');
            }
        }
    }

    /* $('#lk_cost_conf_v').html(c + ' ' + lk_cm);
    if ((e * months) !== c) {
        $('#lk_cost_conf_v').html("<span style='text-decoration: line-through;'>" + (e * months) +
            "</span> <span style='color: red;'>" + c + ' ' + lk_cm + "</span>");
    } else {
        $('#lk_cost_conf_v').html(c + ' ' + lk_cm);
    } */
    if (((a + e) * months) !== b + c) {
        $('#lk_cost_acc_v').html("<span style='text-decoration: line-through;'>" + ((a + e) * months) +
            "</span> <span style='color: red;'>" + (b + c) + ' ' + lk_cm + "</span>");
    } else {
        $('#lk_cost_acc_v').html((b + c) + ' ' + lk_cm);
    }
    if (lk_plan_info[tariff] && lk_plan_info[tariff]['addons_discont'] > 0) {
        $('#lk_cost_addons_v').html('<span style="text-decoration: line-through">' + (d / (1 - lk_plan_info[tariff]['addons_discont'] / 100)) + '</span> ' +
            '<span style="color: red">' + d + ' ' + lk_cm + ' (-' + lk_plan_info[tariff]['addons_discont'] + '% ' + lang.thanks_to + ' PRO)</span>');
    } else {
        $('#lk_cost_addons_v').html(d + ' ' + lk_cm);
    }
    $('#lk_cost_sale_v').html(((a + e) * months - (b + c)) + ' ' + lk_cm + ' (' + Math.round(100 - ((b + c) / ((a + e) * months)) * 100) + '%)');
    if (lk_coupon_info !== undefined && lk_coupon_info.action.for_payment && lk_coupon_info.action.for_payment.length > 0) {
        $('#lk_cost_sale_v').html($('#lk_cost_sale_v').html() + ' (' + lang.lk_only_if_pay + ' <b>' + lk_coupon_info.action.for_payment.join(', ') + '</b>)');
    }
    $('#lk_cost_options_v').html(o + ' ' + lk_cm);
    $('#lk_cost_total_v').html('<b>' + (b + c + d + o) + ' ' + lk_cm + '</b>');
}

function activate_coupon() {
    jconfirm(lang.lk_activate_coupon_mes, function() {
        $('#lk_info_activate_coupon_f').val($('#lk_info_coupon_code_f').val());
        lk_edit('info', 'update', 'activate_coupon');
    },
    function() {
        $('#lk_info_coupon_code_f').val('');
        lk_edit('info', 'update', 'coupon_code');
    });
}

function lk_return_info_update_activate_coupon(data) {
    data = JSON.parse(data);
    jalert(data.message);
    $('#lk_info_coupon_code_f').val('');
    lk_edit('info', 'update', 'coupon_code');
    if (data.success) {
        $('#lk_buy').addClass('hidden');
    }
    if (data.expire) {
        $('#lk_expire_v b').html(data.expire);
    }
}

function first_buy(payment_type) {
    var tariff = lk_tariff_default;
    var months = lk_months_default;

    var empty_fio = $('#lk_contacts_fio_f').val();
    var empty_phone = $('#lk_contacts_phone_f').val();
    var empty_email = $('#lk_contacts_email_f').val();

    if (empty_fio === '' || empty_phone === '' || empty_email === '') {
        $('#lk_contact_info_please').removeClass('hidden');
        if (empty_fio === '') {
            $('#lk_contacts_fio_c').html(lang.lk_contact_fio_please).css('color', 'red');
            lk_change('contacts', 'update', 'fio');
        }
        if (empty_phone === '') {
            $('#lk_contacts_phone_c').html(lang.lk_contact_phone_please).css('color', 'red');
            lk_change('contacts', 'update', 'phone');
        }
        if (empty_email === '') {
            $('#lk_contacts_email_c').html(lang.lk_contact_email_please).css('color', 'red');
            lk_change('contacts', 'update', 'email');
        }
        return;
    } else {
        $('#lk_contact_info_please').addClass('hidden');
    }

    if ($('#lk_expire_k #lk_info_tariff_f').val()) {
        tariff = $('#lk_info_tariff_f').val();
    }

    if ($('#lk_info_months_f').val()) {
        months = $('#lk_info_months_f').val();
    }

    var partner_id = '';
    if (document.getElementById('partner_id'))
        partner_id = '&code=' + document.getElementById('partner_id').value;

    var coupon_code = '';
    if (document.getElementById('lk_info_coupon_code_f'))
        coupon_code = '&coupon_code=' + encodeURIComponent(document.getElementById('lk_info_coupon_code_f').value);

    if (payment_type == 1) {
        self.parent.self.parent.location = 'https://manage.' + clientbase_domain + '/client_billing.php?sel=pay_invoice&m_c=' + months + '&plan_id=' + tariff + '&saas_login=' + lk_login + partner_id + coupon_code;
    } else if (payment_type == 0) {
        self.parent.self.parent.location = 'https://manage.' + clientbase_domain + '/client_billing.php?sel=pay_robokassa&m_c=' + months + '&plan_id=' + tariff + '&saas_login=' + lk_login + partner_id + coupon_code;
    } else if (payment_type == 3) {
        self.parent.self.parent.location = 'https://manage.' + clientbase_domain + '/client_billing.php?sel=pay_yandex&m_c=' + months + '&plan_id=' + tariff + '&saas_login=' + lk_login + partner_id + coupon_code;
    } else if (payment_type == 4) {
        self.parent.self.parent.location = 'https://manage.' + clientbase_domain + '/client_billing.php?sel=pay_tinkoff&m_c=' + months + '&plan_id=' + tariff + '&saas_login=' + lk_login + partner_id + coupon_code;
    } else {
        self.parent.self.parent.location = 'https://manage.' + clientbase_domain + '/client_billing.php?sel=pay_paypal&m_c=' + months + '&plan_id=' + tariff + '&saas_login=' + lk_login + partner_id + coupon_code;
    }
}

function trusted_fee() {
    self.parent.self.parent.location = 'https://manage.' + clientbase_domain + '/client_billing.php?sel=trusted_fee&saas_login=' + lk_login;
}

function lk_change_info_update_promo_code() {
    var element = $('#lk_promo_code_e');

    element.toggleClass('hidden');
}

function lk_return_info_update_coupon_code(data) {
    var element_c = $('#lk_info_coupon_code_c');
    if (typeof data === 'string' && data.slice(0, 1) !== '{') {
        jalert(data.substr(5));
        element_c.html(lang.lk_promo_code_no_active);
        element_c.css('color', 'red');
    } else {
        data = JSON.parse(data);
        lk_coupon_info = data;
        element_c.html("&nbsp");
    }

    lk_change_tariff_buy();
}

function lk_edit_update_updateVersion_create_backup() {
    $('#lk_update_create_backup_c').html('');
    $('#lk_update_button').val(lang.lk_update_start);
    jalert(lang.lk_update_start_success);
}
function lk_edit_update_updateRevision_create_backup() {
    $('#lk_update_create_backup_c').html('');
    $('#lk_update_button').val(lang.lk_update_start);
    jalert(lang.lk_update_start_success);
}
/*function lk_check_update_updateVersion_create_backup() {
    var old_text = $('.lk_update_button').val();
    $('.lk_update_button').prop("disabled", false);
    $('.lk_update_button:nth-child(1)').val(lang.lk_send_request);
    if (lk_update_start) {
        return true;
    }
    jconfirm(lang.lk_update_new_version, function () {
            lk_update_start = true;
            lk_edit('update', 'updateVersion', 'create_backup');
            return true;
        },
        function () {
            $('.lk_update_button:nth-child(1)').val(old_text);
            lk_update_start = false;
            return false;
        });
}*/

function lk_return_friend_update_apply_bonus(data) {
    data = JSON.parse(data);
    $('#lk_friend_bonus').html(data.bonus);
    $('#lk_expire_v b').html(data.exp_date);
    $('#lk_friend_apply_bonus_c').html('');
    $('#lk_friend_use').hide();
    jalert(lang.lk_friend_exp_date_mes + data.exp_date);
}

function lk_copy(id_elem) {
    document.getElementById(id_elem).select();
    document.execCommand('copy');
    window.getSelection().removeAllRanges();
}

function lk_next_recommend() {
    var recommend_array = document.getElementById('lk_friend_recommend_storage').value.split('|');
    document.getElementById('lk_friend_recommend').value = recommend_array[lk_recommend_number];
    document.getElementById('lk_friend_recommend_text').innerHTML = recommend_array[lk_recommend_number];
    lk_recommend_number++;
    if (lk_recommend_number == recommend_array.length) {
        lk_recommend_number = 0;
    }
}

function lk_ftp1c_run() {
    if ($('#lk_backup_ftp_s').text() != lang.lk_activated) {
        lk_edit('ftp1c', 'update', 'ftp');
    } else if ($('#lk_ftp1c_ftp_f').val() == 2) {
        jconfirm(
            lang.lk_ftp_1c_alert1,
            function() {
                lk_edit('ftp1c', 'update', 'ftp');
            },
            function() {
                $('#lk_ftp1c_ftp_f option[value=1]').prop('selected', true);
            }
        );
    }
}

function lk_ftp_backup_run() {
    if ($('#lk_ftp1c_ftp_s').text() != lang.lk_activated) {
        lk_edit('backup', 'update', 'ftp');
    } else if ($('#lk_backup_ftp_f').val() == 0) {
        jconfirm(
            lang.lk_ftp_1c_alert2,
            function() {
                lk_edit('backup', 'update', 'ftp');
            },
            function() {
                $('#lk_backup_ftp_f option[value=1]').prop('selected', true);
            }
        );
    }
}

function lk_change_tariff_list(elem, recalc) {
    var state = document.getElementById('lk_ru_tariff_f').checked + document.getElementById('lk_pro_tariff_f').checked * 2;
    if (state == 0) { // standard
        var sel_opt = $('#lk_info_tariff_f option[value='+$('#lk_info_tariff_f').val()+']').attr('data-st');
        $('#lk_info_tariff_f option[value='+sel_opt+']').prop('selected', true);
        $('#lk_info_tariff_f option').hide();
        $('.st-tariff').show();
    } else if (state == 1) { // Ru
        if ($('.ru-tariff').length > 0) {
            var sel_opt = $('#lk_info_tariff_f option[value='+$('#lk_info_tariff_f').val()+']').attr('data-ru');
            $('#lk_info_tariff_f option[value='+sel_opt+']').prop('selected', true);
            $('#lk_info_tariff_f option').hide();
            $('.ru-tariff').show();
        } else if ($('.proru-tariff').length == 0) {
            jalert(lang.lk_tariffs_line + ' Ru ' + lang.lk_tariffs_line_not_sup + '.')
            elem.checked = !elem.checked;
        }
    } else if (state == 2) { // Pro
        if ($('.pro-tariff').length > 0) {
            var sel_opt = $('#lk_info_tariff_f option[value='+$('#lk_info_tariff_f').val()+']').attr('data-pro');
            $('#lk_info_tariff_f option[value='+sel_opt+']').prop('selected', true);
            $('#lk_info_tariff_f option').hide();
            $('.pro-tariff').show();
        } else if ($('.proru-tariff').length == 0) {
            jalert(lang.lk_tariffs_line + ' Pro ' + lang.lk_tariffs_line_not_sup + '.')
            elem.checked = !elem.checked;
        }
    } else if (state == 3) { // PROru
        if ($('.proru-tariff').length > 0) {
            var sel_opt = $('#lk_info_tariff_f option[value='+$('#lk_info_tariff_f').val()+']').attr('data-proru');
            $('#lk_info_tariff_f option[value='+sel_opt+']').prop('selected', true);
            $('#lk_info_tariff_f option').hide();
            $('.proru-tariff').show();
        } else {
            jalert(lang.lk_tariffs_line + ' Ru + Pro ' + lang.lk_tariffs_line_not_sup + '.')
            elem.checked = !elem.checked;
        }
    }
    if (recalc) {
        lk_change_tariff_buy();
    } else {
        lk_change_tariff();
    }
}

function lk_change_tariff() {
    $('#lk_expire_v a').toggle($('#lk_info_tariff_f').val() == lk_tariff_default);
    $('#lk_info_tariff_e a').toggle($('#lk_info_tariff_f').val() != lk_tariff_default);
    if ($('#lk_info_tariff_f').val() != lk_tariff_default) {
        $('#lk_buy').addClass('hidden');
    }
}

function lk_return_friend_update_coupon(data) {
    $('#lk_friend_coupon_s').html(data);
    $('#lk_friend_coupon').val(data);
    lk_change('friend', 'update', 'coupon');
}

function lk_edit_contacts_update_comm_method(data) {
    if ($('#lk_contacts_comm_method_s').html() == 'Звонок') {
        $('#lk_contacts_comm_method_s').html(lang.Call);
    }
}

function lk_switch_tariff_option(option, option_cost) {
    jconfirm(
        option.checked ? 
        lang.lk_tariff_options_enabled_msg1 + ' "' + option.nextElementSibling.innerHTML + '". ' + lang.lk_tariff_options_enabled_msg3: 
        lang.lk_tariff_options_disabled_msg1 + ' "' + option.nextElementSibling.innerHTML + '"? ' + (option.dataset.key == 'dev_acc' ? lang.lk_tariff_options_disabled_msg_dev : lang.lk_tariff_options_disabled_msg2),
        function() {
            $('#lk_content, #lk_content input, #lk_content a').css('cursor', 'wait');
            $.ajax({
                type: 'POST',
                url: 'edit_saas.php',
                data: 'set_options&option=' + option.value + '&key=' + option.dataset.key + '&status=' + (option.checked ? 1 : 0) + '&csrf=' + csrf,
                success: function (data) {
                    $('#lk_content, #lk_content input, #lk_content a').css('cursor', '');
                    if (data.slice(0, 5) == 'error') {
                        jalert(option.checked ? lang.lk_tariff_options_enabled_fail : lang.lk_tariff_options_disabled_fail);
                        option.checked = !option.checked;
                    } else if (data == 'is_actived') {
                        jalert(lang.lk_tariff_options_disabled_module);
                        option.checked = !option.checked;
                    } else {
                        jalert(option.checked ? 
                            lang.lk_tariff_options_enabled_success + (option.dataset.key == 'dev_acc' ? lang.lk_tariff_options_enabled_dev_account + ' "' + $('#lk_contacts_email_f').val() + '"' : '') : 
                            lang.lk_tariff_options_disabled_success);
                        $('#lk_expire_v b').html(data);
                        options_cost += option_cost * (option.checked ? 1 : -1);
                        lk_change_tariff_buy();
                        if (option.checked) option.disabled = true;
                        if (option.dataset.key == 'copyright_off' && !option.checked) {
                            $('#lk_domains_your_domain_f').val('');
                            lk_edit('domains', 'update', 'your_domain');
                            $('#lk_domains_your_domain_block').hide();
                        }
                    }
                }
            });
        },
        function() {
            option.checked = !option.checked;
        }
    );
}