import React from 'react';

export default ({ allIds, table, tabName, saveValue, editMode, editId }) => {
    function checkIsConfigTable() {
        for (let i = 0; i < allIds.length; i++) {
            const confObj = allIds[i];
            const confObjkey = Object.keys(confObj)[0];
            const confObjval = confObj[confObjkey];
            const curId = table[tabName]['id'];
            const wasDeleted = confObj['isDeleted'];

            if (confObjkey === curId && confObjval === tabName && !wasDeleted) return true;
        }
        return false;
    }

    if (checkIsConfigTable()) {
        return (<div className='table-settings-btn' />)
    } else {
        const closeBtnHidden = (editId && table[tabName]['id'] == editId) ? (!editMode ? ' hidden-1c' : '') : ' hidden-1c';

        return (
            <>
                <button
                    type="button"
                    className={`user-data__close-edit-btn table-settings-btn${closeBtnHidden}`}
                    id={`save-btn${table[tabName]['id']}`}
                    field_type="main-table"
                    table_1c={tabName}
                    table_cb={table[tabName]['name']}
                    table_id={table[tabName]['id']}
                    onClick={(e) => {
                        $(e.target).parent().parent().find('.chosen-container').each((i, item) => {
                            $(item).css('display', 'none');
                        });
                        saveValue(e);
                    }}
                />
            </>
        )
    }
};