'use strict';

import React, { useState, useRef, useEffect } from 'react';

export default function Expert({
    show = false,
    configHandler = null,
    closeHandler = null
}){
    const [ config, setConfig ] = useState(JSON.stringify(configHandler(), null, 4));

    const wrapperRef = useRef(null);

    useEffect(() => {
        if(show){
            document.addEventListener('mousedown', handlerClickOutside);
            setConfig(JSON.stringify(configHandler(), null, 4));
            console.log(config, JSON.stringify(configHandler(), null, 4));

            return () => {
                document.removeEventListener('mousedown', handlerClickOutside);
            }
        }
    });

    const handlerClickOutside = (e) => {
        if(wrapperRef && !wrapperRef.current.contains(e.target)){
            closeHandler();
        }
    }

    return (
       <div className="expert_container" style={{ display: (show ? 'block' : 'none') }}>
           <div ref={wrapperRef} className="expert_container-content">
                <div className="expert_container-content-title">
                    Режим эксперта.
                    <span className="expert_container-content-close" onClick={closeHandler}>
                        <img
                            style={{ cursor: 'pointer' }}
                            src="images/b_drop.png"
                        />
                    </span>
                </div>
                <div className="expert_container-content-textarea_block">
                    <textarea
                        name="configJSON"
                        value={config}
                        onChange={(e) => {
                            setConfig(e.target.value);
                        }}
                    />
                </div>
                <input type='hidden' name='edit_cron_mode' id='edit_cron_mode' />
                <input type='hidden' name='csrf' value={csrf} />
                <input type='hidden' name='save' value='1' />
                <input type='submit' name='save' className='btn btn-default btn-sm save-settings-btn' style={{ display: 'block', margin: 'auto', marginBottom: '1%' }} value={lang.Save} id="json_btn_submit" />
           </div>
       </div>
    )
}
