'use strict';

import { getLang } from "../../lang.js";

export function CallButton(_store, cbext_path){
    let l = getLang(config["lang"] == "russian" ? config["lang"] : "english");
    let store = _store;

    return {
        view: function(){
            return m('button', {
                onclick: () => {
                    if(!store.get('user_status').status){
                        jalert(store.get('user_status').message);
                        return;
                    }
                    else if(trim(store.get('params')['sip_login']) == '' || trim(store.get('params')['sip_password']) == ''){
                        jalert(l.You_are_not_authorized);
                        return;
                    }
                    store.get('showCallBlock')();
                },
                class: 'header__user-item',
            }, [
                m('img', {
                    style: 'width: 16px;height: 16px;cursor: pointer; filter: invert(1);',
                    src: `./${cbext_path}/assets/images/tel.png`,
                    alt: 'tel',
                }),
            ])
        }
    }
}
