import { components } from "../../../formLine.js?v=3";
import { formBaseElement } from "../../../formBaseElement.js";
import useScopedStyleMixin from '../../../useScopedStyleMixin.js';
import FormBlockStyles from './FormBlockStyles.js';

const FormBlock = {
  name: 'edit-form-block',
  components: components,
  mixins: [formBaseElement, useScopedStyleMixin, FormBlockStyles],
  data() {
    this.linesFromFields();
    return {
      table: null,
      componentClass: 'editform-block',
    }
  },
  methods: {
    setSelectedTable(option) {
      if(option.source === 'tables')
        this.table = option.value
    },
  },
  template: /*html*/`
    <div 
      v-if="showOn" 
      :class="componentClass + hash"
    >
      <div 
        v-if="toggleLink" 
        class="editform-toggle"
      >
        <a 
          href="#" 
          v-on:click="toggle" 
          :class="hidden 
            ? '' 
            : 'open'
          "
        >
          {{$t(toggleLink)}}
        </a>
      </div>
      <template v-if="toggleShow">
        <h4 
          v-if="element.header"
          :class="componentClass + '__header' + hash"
        >
          {{$t(element.header)}}
        </h4>
        <div 
          :class="componentClass + '__content' + hash"
        >
          <edit-form-line
            v-for="line in element.formLines" 
            :dataSource="dataSource" 
            :link="link" 
            :fieldsSource="fieldsSource" 
            :element="line"
            :table="table"
            @selectTable="setSelectedTable"
          />
          <component 
            v-for="(settings, name) in element.custom"
            :key="name" 
            :is="name" 
            v-bind:settings="settings" 
            :data="data" 
            :dataSource="dataSource" 
            :fieldsSource="fieldsSource" 
          />
          <div 
            v-if="element.message" 
            class="editform-message"
          > 
            <edit-form-message 
              :element="element.message" 
              :dataSource="dataSource"
              :status="element.message.status" 
              :width="element.message.width" 
            />
          </div>
          <div 
            style="margin: 0 auto"
            v-if="element.buttons"
          >
            <edit-form-button 
              v-for="button in element.buttons" 
              :element="button" 
            />
          </div>
        </div>
      </template>
    </div>
  `
};
export default FormBlock;