import { components } from "../../formLine.js?v=3";
import { formBaseElement } from "../../formBaseElement.js";
import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import ListFormStyles from './ListFormStyles.js';

const ListForm = {
  name: 'edit-listform',

  components: components,

  mixins: [formBaseElement, useScopedStyleMixin, ListFormStyles],

  data() {
    this.linesFromFields();
    this.blocksFromLines();
    return {
      names: {}, // имена для tables, groups, fields
      activeTable: 0, // id текущей таблицы для fields
      formDataSource: {},
      formStatus: "",
      editIndex: 0,
      componentClass: 'editform-form',
    }
  },
  provide() {
    return { formDataSource: Vue.reactive(this.formDataSource) }; // Если уже реактивный
  },
  methods: {
    //Меняем состояние формы
    flushForm(formStatus="", editIndex=0, newData) {
      let key = 0;
      Object.keys(this.formDataSource).forEach(key => {
        this.formDataSource[key] = "";
      });

      this.formStatus = formStatus;
      this.editIndex = editIndex;
      
      if (newData) {
        Object.assign(this.formDataSource, newData);
      }
    },
    //Показать форму редактирования элемента
    edit(index) {
      if(index == undefined || !this.actualDataSource[this.field][index])
        return;
      this.flushForm("edit", index, this.actualDataSource[this.field][index]);
      return false;
    },
    //Удалить элемент
    clearForm (index) {
      if(!index) return;
      if ((this.formStatus == "edit") && (this.editIndex == index)) {
        this.flushForm();
      }
    },
    //Показать форму добавления элемента
    add(e, newData = {}) {
      e.preventDefault();
      this.flushForm("add", 0, newData);
      return false;
    },
    //Добавить-изменить элемент (submit формы)
    save(e) {
      e.preventDefault();
      
      if (this.formStatus) {
        //TODO: проверка заполнения обязательных полей
        if (this.formStatus == "add") {
          if (!this.actualDataSource[this.field] || !this.actualDataSource[this.field].length) {
            this.actualDataSource[this.field] = [];
          }
          
          this.actualDataSource[this.field].push(Object.assign({

          }, this.formDataSource));
        }

        if (this.formStatus == "edit") {
          this.actualDataSource[this.field][this.editIndex] = Object.assign({}, this.formDataSource);
        }

        this.flushForm();
        this.store.save();
      }

      return false;
    },

    //Скрываем форму по кнопке "Отмена"
    reset(e) {
      e.preventDefault();
      this.flushForm();
    },

  },
  template: /*html*/`
    <template v-if="showOn">
      <div v-if="toggleLink" class="editform-toggle">
        <a 
          href="#" 
          @click="toggle" 
          :class="hidden ? '' : 'open'"
        >
          {{ $t(toggleLink) }}
        </a>
      </div>

      <section :class="componentClass + hash" v-if="toggleShow">
        <h3 
          :class="componentClass + '__header' + hash"
          v-if="element.header"
        >
          {{$t(element.header)}}
        </h3>
        <edit-list 
          :element="element"
          @edit="edit"
          @clearForm="clearForm"
        />
        <button
          v-if="!formStatus"
          :class="'btn btn-default'"
          @click="add($event)"
        >
          {{ $t(element.addButton ? element.addButton : 'editform_button_add') }}
        </button>
        <section
          v-if="formStatus"
          :class="componentClass + '__form-wrapper' + hash"
        >
          <form 
            @submit="save" 
            @reset="reset" 
            :class="componentClass + '__form' + hash"
          >
            <edit-form-block 
              v-for="block in element.formBlocks" 
              :dataSource="formDataSource" 
              :fieldsSource="formFieldsSource" 
              :element="block" 
            />
            <section 
              :class="componentClass + '__buttons' + hash"
            >
              <input 
                type="submit" 
                class="btn btn-default"  
                :value="(formStatus == 'edit') 
                  ? $t('editform_button_save') 
                  : $t('editform_button_add')" 
              />
              <input 
                type="reset" 
                class="btn btn-default" 
                :value="$t('editform_button_cancel')"
              />
            </section>
          </form>
        </section>
        

        <div v-if="element.drafts">
          <h3 v-if="element.drafts.header">
            {{$t(element.drafts.header)}}
          </h3>
          <template v-for="(draft, index) in actualDataSource[element.drafts.source]">
            <div 
              :class="'editform-formline'" 
              style="font-size: 14px;"
            >
              <a 
                href="#" 
                @click="add($event, draft)" 
                :title="'Создать такую интеграцию'"
              >
                <b style="color: green;font-size: 20px;">+</b>
              </a>
              <span>{{draft.name}} ({{draft.description}})</span>
            </div>
          </template>
        </div>
      </section>
    </template>
  `
};

export default ListForm;