import useTranslate from "../../../../../hooks/useTranslate.js";

const EMPTY_VALUES = ['', '[]', 'undefined', 'null', 'NaN'];

const isEmpty = (value) => EMPTY_VALUES.includes(String(value));

const Dropdown = {
  components: { 'Dropdown': primevue.dropdown },

  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    options: Object,
    required: Boolean,
    size: String,
    width: String,
  },

  setup(props, { emit }) {
    return {
      useTranslate: useTranslate,
    }
  },
  methods: {
    setDropdownWidth(e) {
      let width;

      if (e.target.classList.contains('p-dropdown')) {
        width = e.target.offsetWidth
      } else {
        width = e.target.closest('.p-dropdown').offsetWidth
      }

      if (document.querySelector('.refreshable-style')) {
        document.querySelector('.refreshable-style').remove()
      }

      let style = document.createElement('style')
      style.classList.add('refreshable-style')
      document.body.prepend(style)
    },
  },
  computed: {
    optionsWithEmpty () {
      const arr = [];
      if (!this.required) {
        arr.push({ id: '', name: '---' });
      }
      for (const [key, value] of Object.entries(this.options || {})) {
        arr.push({ id: key, name: value });
      }
      return arr;;
    },
    stringValue: {
      get() {
        const value = this.dataSource[this.storeFieldId]
        if (this.required && isEmpty(value)) {
          const firstOptions = this.optionsWithEmpty.length > 0 ? this.optionsWithEmpty[0].id : ''
          this.dataSource[this.storeFieldId] = firstOptions;
          return firstOptions;
        };
        if (isEmpty(value)) return '';

        return String(value) || '';
      },
      set(value) {
        if(isEmpty(value))
          return this.dataSource[this.storeFieldId] = '';
        this.dataSource[this.storeFieldId] = isNaN(value) ? value : Number(value);
      }
    }
  },
  template: /*html*/`
    <Dropdown
      v-model="stringValue"
      :options="optionsWithEmpty"
      optionLabel="name"
      optionValue="id"
      :emptyMessage="useTranslate('No_data')"
      :emptyFilterMessage="useTranslate('No_filter_results')"
      :fieldsize="size"
      @click="setDropdownWidth"
      :style="{ width: '206px', flex: \`1 0 206px\` }"
    />
  `
};

export default Dropdown;