import Dropdown from "./Dropdown/Dropdown.js";
import DatetimeCondition from "./DatetimeCondition/DatetimeCondition.js";
import Link from "./Link/Link.js";
import RadioButton from "./RadioButton/RadioButton.js";
import Checkbox from "./Checkbox/Checkbox.js";

const c = {};

c['input-text'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="text" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control" autocomplete="off"/>
  `,
};

c['input-file'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="file" :required="required" v-model="dataSource[storeFieldId]" autocomplete="off"/>
    <template v-if="dataSource[storeFieldId]">
      <span class="file-field-value">{{dataSource[storeFieldId]}}</span>
    </template>
  `,
};

c['input-password'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="password" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control" autocomplete="off"/>
  `,
};

c['link'] = Link;

c['input-textarea'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <textarea 
      :required="required" 
      v-model="dataSource[storeFieldId]" 
      :fieldsize="size" 
      class="form-control"
    ></textarea>
  `
};

c['dropdown'] = Dropdown;

c['checkbox'] = Checkbox;

c['radiobutton'] = RadioButton;


c['colorpicker'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String
  },

  template: /*html*/`
    <input type="text" class="colorSelector" id="{{storeFieldId}}" :value="dataSource[storeFieldId]">
    <input type=hidden name="{{storeFieldId}}" v-model="dataSource[storeFieldId]">
  `
};

c['input-date'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="date" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control" />
  `,
};

c['input-datetime'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="datetime-local" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control"  />
  `,
};

c['datetime-condition'] = DatetimeCondition;

c['html'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
  },

  template: /*html*/`
    <div v-html="dataSource[storeFieldId]"></div>
  `,
};

export const components = c;
