import useKOSearchBlockStore from "./../store/index.js";
import useBuildClassName from "../hooks/useBuildClassName.js";
import useBuildStyle from "../hooks/useBuildStyle.js";
import useBuildText from "../hooks/useBuildText.js";
import useBuildHref from "../hooks/useBuildHref.js";


/** Компонент представления ячеек */
export const CellViewComponent = {
  props: ['column', 'row'],

  setup(props, {emit}) {
    const store = useKOSearchBlockStore();

    const text = useBuildText(
      (props.row[props.column.column_name] || ''),
      {
        field_type: Number(props.column['field_type'] || 0),
        without_time: (props.column['field_type_value'] == '0')
      }
    );

    return {
      store,
      text,
      buildClassName: useBuildClassName,
      buildStyle: useBuildStyle,
      buildHref: useBuildHref,
    }
  },

  template: /*html*/`
    <span v-if='store.use_links == "none"' v-html="text"></span>
    <a
      v-else
      :class="buildClassName(store.use_links)"
      :style="buildStyle(store.use_links)"
      :href="buildHref(store.table_id, column, row)"

      target="_blank"
      v-html="text"
    ></a>
  `
}

// стили компонента
CB.styles.globed(/*css*/`
  .__KO__cell-view-component__marker {
    background-color: #fff6b0;
  }
`);
