import { FIELD_LINK } from "../../../../constants.js";


/**
 * Сформировать url тэга <а>
 * @param {object} column
 * @param {object} row
 * @returns
 */
export default function(table_id, column, row) {
  const linked_table_id = column['field_type_value'].split('|', 1) || 0;
  const href_linkid = row[column['column_name'] + '_href_linkid'] || 0;
  const href_rowid = row[column['column_name'] + '_href_rowid'] || 0;

  switch (column['field_type']) {
    case FIELD_LINK:
      return 'view_line2.php?table=' + linked_table_id + '&line=' + href_linkid;

    default:
      return 'view_line2.php?table=' + table_id + '&line=' + href_rowid;
  }
}
