'use strict';

export function Select(){
    return {
        oncreate: function (vnode) {
            if(!vnode.attrs.class || vnode.attrs.class && vnode.attrs.class.match('dont_use_chosen') === null){
                $(vnode.dom).find('select').chosen();
            }
        },
        onupdate: function (vnode) {
            $(vnode.dom).find('select').chosen('destroy');
            if(!vnode.attrs.class || vnode.attrs.class && vnode.attrs.class.match('dont_use_chosen') === null){
                $(vnode.dom).find('select').chosen();
            }
        },
        onremove: function (vnode) {
            if(!vnode.attrs.class || vnode.attrs.class && vnode.attrs.class.match('dont_use_chosen') === null){
                $(vnode.dom).find('select').chosen('destroy');
            }
        },
        view: function(vnode){
            return m('span', {}, m('select', {
                id: vnode.attrs.id || '',
                class: vnode.attrs.class || '',
                style: vnode.attrs.style || '',
                value: vnode.attrs.value,
                onchange: vnode.attrs.onchange || ''
            }, vnode.children));
        }
    }
}
