/**
 * Получить настройки поля.
 */
function _s2_getFieldSettings(element) {
  const select = $(element);

  const select_id = select.attr('id') || '';
  const mode      = select.attr('data-mode') || 'undefined';

  const field_id  = Number(select.attr('data-field-id')) || 0;
  const table_id  = Number(select.attr('data-table-id')) || 0;
  const required  = (select.attr('required') || '') == 'required';
  const line_id   = Number(select.attr('data-line-id')) || 'undefined';

  const old_value = (select.attr('data-previously-value') || '').split(','); // array [1, 2]
  const new_value = select.val() || ''; // array [1, 2]

  const record_id = (
    typeof line_id === 'undefined' || mode === 'subtable'
  ) ? (Number(element.attr('data-line-id')) || 0) : line_id;

  return {
    select_id,    // Идентификатор элемента верстки
    mode,         // Положение отображения "Просмотр записи", "Подтаблица", ...
    field_id,     // Идентификатор поля
    table_id,     // Идентификатор таблицы
    required,     // Обязательное для заполнения
    line_id,      // Идентификатор записи
    old_value,    // Старое значение в поле
    new_value,    // Новое значение в поле
    record_id,    // Идентфикатр записи
  };
}

/**
 * Ajax запрос данных с сервера.
 */
function _s2_ajax() {
  return {
    url: 'questionare.php',
    type: 'GET',
    delay: 250,
    quietMillis: 100,
    dataType: 'json',
    cache: true,
    headers: {"Content-Type": "application/json"},

    // изменить параметры, отправляемые вместе с запросом,
    data: function (params) {
      return {
        'content-type': 'json',
        sel: 'link_value',
        q: params.term,
        field: $(this).attr('data-field-id'),
        qst_id: (new URL(location.href)).searchParams.get('id'),
        timestamp: +new Date()
      }
    },

    // Обработчик ответа от сервера
    processResults: function(data) {
      let results = data.map(item => ({id: item.id, text: item.text, additional: item.additional}));
      const { new_value } = _s2_getFieldSettings($(this.$element));
      return {
        results: results.filter(item => !new_value.includes(item.id))
      };
    }
  };
}

/**
 * сформировать доп.поля
 * @param {Array} data
 * @returns
 */
function _s2_buildViewOfAdditionalFields(data) {
  let additional = '';
  if (data instanceof Array) {
    data.forEach(i => { additional += `<span>${i}</span>`; });
  }
  return additional;
}

/**
 * Обработчик события изменения значения в select
 * @param {event} event
 */
function _s2_handleChange(event) {
  const element = $(event.target);
  let { new_value } = _s2_getFieldSettings(element);
  $(element).attr('f_value', new_value.join('-'))
}


/**
 * После загрузки страницы выполнить настройку плагина
 */
$(document).ready(function() {
  // язык, используемый для сообщений
  $.fn.select2.defaults.set('language', {
    searching: () => '', // ((lang?.Search || 'Search') + '...'),
    noResults: () => (lang?.No_data || 'Search'),
    errorLoading: () => '', // Не удалось загрузить результаты.
  });

  // Обеспечивает поддержку источников данных через ajax запросы
  $.fn.select2.defaults.set('ajax', _s2_ajax());

  // Обрабатывает автоматическое экранирование содержимого, отображаемого с помощью пользовательских шаблонов.
  $.fn.select2.defaults.set('escapeMarkup', markup => markup);

  // Настраивает способ отображения результатов выбора.
  $.fn.select2.defaults.set('templateSelection', state => `
    <div class="select2-selection__choice__text">${state.text}</div>
  `);

  // Настраивает способ отображения результатов поиска в выпадающем списке.
  $.fn.select2.defaults.set('templateResult', function(state) {
    if (!state.id) return state.text;

    let additional = _s2_buildViewOfAdditionalFields(state?.additional || []);
    return $(`<div><span>${state.text}</span>${additional}</div>`);
  });


  const select2_plugin = $('.select2-plugin');
  select2_plugin.each((index, item) => {
    $(item).select2({});
  });

  select2_plugin.on('change', _s2_handleChange);
});
