{*
 Шаблон вычисления "Сохранить шаблон печати в файл"
*}

$form = sql_select_array(FORMS_TABLE, 'id = ' . get_form_id({$print_tpl}));
$form['doc_name'] = form_template($form, $line, 'doc_name');
if ($form['type_form'] == 2 && $form['pdf_import'] == 1) {
    $mpdf = new \Mpdf\Mpdf([
        'tempDir' => $config['site_path'] . '/temp',
        'format' => 'A4' . $form['orientation'],
        'margin_left' => $form['margin_left'],
        'margin_right' => $form['margin_right'],
        'margin_top' => $form['margin_top'],
        'margin_bottom' => $form['margin_bottom']
    ]);     
    $mpdf->SetDisplayMode('fullwidth');
    $form['head_page'] = str_replace(['[[', ']]'], ['{ldelim}ldelim{rdelim}', '{ldelim}rdelim{rdelim}'], $form['head_page']);
    $form['foot_page'] = str_replace(['[[', ']]'], ['{ldelim}ldelim{rdelim}', '{ldelim}rdelim{rdelim}'], $form['foot_page']);
    $mpdf->SetHTMLHeader(form_template($form, $line, 'head_page'));
    $mpdf->SetHTMLFooter(form_template($form, $line, 'foot_page'));
    if ($form['head_form'] != '') {
        $mpdf->WriteHTML(form_template($form, $line, 'head_form'));
    }
    $mpdf->WriteHTML(form_template($form, $line, 'body_form'));
    if ($form['foot_form'] != '') {
        $mpdf->WriteHTML(form_template($form, $line, 'foot_form'));
    }
    $file_name = $form['doc_name'] . '.pdf';
    $form_text = $mpdf->Output($file_name, 'S');
    $save_link = substr('{$field}', 1);
    save_data_file($save_link, $ID, $file_name, $form_text);
    $line['{$field}'] = $file_name;
} else {
    if ($form['type_form'] == 5) {
        $file_name = $form['doc_name'] . '.docx';
    } else if ($form['type_form'] == 3) {
        $file_name = $form['doc_name'] . '.rtf';
    } else if ($form['type_form'] == 4) {
        $file_name = $form['doc_name'] . '.odt';
    } else if ($form['type_form'] == 6) {
        $file_name = $form['doc_name'] . '.xls';
    }
    $save_link = substr('{$field}', 1);
    save_data_file($save_link, $ID, $file_name, form_template($form, $line, 'body_form'));
    $line['{$field}'] = $file_name;
}