<td colspan="2" align="center">
  <h2>{$params_tpl['title']|default:''}{$params_tpl['help']|default:''}</h2>
  <div style="display: flex; flex-direction: column;">{$tpl_types['field']|default:''}</div>
  <div style="display: flex; flex-direction: column;">{$tpl_types['cur_field']|default:''}</div>
  <div class="case-type" style="display: flex; flex-direction: column;">{$tpl_types['case_type']|default:''}</div>
  <div style="display: flex; flex-direction: column;">{$tpl_types['value']|default:''}</div>
  <div id="day_off{$tpl_num}" style="display: flex; flex-direction: column;">{$tpl_types['day_off']|default:''}</div>
  <div id="holiday{$tpl_num}" style="display: flex; flex-direction: column;">{$tpl_types['holiday']|default:''}</div>
  <div id="gen_field_container_{$tpl_num}" style="display: none; flex-direction: column;">{$tpl_types['gen_field']|default:''}</div>
  <div id="time_container_{$tpl_num}" style="display: none; flex-direction: column;">{$tpl_types['time']|default:''}</div>
  <div id="time_work_on_container_{$tpl_num}" style="display: none; flex-direction: column;">{$tpl_types['time_work_on']|default:''}</div>
  <div id="time_work_off_container_{$tpl_num}" style="display: none; flex-direction: column;">{$tpl_types['time_work_off']|default:''}</div>
  <div style="display: flex; flex-direction: column;">{$tpl_types['case_measure']|default:''}</div>
  <div style="display: flex; flex-direction: column;">{$tpl_types['floor_round']|default:''}</div>
</td>

{assign var="current_date_text" value="текущая дата и время"}

<script>
(function() {
    let tplNum = "{$tpl_num|escape:'js'}";

    let fieldSelect = $('select[name="calc_params[' + tplNum + '][field]"]');
    let curFieldSelect = $('select[name="calc_params[' + tplNum + '][cur_field]"]');
    let caseType = $('[name="calc_params[' + tplNum + '][case_type]"]');
    let caseMeasure = $('[name="calc_params[' + tplNum + '][case_measure]"]');
    let holidayCheckbox = $('#holiday' + tplNum + ' input[type=checkbox]');
    let timeCheckbox = $('#time_container_' + tplNum + ' input[type=checkbox]');
    
    let constructParams = {$construct_params|json_encode nofilter};
    let currentField = constructParams.params?.[tplNum]?.field ?? '';
    let currentCurField = constructParams.params?.[tplNum]?.cur_field ?? '';

    if (currentField === "currentDate") {
      fieldSelect.append('<option selected value="currentDate">{$current_date_text}</option>');
    } else {
      fieldSelect.append('<option value="currentDate">{$current_date_text}</option>');
    }
    fieldSelect.trigger("chosen:updated");

    if (currentCurField === "currentDate") {
      curFieldSelect.append('<option selected value="currentDate">{$current_date_text}</option>');
    } else {
      curFieldSelect.append('<option value="currentDate">{$current_date_text}</option>');
    }
    curFieldSelect.trigger("chosen:updated");

    function toggleWorkTimeFields() {
      let showWorkTime = timeCheckbox.is(':checked');
      $('#time_work_on_container_' + tplNum + ', #time_work_off_container_' + tplNum).css('display', showWorkTime ? 'flex' : 'none');
    }

    function toggleHolidayFields() {
      let showHolidayFields = holidayCheckbox.is(':checked');
      $('#gen_field_container_' + tplNum).toggle(showHolidayFields);
    }

    function toggleTimeCheckbox() {
      let showTimeCheckbox = caseType.val() === '2' && ['1', '2', '3'].includes(caseMeasure.val());
      $('#time_container_' + tplNum).toggle(showTimeCheckbox);
      $('#time_work_on_container_' + tplNum + ', #time_work_off_container_' + tplNum).css('display', (showTimeCheckbox && timeCheckbox.is(':checked')) ? 'flex' : 'none');
    }

    function toggleCaseMeasure() {
      let showCaseMeasure = caseType.val() === '2'; // 2 corresponds to "Число"
      $('.correlation__row:has([name="calc_params[' + tplNum + '][case_measure]"])').toggle(showCaseMeasure);
    }

    $(document).ready(function(){
      $('.case-measure, .floor_round').toggle(caseType.val() == '2');
      $('[name="calc_params[{$tplNum}][value]"] option[data-type="3"]').toggle(caseType.val() == '1');
      $('[name="calc_params[{$tplNum}][value]"] option[data-type="1"]').toggle(caseType.val() == '2');
      toggleWorkTimeFields();
      toggleHolidayFields();
      toggleTimeCheckbox();
      toggleCaseMeasure();
    });

    caseType.change(function(){
      $('.case-measure, .floor_round').toggle(caseType.val() == '2');
      $('[name="calc_params[{$tplNum}][value]"] option[data-type="3"]').toggle(caseType.val() == '1');
      $('[name="calc_params[{$tplNum}][value]"] option[data-type="1"]').toggle(caseType.val() == '2');
      $('[name="calc_params[{$tplNum}][value]"] option[data-type="3"]:first').prop('selected', caseType.val() == '1');
      $('[name="calc_params[{$tplNum}][value]"] option[data-type="1"]:first').prop('selected', caseType.val() == '2');
      $('.floor_round option[value="1"]').prop('selected', true);
      toggleTimeCheckbox();
      toggleCaseMeasure();
    });

    caseMeasure.change(toggleTimeCheckbox);
    holidayCheckbox.change(toggleHolidayFields);
    timeCheckbox.change(toggleWorkTimeFields);

    toggleWorkTimeFields();
    toggleHolidayFields();
    toggleTimeCheckbox();
    toggleCaseMeasure();
})();
</script>
