{include file="mobile/templates/index_top.tpl"}

<div class="pages navbar-through toolbar-through">
    <!-- Page, "data-page" contains page name -->
    <div data-page="login" class="page">
        <!-- Scrollable page content -->
        <div class="page-content">

            <script type="text/javascript">
                {if $mobile_app && $mob_app_logout}
                window.location.href = 'https://{$config.clientbase_domain}/mobile-app'; // Перебрасываем на ввод адреса в мобильном приложении
                {/if}
                // Запоминанем разрешение экрана
                if (window.devicePixelRatio >= 2) {
                    $.cookie("screen_width", screen.width * 2);
                    $.cookie("screen_height", screen.height * 2);
                }
                else {
                    $.cookie("screen_width", screen.width);
                    $.cookie("screen_height", screen.height);
                }

                // Считываем режим https
                if (location.protocol == "https:")
                    $.cookie("s_protocol", "s");
                else
                    $.cookie("s_protocol", null);
            </script>

            <form name="form_login" action="login.php" method="post">
                <!-- <div class="content-block-title">{$lang.Authorization}</div> -->
                <div class="content-block-title authorization-title" style="padding: 0px !important"></div>

                <div class="content-block">
                    {if $config.anti_bot_active == 2}
                        <div class="alert alert-danger">
                            {$lang.anti_bot_mess1}{$lang.anti_bot_mess1_10_min}
                            <br>{$lang.anti_bot_mess2}{$wait_time}{$lang.anti_bot_mess2_10_min}
                        </div>
                    {elseif $config.anti_bot_active == 3}
                        <div class="alert alert-danger">
                            {$lang.anti_bot_mess1}{$lang.anti_bot_mess1_10_hour}
                            <br>{$lang.anti_bot_mess2}{$wait_time}{$lang.anti_bot_mess2_10_hour}
                        </div>
                    {else}
                        {if $error}
                            <div class="alert alert-danger">
                                {$error}
                            </div>
                        {/if}
                    {/if}
                    {if $double_session eq 1}
                        <div class="alert alert-danger">
                            {$lang.other_browser_login}
                        </div>
                        {if $save_enter_checked}
                            <input type="hidden" name="double_session" value="1"/>
                        {/if}
                    {/if}
                </div>

                <div class="list-block">
                    <ul>
                        <li>
                            <div class="item-content">
                                <div class="item-inner">
                                    <div class="item-input">
                                        <input type="text" name="login" value="{$user_login}"
                                               placeholder="{$lang.Login}">
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="item-content">
                                <div class="item-inner">
                                    <div class="item-input">
                                        <input type="password" name="password" value="{$user_pass}" autocomplete="off"
                                               placeholder="{$lang.Password}">
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <input type="hidden" name="csrf" value="{$csrf}">

                <div class="content-block m__form-group--login-btn">
                    <input type="submit" class="button button-big button-submit" value="{$lang.Enter}">
                </div>

                <div class="login__footer">
                    <div align="center" class="filter">
                        <a href="login.php?restore_pass">{$lang.forget_password}</a>
                    </div>
                    <div align="center" class="filter change-version-btn">
                        {if !$mobile_app}
                            <a id="a_bottom"
                               href=""
                               onclick="location.href='login.php?set_mobile=0'; return false;">{$lang.For_computer}</a>
                        {else}
                            <a 
                                onclick="location.href='http://{$config.clientbase_domain}/mobile-app/?delete_cookie=1'; return false;"
                            >{$lang.Enter_another_address}</a>
                        {/if}
                    </div>
                </div>
            </form>

