import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import CheckboxStyles from './CheckboxStyles.js';

const Checkbox = {
  name: 'checkbox',
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    options: Object,
    required: String
  },
  data() {
    return {
      componentClass: 'checkbox',
    }
  },
  mixins: [useScopedStyleMixin, CheckboxStyles],

  template: /*html*/`
    <div
      :class="componentClass + hash"
    >
      <label
        v-if="options"
        v-for="(option, value) in options"
        :class="componentClass + '__label' + hash"
      >
        <input 
          type="checkbox" 
          :value="value" 
          v-model="dataSource[storeFieldId]" 
        /> 
        {{ option }}
      </label>
      <input 
        v-else 
        type="checkbox" 
        :required="required" 
        v-model="dataSource[storeFieldId]" 
      />
    </div>
  `
};

export default Checkbox;