const Link = {
  name: 'form-link',
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    link: Object,
  },
  computed: {
    translatedText () {
      if(this.link.text) return this.$t(this.link.text)
    }
  },
  template: /*html*/`
    <a
      target="_blank"
      :href="link.href"
    >
      {{ translatedText }}
    </a>
  `,
};

export default Link;