/**
 * Компонент Блок Текста
 */
import { useBlocksStore } from '../storeBlocks.js'
import { useRecordsStore } from '../storeRecords.js'
import { useRecordEditorStore } from '../storeRecordEditor.js'

const template = /*html*/`
<p-panel :header="blockinfo.title" toggleable="true" class="mt-2 mb-2 shadow-2 border-round">
  <template #icons>
    <p-button icon="pi pi-times" @click="delBlock(blockinfo.id)" class="p-panel-header-icon p-button-rounded p-button-text mr-2"></p-button>
  </template>
  <div class="card">
    <p-datatable
      :value="records" :scrollable="true" scroll-height="400px" scroll-direction="both"
      removable-sort responsive-layout="scroll"
      :resizableColumns="true" column-resize-mode="fit" show-gridlines
    >
      <template #empty>
        No data found.
      </template>
      <template #loading>
        Loading data. Please wait.
      </template>
      <p-column>
        <template #header>
        <p-button icon="pi pi-pencil" class="p-button-rounded p-button-text" :disabled="true"></p-button>
        </template>
        <template #body="slotProps" header-style="width: 4rem; text-align: center" body-style="text-align: center; overflow: visible">
          <p-button icon="pi pi-pencil" class="p-button-rounded p-button-text" @click="showRecordEditor(blockinfo.table_id, slotProps.data.id)"></p-button>
        </template>
      </p-column>
      <p-column v-for="col of columns" :field="col.int_name" :header="col.field_name" :key="col.id" :style="{width:'150px'}" :sortable="true"></p-column>
    </p-datatable>
  </div>
</p-panel>
`;

export default {
  template,
  components: {
    "p-button": primevue.button,
    "p-toolbar": primevue.toolbar,
    "p-panel": primevue.panel,
    "p-datatable": primevue.datatable,
    "p-column": primevue.column,
  },

  props: ['blockid'],
  setup(props) {
    const storeBlocks = useBlocksStore()
    const blockinfo = storeBlocks.getBlock(props.blockid)
    const recordEditor = useRecordEditorStore()
    const store = useRecordsStore()

    const records = Vue.ref([
      // {"brand": "Volkswagen", "year": 2012, "color": "Orange", "vin": "dsad231ff"},
      // {"brand": "Audi", "year": 2011, "color": "Black", "vin": "gwregre345"},
      // {"brand": "Renault", "year": 2005, "color": "Gray", "vin": "h354htr"},
      // {"brand": "BMW", "year": 2003, "color": "Blue", "vin": "j6w54qgh"},
      // {"brand": "Mercedes", "year": 1995, "color": "Orange", "vin": "hrtwy34"},
      // {"brand": "Volvo", "year": 2005, "color": "Black", "vin": "jejtyj"},
      // {"brand": "Honda", "year": 2012, "color": "Yellow", "vin": "g43gr"},
      // {"brand": "Jaguar", "year": 2013, "color": "Orange", "vin": "greg34"},
      // {"brand": "Ford", "year": 2000, "color": "Black", "vin": "h54hw5"},
      // {"brand": "Fiat", "year": 2013, "color": "Red", "vin": "245t2s"},
    ])

    const columns = Vue.ref([
      // { int_name: 'brand', field_name: 'Brand', id: 1 },
      // { int_name: 'year', field_name: 'Year', id: 2 },
      // { int_name: 'color', field_name: 'Color', id: 3 },
      // { int_name: 'vin', field_name: 'VIN', id: 4 },
    ])

    store.query(`table/${blockinfo.table_id}?include=fields`).then(() => {
      const metadata = store.find('table', blockinfo.table_id)
      columns.value = metadata.getRelationship('fields')
    })

    store.query(`data${blockinfo.table_id}`).then(() => {
      records.value = store.findAll(`data${blockinfo.table_id}`)
    })

    return {
      blockinfo,
      delBlock: storeBlocks.delBlock,
      records,
      columns,
      showRecordEditor: recordEditor.showRecordEditor,
    }
  },
}

CB.styles.globed(/*css*/`
`);
