import _mainComponent from './mainComponent.js';
import modalWindow from './modalWindow.js';


/** Инициализация kanban приложения */
export default async function(id, json) {
  json['kanban_id'] = id;

  let mainComponent = _mainComponent(json);

  let components = {
    [mainComponent.name]: mainComponent,
    [modalWindow.name]: modalWindow,
  };

  let app = await Vue.createApp({});

  for (let name in components) {
    app.component(name, components[name]);
  }

  await app.mount(`#${id}`);
  // document.getElementById(`${id}`).style.display = 'block';

  if (document.getElementById(id)) {
    let new_value = (
      Object.values(document.getElementById(id)?.classList || {})
    ).filter(item => item != 'kanban_div_container_hide').join(' ');

    document.getElementById(id).classList = `${new_value} kanban_div_container_show`;
  }
}
