/**
 * hamburger-menu - Выпадающее меню
 */
export default Vue.defineCustomElement({
  props: ['list'],

  setup(props, {emit}) {
    return {
      items: JSON.parse(props.list) || []
    }
  },

  template: /*html*/`
    <div class="menu">
      <div class="hamburger"></div>

      <nav class="menu-items">
        <template v-for="item in items">
          <a
            v-if="typeof item.href !== 'undefined'"
            :href="item.href"
            target="_blank"
            class="menu-item__link"
          >{{ item.label }}</a>
          <div v-else-if="item.element == 'line' && items.length > 2" class="menu-item__line"></div>
          <span v-else>{{ item.label }}</span>
        </template>
      </nav>
    </div>
  `,

  styles: [/*css*/`
    .menu {
      width: max-content;
      margin: 0 15px;
      position: relative;
    }

    .hamburger {
      width: 20px;
      height: 20px;
      cursor: pointer;
      padding: 2px 2px 4px 2px;
      z-index: 36;
      position: relative;
      border-radius: 6px 6px 0 0;
    }

    .hamburger::before {
      content: '';
      width: 20px;
      height: 20px;
      display: block;
      background-position: center;
      background-image: url(themes/clientbase/img/icon_dropmenu.svg);
      background-repeat: no-repeat;
      position: relative;
      z-index: 36;
    }

    .menu:hover {
      opacity: 1;
      box-shadow: rgba(69, 69, 69, 0.3) 0px 0 5px 2px, inset 0px -5px 0px 0px rgba(255,255,255,1);
      border-radius: 6px 6px 0 0;
      background: #ffffff;
    }

    .menu-items {
      padding: 5px;
      display: flex;
      flex-direction: column;
      align-items: center;
      transform: scale(1, 0);
      transform-origin: top left;
      opacity: 0;
      transition: .2s;
      border-radius: 7px 0 7px 7px;
      background-color: #fff;
      box-shadow: rgba(69, 69, 69, 0.3) 0px 0 5px 2px;
      overflow: auto;
      overflow-x: hidden;
      overflow-y: auto;
      max-height: 306px;
      position: absolute;
      z-index: 700;
      right: 0px;
      width: max-content;
      max-width: 250px;
      overflow-wrap: anywhere;
    }

    .menu-item__link {
      color: #000;
      font-weight: bold;
      white-space: nowrap;
      font-size: 14px;
      padding: 5px 10px;
      text-decoration: none;
      background: none;
      text-align: center;
      width: 100%;
    }

    .menu-item__link:hover {
      background: #eee;
    }

    .menu-item__line {
      width: 80%;
      border: none;
      border-top: 1px solid #ddd;
    }

    .menu:hover>.menu-items {
      transform: scale(1);
      opacity: 1;
    }
  `],
});
