#!/bin/bash
# Скрипт подготовки библиотеки PrimeVue к интеграции в КБ.
#
# Порядок работы:
# 1) Скопировать скрипт (или сделать симлинк) в отдельную временную папку
# 2) Запустить на выполнение, указав требуемые версии PrimeVue, PrimeIcons, PrimeFlex и название темы
# 3) Положить полученные папки в дистрибутив (заменив существующие)
#
# Запуск на выполнение:
#     bash primevue-compile.sh PRIMEVUE_VERSION PRIMEICONS_VERSION PRIMEFLEX_VERSION PRIME_THEME
#     bash primevue-compile.sh 3.11.0 5.0.0 3.1.2 saga_blue

PRIMEVUE_VERSION=$1
PRIMEICONS_VERSION=$2
PRIMEFLEX_VERSION=$3
PRIME_THEME=$4

###  PrimeVue
##
PRIMEVUE_NAME=primevue-$PRIMEVUE_VERSION
PRIMEVUE_ONE_FILE=$PRIMEVUE_NAME/primevue.min.js

wget https://registry.npmjs.org/primevue/-/$PRIMEVUE_NAME.tgz
mkdir $PRIMEVUE_NAME
tar -xzf $PRIMEVUE_NAME.tgz --directory=$PRIMEVUE_NAME

touch $PRIMEVUE_ONE_FILE
cat $PRIMEVUE_NAME/package/core/core.min.js >>$PRIMEVUE_ONE_FILE
cat $PRIMEVUE_NAME/package/utils/utils.min.js >>$PRIMEVUE_ONE_FILE
for d in $PRIMEVUE_NAME/package/*/ ; do
    f=$(basename $d)
    case "$f" in
      core | utils) ;; # эти скрипты интегрированы ранее
      menuitem | confirmationoptions | resources) ;; # это не компоненты
      editor | fullcalendar) ;; # эти компоненты не берем
      *) cat $d$f.min.js >>$PRIMEVUE_ONE_FILE ;;
    esac
done

cp $PRIMEVUE_NAME/package/LICENSE.md $PRIMEVUE_NAME/
cp $PRIMEVUE_NAME/package/README.md $PRIMEVUE_NAME/
cp $PRIMEVUE_NAME/package/resources/primevue.min.css $PRIMEVUE_NAME/
cp -r $PRIMEVUE_NAME/package/resources/themes/$PRIME_THEME $PRIMEVUE_NAME/

rm -rf $PRIMEVUE_NAME/package

###  PrimeIcons
##
PRIMEICONS_NAME=primeicons-$PRIMEICONS_VERSION

wget https://registry.npmjs.org/primeicons/-/$PRIMEICONS_NAME.tgz
mkdir $PRIMEICONS_NAME
tar -xzf $PRIMEICONS_NAME.tgz --directory=$PRIMEICONS_NAME

cp $PRIMEICONS_NAME/package/LICENSE $PRIMEICONS_NAME/
cp $PRIMEICONS_NAME/package/README.md $PRIMEICONS_NAME/
cp $PRIMEICONS_NAME/package/primeicons.css $PRIMEICONS_NAME/
cp -r $PRIMEICONS_NAME/package/fonts $PRIMEICONS_NAME/

rm -rf $PRIMEICONS_NAME/package

###  PrimeFlex
##
PRIMEFLEX_NAME=primeflex-$PRIMEFLEX_VERSION

wget https://registry.npmjs.org/primeflex/-/$PRIMEFLEX_NAME.tgz
mkdir $PRIMEFLEX_NAME
tar -xzf $PRIMEFLEX_NAME.tgz --directory=$PRIMEFLEX_NAME

cp $PRIMEFLEX_NAME/package/README.md $PRIMEFLEX_NAME/
cp $PRIMEFLEX_NAME/package/primeflex.min.css $PRIMEFLEX_NAME/
cp $PRIMEFLEX_NAME/package/themes/$PRIME_THEME.css $PRIMEFLEX_NAME/

rm -rf $PRIMEFLEX_NAME/package
