/**
 * @author Ramil <rep555333@gmail.com>
 *
 * Все элементы имею следующий тип id -> elemName-{tpl_num}-{correlation-num}
 */

let preventOptionSave = false;

const createElement = (template) => {
    const frag = document.createDocumentFragment();
    const emptyElem = document.createElement(`DIV`);
    emptyElem.innerHTML = template;
    Array.from(emptyElem.childNodes).forEach((child) => {
        frag.appendChild(child);
    });

    return frag;
};

const getDataFromSelectVal = (select, attr = ``) => {
    let result;

    if (select) {
        for (const option of select) {
            if (select.value === option.value) {
                if (attr !== ``) {
                    result = option.getAttribute(attr);
                } else {
                    result = option.innerHTML;
                }
                break;
            }
        }
    }

    return result;
};

const getOptions = (data, defaultVal = false) => {
    let result = ``;

    for (const key in data) {
        const val = data[key];
        const option = (!defaultVal) ?
            `<option value="${key}" data-type="${val.type_field}">${val.name_field}</option>` :
            `<option value="${key}">${val}</option>`;
        result += option;
    }

    return result;
};

const getSortOptions = (data, defaultVal = false) => {
    let result = ``;
    let sort_obj = {};
    for (const key in data) {
        const val = data[key];
        if (val.field_num) {
            sort_obj[val.field_num] = key;
        }
    }
    for (const key in sort_obj) {
        const val = data[sort_obj[key]];
        const option = (!defaultVal) ?
            `<option value="${sort_obj[key]}" data-type="${val.type_field}">${val.name_field}</option>` :
            `<option value="${sort_obj[key]}">${val}</option>`;
        result += option;
    }
    return result;
};


class Correlation extends EditButton {
    constructor(tplNum) {
        super();
        this.tplNum = tplNum;
    }

    init() {
        this.bind();
    }

    bind() {
        const correlationWrap = document.querySelector(`#correlation-${this.tplNum}`);
        const isEmpty = (correlationWrap && correlationWrap.querySelectorAll(`.correlation-wrap`).length > 0) ? false : true;
        this.tableBind(isEmpty);
    }

    tableBind(empty) {
        const tableSelect = document.querySelector(`#correlation-table-${this.tplNum}`);
        const correlationWrap = document.querySelector(`.correlation.new`);

        if (tableSelect) {
            this.tplName = tableSelect.getAttribute(`data-tpl-name`);
            tableSelect.onchange = async (e) => {
                //проверка на пустое поле, если пусто - вайпаем всё живое
                var checkVal = tableSelect[tableSelect.selectedIndex].innerText.length;
                //поднимаемся до общего блока
                var upperNode = tableSelect.parentNode.parentNode.parentNode;
                var numberofSlices = upperNode.childElementCount;
                var addBtn = document.querySelector(`#correlation-add-${this.tplNum}`);

                if ((checkVal === 0) && (numberofSlices > 1)) {
                    for (var i = 1; i < numberofSlices; i++) {
                        upperNode.lastElementChild.remove()
                    }
                    addBtn.onclick = async () => {
                        correlationId = 0;
                        await this.createNewCorrelationFields(data, correlationWrap, correlationId, selTable, true);
                    }
                } else {
                    addBtn.onclick = async () => {
                        correlationId++;
                        await this.createNewCorrelationFields(data, correlationWrap, correlationId, selTable, false);
                    }
                }

                const isSubtable = tableSelect.getAttribute(`subtable`);
                const linkInput = document.querySelector(`#correlation-link-field-${this.tplNum}`);
                if (isSubtable && linkInput) {
                    let linkVal = tableSelect.querySelectorAll(`option`)[tableSelect.selectedIndex].getAttribute('data-link');
                    if (!linkVal) {
                        linkVal = 0;
                    }
                    linkInput.value = linkVal;
                }
                const selTable = e.target.value;
                let data = await this.getDataByTableSelect(selTable);
                data = data.assoc;
                let correlationId = 0;

                if (!this._correlationOuterWrap) {
                    this._correlationOuterWrap = correlationWrap.parentNode;
                    const addBtn = document.querySelector(`#correlation-add-${this.tplNum}`);
                    if (addBtn && empty) {
                        addBtn.onclick = async () => {
                            correlationId++;
                            await this.createNewCorrelationFields(data, correlationWrap, correlationId, selTable, false);
                        }
                    }
                }

                const removeBtn = document.querySelector(`#correlation-remove-${this.tplNum}-${correlationId}`);

                if (removeBtn) {
                    removeBtn.onclick = () => {
                        document.querySelector(`#correlation-${this.tplNum}-${correlationId}`).remove();
                    }
                }


                await this.createNewCorrelationFields(data, correlationWrap, correlationId, selTable);

                // Заполняем поля для сохранения


                const saveFieldsSelect = document.querySelector(`#correlation-save-field-${this.tplNum}`);
                if (saveFieldsSelect) {
                    const data = await this.getSaveFields(tableSelect.value);
                    saveFieldsSelect.innerHTML = `<option selected></option>${getOptions(data)}`;
                }
            };
            // let evt = document.createEvent("HTMLEvents");
            // evt.initEvent("change", false, true);
            // tableSelect.dispatchEvent(evt);

            if (!empty) {
                const addBtn = document.querySelector(`#correlation-add-${this.tplNum}`);
                let correlationId = 0;

                if (addBtn) {
                    addBtn.onclick = async () => {
                        correlationId++;

                        let data = await this.getDataByTableSelect(tableSelect.value);
                        data = data.assoc;
                        await this.createNewCorrelationFields(data, correlationWrap, correlationId, tableSelect.value, false);
                    }
                }

                const correlations = correlationWrap.querySelectorAll(`.correlation-wrap`);

                Array.from(correlations).forEach((correlation) => {
                    const correlationId = correlation.getAttribute(`correlation-id`);
                    const selectFieldsOfTable = correlation.querySelector(`#fields-of-table-${this.tplNum}-${correlationId}`);
                    const removeBtn = correlation.querySelector(`#correlation-remove-${this.tplNum}-${correlationId}`);

                    if (removeBtn) {
                        removeBtn.onclick = () => {
                            correlation.remove();
                        }
                    }

                    if (selectFieldsOfTable) {
                        selectFieldsOfTable.onchange = async (e) => {
                            if (selectFieldsOfTable.value === ''){
                                let defaultField = document.querySelector(`#correlation-default-value-${this.tplNum}-${correlationId}`);
                                let newField = document.createElement('input');
                                newField.classList.add('form-control','form-control-160');
                                newField.setAttribute('id',`correlation-default-value-${this.tplNum}-${correlationId}`);
                                newField.setAttribute('name',`calc_params[${this.tplNum}][${this.tplName}][def_val][]`);
                                newField.setAttribute('type','text');
                                let parentDefault = defaultField.parentElement;
                                while (parentDefault.firstChild) {
                                    parentDefault.removeChild(parentDefault.firstChild);
                                }
                                parentDefault.appendChild(newField);
                            }
                            await this.onSelectFieldsOfTableChange(selectFieldsOfTable, tableSelect.value, correlationId);
                        }
                    }

                    const self = this;

                    $(correlation).find($(`.combobox`)).each(async function() {
                      create_combobox($(this));
                      const correlationId = $(this).attr('correlation-id');
                      const tplId = $(this).attr('tpl-id');
                      const tableSelect = document.querySelector(`#fields-of-table-${tplId}-${correlationId}`);
                      if (tableSelect) {
                          const valueId = $(this).attr(`value`);
                          let url = `select_value.php?table=${self.tableId}&field=${tableSelect.value}&no_filter&q=${valueId ? valueId : ''}`;
                          try {
                              if (valueId && url && $(this)) await get_ac_value_from_index(valueId, url, $(this));
                              url = `select_value.php?table=${self.tableId}&field=${tableSelect.value}&no_filter`;
                              autocomplete_ajax_request($(this), url, false);
                              self.onSelectFieldsOfTableChange(selectFieldsOfTable, tableSelect.value, correlationId);
                          } catch (error) {
                              console.error('Error:', error);
                          }
                      }
                  });
                });

            }
        }

        if (correlationWrap) {
            correlationWrap.classList.remove(`new`);
        }
    }

    async createNewCorrelationFields(data, correlationWrap, correlationId, selTable, remove = true) {
        if (correlationWrap && data) {
            const row = await this.createCorrelationRow(data, correlationId);
            const rows = correlationWrap.querySelectorAll(`.correlation-wrap`);

            if (remove) {
                Array.from(rows).forEach((row, i) => {
                    row.remove();
                });
            }

            correlationWrap.appendChild(row);
            bind_help_bt();
            const selectFieldsOfTable = document.querySelector(`#fields-of-table-${this.tplNum}-${correlationId}`);

            if (selectFieldsOfTable) {
                selectFieldsOfTable.onchange = async (e) => {
                    if (selectFieldsOfTable.value === ''){
                        let defaultField = document.querySelector(`#correlation-default-value-${this.tplNum}-${correlationId}`);
                        let newField = document.createElement('input');
                        newField.classList.add('form-control','form-control-160');
                        newField.setAttribute('id',`correlation-default-value-${this.tplNum}-${correlationId}`);
                        newField.setAttribute('name',`calc_params[${this.tplNum}][${this.tplName}][def_val][]`);
                        newField.setAttribute('type','text');
                        let parentDefault = defaultField.parentElement;
                        while (parentDefault.firstChild) {
                            parentDefault.removeChild(parentDefault.firstChild);
                        }
                        parentDefault.appendChild(newField);
                    }
                    await this.onSelectFieldsOfTableChange(selectFieldsOfTable, selTable, correlationId);
                }

                const removeBtn = correlationWrap.querySelector(`#correlation-remove-${this.tplNum}-${correlationId}`);

                if (removeBtn) {
                    removeBtn.onclick = () => {
                        document.querySelector(`#correlation-${this.tplNum}-${correlationId}`).remove();
                    }
                }
            }
        }
    }

    async onSelectFieldsOfTableChange(selectFieldsOfTable, selTable, correlationId) {
        const type = getDataFromSelectVal(selectFieldsOfTable, `data-type`);
        const fieldsOfCurTable = document.querySelector(`#fields-of-table-${this.tplNum}-${correlationId}`);

        // if (fieldsOfCurTable) {
        //     const data = await this.getDataByTableFields(selectFieldsOfTable.value, selTable);
        //     fieldsOfCurTable.innerHTML = `<option selected></option>${getSortOptions(data)}`; // Перед результатом ставим пустой option для того чтобы по умолчанию он был выбран
        // }

        const defaultField = document.querySelector(`#correlation-default-value-${this.tplNum}-${correlationId}`);

        if (defaultField) {
            const {id} = defaultField;
            const field = this.getFieldByType(type, {});
            if (field) {
                field.attr({
                    'name': `calc_params[${this.tplNum}][${this.tplName}][def_val][]`,
                    'id': id
                });
                field.addClass(`form-control form-control-160`);

                this.replaceDefaultField(defaultField, field);
                if (type == 4 || type == 7 || type == 14) {
                    const typeValues = await this.getDataForSelect(selectFieldsOfTable.value);
                    field.html(`<option selected></option>${getOptions(typeValues, true)}`);
                } else if (type == 2) {
                    field.addClass(`datepicker`);
                } else if (type == 12) {
                    field.addClass(`datetimepicker`);
                }

                if (type == 2 || type == 12) {
                    const datepickerParams = {
                        showOn: "button",
                        dateFormat: lang.date_js_format,
                        showAlways: true,
                        buttonImage: "images/calbtn.png",
                        buttonImageOnly: true,
                        buttonText: lang.Calendar,
                        showAnim: (('\v' == 'v') ? "" : "show")  // в ie не включаем анимацию, тормозит}
                    };

                    $('.datepicker').datepicker(datepickerParams);
                    $('.datetimepicker').datetimepicker(datepickerParams);
                }

                if (type == 5) {
                    create_combobox(field);
                    let input = field.next().find($('.autocomplete__input'));
                    input.on('keyup', function (e) {
                        let word = '&q=';
                        let timeout;
                        if (input.val() !== '') {
                            word += encodeURIComponent(input.val());
                        }
                        let url_by_word = url + word;
                        if (e.keyCode === 17 || e.keyCode === 18 || e.keyCode === 16 || e.keyCode === 27 || e.keyCode === 40 || e.keyCode === 37 ||
                            e.keyCode === 38 || e.keyCode === 39 || e.keyCode === 9 || e.keyCode === 20 || e.keyCode === 13) {
                            return;
                        }
                        clearTimeout(timeout);
                        timeout = setTimeout(function () {
                            autocomplete_ajax_request(field, url_by_word, false, true);
                        }, 100);
                    });
                    if (typeof globalDefVal !== 'undefined' && globalDefVal){
                        const defVals = Object.values(globalDefVal);

                        // Создаем строку для URL с учетом всех значений из globalDefVal
                        const urlParams = defVals.map(val => `&value=${val}`).join('');
                        const url = `select_value.php?table=${this.tableId}&field=${selectFieldsOfTable.value}&no_filter${urlParams}`;
                        autocomplete_ajax_request(field, url, false);

                        // Назначение сохраненного значения в поле
                        setTimeout(function () {
                            let interval = setInterval(function () {
                                if (defVals.length > 0 && field[0].length) {
                                    defVals.forEach((val) => {
                                        let option = Array.from(field[0].options).find(opt => opt.value === val.toString());
                                        if (option) {
                                            field.val(val);
                                            input.val(option.text);
                                        }
                                    });

                                    clearInterval(interval);
                                }
                            }, 500);
                        }, 1000);
                    } else {
                      const url = `select_value.php?table=${this.tableId}&field=${selectFieldsOfTable.value}&no_filter`;
                      autocomplete_ajax_request(field, url, false);
                    }
                }
            }
        }
    }

    replaceDefaultField(field, newField) {
      const parent = field.parentNode;

      // Очищаем содержимое родительского элемента и добавляем новое поле
      parent.innerHTML = ``;
      $(parent).append(newField);
  }
    async createCorrelationRow(data, correlationId) {
        const rowInner = `<div class="correlation-wrap" id="correlation-${this.tplNum}-${correlationId}" correlation-id="${correlationId}">
            <div class="correlation__row">
                <div class="correlation__key">
                    ${lang.Source_field} <span class="help_bt" h_id="source_field"></span>:
                </div>
                <div class="correlation__val">
                    ${await this.createFieldsOfCurrentTable(correlationId)}
                    <div class="correlation__settings">
                        <button type="button" class="correlation__settings-btn correlation__settings-btn--remove"
                                tpl-num="${this.tplNum}" correlation-id="${correlationId}"
                                id="correlation-remove-${this.tplNum}-${correlationId}"></button>
                    </div>
                </div>
            </div>

            <div class="correlation__row">
                <div class="correlation__key">
                    ${lang.Recipient_field} <span class="help_bt" h_id="receiver_field"></span>:
                </div>
                <div class="correlation__val">
                    ${this.createFieldsOfTable(data, correlationId)}
                </div>
            </div>

            <div class="correlation__row">
                <div class="correlation__key">
                    ${lang.Default_value}:
                </div>
                <div class="correlation__val">
                    <input type="text" class="form-control form-control-160" id="correlation-default-value-${this.tplNum}-${correlationId}" name="calc_params[${this.tplNum}][${this.tplName}][def_val][]">
                </div>
            </div>
        </div>`;

        return createElement(rowInner);
    }

    createFieldsOfTable(data, correlationId) {
        let select = `<select class="form-control form-control-160 construct__field-recipient--select" name="calc_params[${this.tplNum}][${this.tplName}][to_field][]" id="fields-of-table-${this.tplNum}-${correlationId}"><option value=""></option>`;
        select += getOptions(data);
        select += `</select>`;

        return select;
    }

    async createFieldsOfCurrentTable(correlationId) {
      if (isNaN(this.tableId)) {
        this.tableId = parseInt(_getDefaultParams('table-id'));
      }

        let select = ``;
        let data = await this.getDataByTableSelect(this.tableId);
        data = data.assoc;

        if (data) {
            select = `<select class="form-control form-control-160" name="calc_params[${this.tplNum}][${this.tplName}][cur_field][]" id="fields-of-cur-table-${this.tplNum}-${correlationId}"><option value=""></option>`;
            select += getOptions(data);
            select += `</select>`;
        }

        return select;
    }

    async getDataForSelect(fieldId) {
        let data;

        await $.ajax({
            url: `${this.ajaxUrl}?ajax=1&field_id=${fieldId}&button_id=${this.buttonId}&action=getListTypeValue`,
            success: (xhr) => {
                if (xhr) {
                    data = JSON.parse(xhr);
                }
            }
        });

        return data;
    }

    async getSaveFields(tableId) {
        const url = `edit_calc.php?ajax=1&action=getCorrelationSaveFields&table=${this.tableId}&save_table=${tableId}&button_id=${this.buttonId}`;
        let data;

        await $.ajax({
            url: url,
            success: (xhr) => {
                if (xhr) {
                    data = JSON.parse(xhr);
                }
            }
        });

        return data;
    }

    async getDataByTableFields(value, selTable) {
        const url = `edit_calc.php?ajax=1&action=getCorrelationFields&table=${selTable}&sel_field=${value}&sel_table=${this.tableId}&not_sort=1`;
        let data;

        await $.ajax({
            url: url,
            success: (xhr) => {
                if (xhr) {
                    data = JSON.parse(xhr);
                }
            }
        });

        return data;
    }

    /**
     * Get data for fields by table and get data for fields by current table
     * @param table {string}
     * @returns {Promise<Response>}
     */
    async getDataByTableSelect(table) {
        const url = `${this.ajaxUrl}?ajax=1&action=getAllFields&table_id=${table}&button_id=${this.buttonId}`;
        let data;

        await $.ajax({
            url: url,
            success: (xhr) => {
                if (xhr) {
                    data = JSON.parse(xhr);
                }
            }
        });

        return data;
    }
}
