<?php
// Обновляем код подключения к Интису
$send_sms_func = <<<'EOD'
function send_sms() {
    global $config, $smsc, $sms;
    $src = ''<?xml version="1.0" encoding="utf-8" ?>
<request>
    <security>
        <login value="'' . htmlspecialchars($smsc[''login'']) . ''" />
        <password value="'' . htmlspecialchars($smsc[''password'']) . ''" />
    </security>
    <message>
        <sender>'' . htmlspecialchars($sms[''sender'']) . ''</sender>
        <text>'' . htmlspecialchars($sms[''text'']) . ''</text>
        <abonent phone="'' . $sms[''phone''] . ''" number_sms="1"/>
    </message>
</request>'';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(''Content-type: text/xml; charset=utf-8''));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CRLF, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $src);
    if ($config[''proxy_host'']) {
        curl_setopt($ch, CURLOPT_PROXY, $config[''proxy_host''] . '':'' . $config[''proxy_port'']);
    }
    if ($config[''proxy_user'']) {
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $config[''proxy_user''] . '':'' . $config[''proxy_pass'']);
    }
    curl_setopt($ch, CURLOPT_URL, ''https://xml.sms16.ru/xml/'');
    $xml = curl_exec($ch);
    if (curl_error($ch) && (curl_error($ch) == ''Unsupported SSL protocol version'' || curl_errno($ch) == 60)) {
        curl_setopt($ch, CURLOPT_URL, ''http://xml.sms16.ru/xml/'');
        $xml = curl_exec($ch);
    }
    if ($xml) {
        $res = trim(strip_tags($xml));
    } else {
        $res = curl_error($ch);
    }
    curl_close($ch);
    if ($res == ''send'') {
        $xr = xml_parser_create();
        xml_parse_into_struct($xr, $xml, $xml_val);
        $id_sms = $xml_val[1][''attributes''][''ID_SMS''];
        $parts = $xml_val[1][''attributes''][''PARTS''];
        return ''OK:'' . $id_sms . '':'' . $parts;
    }
    return ''ERROR:'' . $res;
}
EOD;

$check_sms_status_func = <<<'EOD'
function check_sms_status($id_sms) {
    global $config, $smsc;
    $src = ''<?xml version="1.0" encoding="utf-8" ?>
<request>
    <security>
        <login value="'' . htmlspecialchars($smsc[''login'']) . ''" />
        <password value="'' . htmlspecialchars($smsc[''password'']) . ''" />
    </security>
    <get_state>
        <id_sms>'' . $id_sms . ''</id_sms>
    </get_state>
</request>'';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(''Content-type: text/xml; charset=utf-8''));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CRLF, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $src);
    if ($config[''proxy_host'']) {
        curl_setopt($ch, CURLOPT_PROXY, $config[''proxy_host''] . '':'' . $config[''proxy_port'']);
    }
    if ($config[''proxy_user'']) {
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $config[''proxy_user''] . '':'' . $config[''proxy_pass'']);
    }
    curl_setopt($ch, CURLOPT_URL, ''https://xml.sms16.ru/xml/state.php'');
    $xml = curl_exec($ch);
    if (curl_error($ch) && (curl_error($ch) == ''Unsupported SSL protocol version'' || curl_errno($ch) == 60)) {
        curl_setopt($ch, CURLOPT_URL, ''http://xml.sms16.ru/xml/state.php'');
        $xml = curl_exec($ch);
    }
    if (substr($xml, 0, 5) == ''<?xml'') {
        $status = trim(strip_tags($xml));
    } elseif ($xml) {
        $res = $xml;
    } else {
        $res = curl_error($ch);
    }
    curl_close($ch);
    if ($status) {
        $xr = xml_parser_create();
        xml_parse_into_struct($xr, $xml, $xml_val);
        $time = $xml_val[1][''attributes''][''TIME''];
        $error = $xml_val[1][''attributes''][''ERR''];
        if ($config[''time_zone'']) { // преобразуем московское время от сервера в клиентское
            date_default_timezone_set(''Etc/GMT-3'');
            $timestamp = strtotime($time);
            date_default_timezone_set(''Etc/GMT'' . (($config[''time_zone''] < 0) ? ''+'' : ''-'') . abs($config[''time_zone'']));
            $time = date(''Y-m-d H:i:s'', $timestamp);
        }
        if ($status == ''send'') {
            return '''';
        }
        if ($status == ''deliver'') {
            return ''OK:'' . $time;
        }
        if ($status == ''not_found'' or $status == ''partly_deliver'') {
            return ''UNKNOWN:'' . $status;
        }
        if ($status == ''expired'') {
            return ''ERROR:Абонент отсутствовал в сети'';
        }
        if ($status == ''not_deliver'' and $error == ''0'') {
            return ''ERROR:Не удалось доставить СМС'';
        }
        if ($status == ''not_deliver'' and $error == ''1'') {
            return ''ERROR:Абонент недоступен или отключен'';
        }
        if ($status == ''not_deliver'' and $error == ''2'') {
            return ''ERROR:У абонента отключен прием СМС'';
        }
        if ($status == ''not_deliver'' and $error == ''3'') {
            return ''ERROR:Номер телефона не существует или не обслуживается'';
        }
        if ($status == ''not_deliver'' and $error == ''4'') {
            return ''ERROR:Память телефона абонента переполнена'';
        }
        if ($status == ''not_deliver'' and $error == ''5'') {
            return ''ERROR:Аппаратная ошибка телефона абонента'';
        }
        if ($status == ''not_deliver'' and $error == ''6'') {
            return ''ERROR:Сервис СМС не предоставляется'';
        }
        if ($status == ''not_deliver'' and $error == ''7'') {
            return ''ERROR:Аппарат абонента не поддерживает прием СМС'';
        }
        if ($status == ''not_deliver'' and $error == ''8'') {
            return ''ERROR:Аппарат абонента занят операцией, препятствующей получению СМС'';
        }
        if ($status == ''not_deliver'' and $error == ''9'') {
            return ''ERROR:Абонент находится в роуминге'';
        }
        if ($status == ''not_deliver'') {
            return ''UNKNOWN:not_deliver-'' . $error;
        }
        return ''ERROR:'' . $status;
    }
    return ''ERROR:'' . $res;
}
EOD;

run_query("UPDATE " . $config["table_prefix"] . "module_sms_gates SET code = '$send_sms_func', check_status = '$check_sms_status_func' WHERE name='Intis'");