'use strict';

import React, { useState, useRef, useEffect } from 'react';
import Input from './Input';

export default function SubstitutionBlock({
    substitutions,
    table,
    field,
    fieldCB,
    subfield,
    subfieldCB,
    saveHandler,
    closeHandler
}){
    const [ for1C, setFor1C ] = useState(substitutions?.for1C || []);
    const [ forCB, setForCB ] = useState(substitutions?.forCB || []);

    const wrapperSubstitution = useRef(null);

    const title = subfield == null ? `${field} - ${fieldCB}` : `${subfield} - ${subfieldCB}`;

    useEffect(() => {
        document.addEventListener('mousedown', handlerClickOutside);

        return () => {
            document.removeEventListener('mousedown', handlerClickOutside);
        }
    });

    const addSubstitutions = (type = '1C') => (e) => {
        e.preventDefault();

        let subs = [...(type == '1C' ? for1C : forCB)];
        subs.push({
            value: '',
            svalues: [''],
        });
        (type == '1C' ? setFor1C : setForCB)(subs);
    }

    const changeSubstitutions = (type = '1C', sitem_key = '') => (value) => {
        let subs = (type == '1C' ? for1C : forCB);
        subs[sitem_key]['value'] = value;
        (type == '1C' ? setFor1C : setForCB)(subs);
    }

    const deleteSubstitutions = (type = '1C', sitem_key = '') => () => {
        let subs = [...(type == '1C' ? for1C : forCB)];
        subs.splice(sitem_key, 1);
        (type == '1C' ? setFor1C : setForCB)(subs);
    }

    const addValueSubstitution = (type = '1C', sitem_key = '') => (e) => {
        e.preventDefault();

        let subs = [...(type == '1C' ? for1C : forCB)];
        subs[sitem_key]['svalues'].push('');
        (type == '1C' ? setFor1C : setForCB)(subs);
    }

    const changeValueSubstitution = (type = '1C', sitem_key = '', svalue_key = 0) => (value) => {
        let subs = (type == '1C' ? for1C : forCB);
        subs[sitem_key]['svalues'][svalue_key] = value;
        (type == '1C' ? setFor1C : setForCB)(subs);
    }

    const deleteValueSubstitution = (type = '1C', sitem_key = '', svalue_key = 0) => () => {
        let subs = [...(type == '1C' ? for1C : forCB)];
        subs[sitem_key]['svalues'].splice(svalue_key, 1);
        (type == '1C' ? setFor1C : setForCB)(subs);
    }

    const handlerClickOutside = (e) => {
        if(wrapperSubstitution && !wrapperSubstitution.current.contains(e.target)){
            closeHandler()(e);
        }
    }

    return (
        <>
            <div className="substitution_background">
                <div ref={wrapperSubstitution} className="substitution_container">
                    <span className="substitution_container-close" onClick={closeHandler()}>
                        <img
                            style={{ cursor: 'pointer' }}
                            src="images/b_drop.png"
                        />
                    </span>
                    <div className="substitution_container-main_title">{title}</div>
                    <div style={{ margin: '5px 0 20px 0' }}>
                        <div className="substitution_container-title">Замена значений для 1С.</div>
                        {for1C.map((item, item_key) => (
                            <>
                                <div key={'1C_'+item_key+'_'+Date.now()} style={{ display: 'flex', 'flex-wrap': 'wrap' }}>
                                    <div className="substitution_container-value_container substitution_container-value_container-title">Значение 1С</div>
                                    <div className="substitution_container-svalues_container substitution_container-value_container-title">Значения КБ</div>
                                    <div className="substitution_container-value_container">
                                        <img style={{ cursor: 'pointer' }} src="images/b_drop.png" onClick={deleteSubstitutions('1C', item_key)} />
                                        <Input
                                            className="form-control substitution_container-input"
                                            type='text'
                                            cur_value={item.value}
                                            blurHandler={changeSubstitutions('1C', item_key)}
                                        />
                                    </div>
                                    <div className="substitution_container-svalues_container">
                                        {
                                            item['svalues'].map((svalue, index) => (
                                                <div>
                                                    <img
                                                        style={{ cursor: 'pointer', visibility: (item['svalues'].length == 1 && index == 0 ? 'hidden' : '')}}
                                                        src="images/b_drop.png"
                                                        onClick={deleteValueSubstitution('1C', item_key, index)}
                                                    />
                                                    <Input
                                                        className="form-control substitution_container-input"
                                                        type="text"
                                                        cur_value={svalue}
                                                        blurHandler={changeValueSubstitution('1C', item_key, index)}
                                                    />
                                                    <img
                                                        style={{ cursor: 'pointer', visibility: (index == (for1C[item_key]['svalues'].length - 1) ? '' : 'hidden')}}
                                                        src="images/f_average_on.png"
                                                        onClick={addValueSubstitution('1C', item_key)}
                                                    />
                                                </div>
                                            ))
                                        }
                                    </div>
                                </div>
                            </>
                        ))}
                        <button className="substitution_container-link_button" onClick={addSubstitutions('1C')}>Добавить заменяемое значение</button>
                    </div>
                    <div style={{ margin: '5px 0 20px 0' }}>
                        <div className="substitution_container-title">Замена значений для КБ.</div>
                        {forCB.map((item, item_key) => (
                            <>
                                <div key={'CB_'+item_key+'_'+Date.now()} style={{ display: 'flex', 'flex-wrap': 'wrap' }}>
                                    <div className="substitution_container-value_container substitution_container-value_container-title">Значение КБ</div>
                                    <div className="substitution_container-svalues_container substitution_container-value_container-title">Значения 1С</div>
                                    <div className="substitution_container-value_container">
                                        <img style={{ cursor: 'pointer' }} src="images/b_drop.png" onClick={deleteSubstitutions('CB', item_key)} />
                                        <Input
                                            className="form-control substitution_container-input"
                                            type='text'
                                            cur_value={item.value}
                                            blurHandler={changeSubstitutions('CB', item_key)}
                                        />
                                    </div>
                                    <div className="substitution_container-svalues_container">
                                        {
                                            item['svalues'].map((svalue, index) => (
                                                <div>
                                                    <img
                                                        style={{ cursor: 'pointer', visibility: (item['svalues'].length == 1 && index == 0 ? 'hidden' : '') }}
                                                        src="images/b_drop.png"
                                                        onClick={deleteValueSubstitution('CB', item_key, index)}
                                                    />
                                                    <Input
                                                        className="form-control substitution_container-input"
                                                        type="text"
                                                        cur_value={svalue}
                                                        blurHandler={changeValueSubstitution('CB', item_key, index)}
                                                    />
                                                    <img
                                                        style={{ cursor: 'pointer', visibility: (index == (forCB[item_key]['svalues'].length - 1) ? '' : 'hidden')}}
                                                        src="images/f_average_on.png"
                                                        onClick={addValueSubstitution('CB', item_key)}
                                                    />
                                                </div>
                                            ))
                                        }
                                    </div>
                                </div>
                            </>
                        ))}
                        <button className="substitution_container-link_button" onClick={addSubstitutions('CB')}>Добавить заменяемое значение</button>
                    </div>
                    <input
                        type="button"
                        class="btn btn-default btn-sm substitution_container-save"
                        value="Сохранить"
                        onClick={saveHandler({ for1C, forCB }, table, field, subfield)}
                    />
                </div>
            </div>
        </>
    );
}
