import { ApiComponent } from "./api/ApiComponent.js";
import { AccessComponent } from "./access/AccessComponent.js";
import { ChannelsComponent } from "./channels/ChannelsComponent.js";
import { EditChannel } from "./channels/EditChannel.js";
import { AdditionallyComponent } from "./additionally/AdditionallyComponent.js";

/**
 * Компоненты, которые скорее всего не изменятся
 */

const IconComponent = {
  name: `icon-component`,
  props: ['transport'],
  template: /*html*/`
    <template v-if="transport == 'instagram'">
      <img src="stocks/images/instagram.svg" />
    </template>

    <template v-else-if="transport == 'tgapi'">
      <img src="stocks/images/telegram.svg" />
    </template>

    <template v-else-if="transport == 'telegram'">
      <img src="stocks/images/telegram-bot.svg" />
    </template>

    <template v-else-if="transport == 'avito'">
      <img src="stocks/images/avito.svg" />
    </template>

    <template v-else-if="transport == 'vk'">
      <img src="stocks/images/vk.svg" />
    </template>

    <template v-else>
      <img src="stocks/images/whatsapp.svg" />
    </template>
  `
}

const SaveButton = {
  name: 'save-button',
  emits: ['clickHandle'],
  template: /*html*/`
    <div style="text-align: center;">
      <button
        class="btn btn-default"
        @click="$emit('clickHandle')"
      >{{ $t('Save') }}</button>
    </div>
  `
}

export const components = [
  SaveButton,
  IconComponent,

  ApiComponent,
  AccessComponent,
  AdditionallyComponent,
  ChannelsComponent,
  EditChannel
]
