import useApiTabWazzupExtensionStore from './useApiTabWazzupExtensionStore.js';

export default Pinia.defineStore('useAccessTabWazzupExtensionStore', {
  state: () => ({
    groups: [],
    users: [],
  }),

  actions: {
    getGroup(id) {
      return this.groups.includes(id);
    },

    setGroup(id) {
      if (this.groups.includes(id)) {
        this.groups = _.remove(this.groups, n => n != id);
      } else {
        this.groups.push(id);
      }
    },

    loadUsers() {
      const apiStore = useApiTabWazzupExtensionStore();

      fetch("https://api.wazzup24.com/v3/users", {
        method: 'GET',
        redirect: 'follow',
        headers: {
          "Authorization": `Bearer ${apiStore.api_key}`,
          "Content-Type": "application/json"
        }
      })
      .then(response => response.json())
      .then(result => {
        if (result instanceof Array) {
          let newUsers = new Array();

          result.forEach(item => {
            let temp = this.users.find(i => i.wzId == item.id);

            if (typeof temp == 'undefined') {
              newUsers.push({
                "cbUserId": "",
                "wzId": item.id || "",
                "wzName": item.name || ""
              });
            }
          });

          this.users = [...this.users, ...newUsers];
        }
      });
    },

    async createUser(payload) {
      const apiStore = useApiTabWazzupExtensionStore();

      let raw = JSON.stringify([{
        "id": payload.id,
        "name": payload.name,
        "phone": ""
      }]);

      let response = await fetch("https://api.wazzup24.com/v3/users", {
        method: 'POST',
        redirect: 'follow',
        headers: {
          "Authorization": `Bearer ${apiStore.api_key}`,
          "Content-Type": "application/json"
        },
        body: raw
      });
      let result = await response.text();
      if (result == "OK") {
        this.addUser({
          cbUserId: payload.id,
          wzId: payload.id,
          wzName: payload.name
        });
      }
    },

    async addUser(user) {
      let issetUser = false;
      this.users.forEach((item, idx) => {
        if (item.wzId == user.wzId) {
          item.cbUserId = user.cbUserId;
          item.wzId = user.wzId;
          item.wzName = user.wzName;
          issetUser = true;
        }
      });

      if (!issetUser) {
        this.users.push(user);
      }
    },

    async deleteUser(id) {
      const apiStore = useApiTabWazzupExtensionStore();

      await fetch(`https://api.wazzup24.com/v3/users/${id}`, {
        method: 'DELETE',
        redirect: 'follow',
        headers: {
          "Authorization": `Bearer ${apiStore.api_key}`,
          "Content-Type": "application/json"
        }
      });

      this.users.forEach(user => {
        if (user.wzId == id) {
          user['deleted'] = true;
        }
      });
    },
  }
});
