/**
 * Скрипт для отображения iframe в доп.действии
 */

const styles = {
  block: /*css*/ `
    width: 100%;
    height: 50%;
    display: flex;
    flex-direction: row;
    justify-content: center;
    align-items: center;
  `,
  select: /*css*/ `
    -webkit-tap-highlight-color: rgba(0,0,0,0);
    -webkit-text-size-adjust: 100%;
    border-spacing: 0;
    border-collapse: collapse;
    box-sizing: content-box;
    font: inherit;
    text-transform: none;
    font-family: Ubuntu;
    outline: none;
    background: white no-repeat;
    background-position: top 11px right 6px !important;
    --ms-appearance: none;
    appearance: none;
    line-height: 1.42857143;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
    transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
    width: 185px;
    margin: 0 15px 0 15px;
    background-color: white;
    color: #000;
    font-size: 13px;
    height: auto;
    font-weight: 400;
    padding: 5px 20px 5px 10px;
    background-image: url("../../../images/select_b.png");
  `,
};

var wazzup = null;

function initFrame(apiKey, payload) {
  var xhr = new XMLHttpRequest();
  xhr.open("POST", "https://api.wazzup24.com/v3/iframe");
  xhr.onreadystatechange = handler;
  xhr.responseType = "json";
  [
    ["Authorization", `Bearer ${apiKey}`],
    ["Content-Type", "application/json"],
  ].forEach(function (header) {
    xhr.setRequestHeader(header[0], header[1]);
  });
  xhr.send(JSON.stringify(payload));

  function handler() {
    if (this.readyState === this.DONE) {
      if (this.status === 200) {
        document.querySelector("#myIframe").src = this.response.url;
      } else {
        console.error("Request failed", this);
      }
    }
  }
}

async function loadData(metadata) {
  let response = await fetch(
    `./api/dev/cbext/clientbase/wazzup/chat_frame_settings`,
    {
      method: "POST",
      headers: { "Content-Type": "application/vnd.api+json" },
      credentials: "include",
      body: JSON.stringify(metadata),
    }
  );

  let result = await response.json();

  if (typeof result.error != "undefined") {
    alert(result.error);
    window.close();
  }

  return result;
}

const onchangeFunc = function (event) {
  let value = JSON.parse(event.target.value);
  initFrame(wazzup.apiKey, {
    scope: "card",
    user: {
      id: wazzup.userId,
      name: wazzup.userName,
    },
    ...value,
  });
  document.getElementById("myIframe").style.display = "";
  document.getElementById("select-block").style.display = "none";
};

export default async function (metadata) {
  document.body.style.margin = 0;
  document.getElementById("myIframe").style.display = "none";

  const result = await loadData(metadata);

  let chats = [];
  let chatsCount = 0;
  let chatName = "";

  Object.keys(result.data).forEach((item) => {
    chatsCount += result.data[item].length;
    chatName = item;

    let groupName = item[0].toUpperCase() + item.substring(1);
    chats.push(`<optgroup label="${groupName}">`);

    result.data[item].forEach((i) => {
      let dataAttr = JSON.stringify(i);
      if (typeof i?.activeChat?.username != "undefined") {
        chats.push(
          `<option value=${dataAttr}>${i.activeChat.username}</option>`
        );
      } else if (typeof i?.activeChat?.chatId != "undefined") {
        chats.push(`<option value=${dataAttr}>${i.activeChat.chatId}</option>`);
      } else if (typeof i?.text != "undefined") {
        chats.push(`<option value=${dataAttr}>${i.text}</option>`);
      }
    });

    chats.push(`</optgroup>`);
  });

  // если есть выбор с кем поговорить
  if (chatsCount > 1) {
    wazzup = result;
    let elDiv = document.createElement("div");
    elDiv.id = "select-block";
    const str = /*html*/ `
      <span>Выберите чат:</span>
      <select id="select-chat">
        <option selected disabled></option>
        ${chats}
      </select>
    `;
    elDiv.innerHTML = str;
    elDiv.style = styles.block;
    document.body.append(elDiv);
    let st = document.getElementById("select-chat");
    st.style = styles.select;

    document.getElementById("select-chat").onchange = onchangeFunc;
  }
  // если нет выбора, будем говорить с кем получится:)
  else {
    initFrame(result.apiKey, {
      scope: "card",
      user: {
        id: result.userId,
        name: result.userName,
      },
      ...result?.data[chatName][0],
    });
    document.getElementById("myIframe").style.display = "";
  }
}
