window.onload = function() {
    const dadata_lang = {
        'russian': 'Количество запросов больше 100.',
        'english': 'The number of requests is more than 100.',
    };

    var Meta = {
        data: {},
        is_input: false,
        saved_value: new Array(),
    }

    function getDataStateStatus(value) {
        if (value == 'ACTIVE') {
            return 'действующая';
        } else if (value == 'LIQUIDATING') {
            return 'ликвидируется';
        } else if (value == 'LIQUIDATED') {
            return 'ликвидирована';
        } else if (value == 'REORGANIZING') {
            return 'в процессе присоединения к другому юрлицу, с последующей ликвидацией';
        } else {
            return value;
        }
    }

    function getDataType(value) {
        if (value == 'LEGAL') {
            return 'юридическое лицо';
        } else if (value == 'INDIVIDUAL') {
            return 'индивидуальный предприниматель';
        } else {
            return value;
        }
    }

    function getDataOgrnDate(value) {
        let date_to_string = '';
        let date = new Date(value);
        if (date == 'Invalid Date') return value;

        let day = date.getDay();
        let month = date.getMonth();
        let year = date.getFullYear();
        let hours = date.getHours();
        let minutes = date.getMinutes();

        date_to_string = day + '.' + month + '.' + year + ' ' + (
            hours == 0 ? '00' : (hours < 10 ? '0' + hours : hours)
        ) + ':' + (minutes == 0 ? '00' : minutes);

        return date_to_string;
    }

    function setAutocompleteBlock(e) {
        $field = $(this);
        if ($field.val().length < 1) return;

        const fieldId = $field.attr('field_id') === undefined ? $field.attr('id').slice(5) : $field.attr('field_id');
        let num = 0;
        for (let key in Meta.data) {
            if (fieldId == Meta.data[key]['sourceField']) num = key;
        }

        const preloader = create_preloader_block('10% !important', '10% !important');
        const fieldWidth = $field.outerWidth();
        const fieldHeight = $field.outerHeight();
        const onAjax = { backgroundColor : 'transparent', borderColor : '#ccc' };
        const emptyStyle = { backgroundColor : '', borderColor : '' };

        // Если это какие-то дефолтные кнопки, ничего не отправляем
        if (e.keyCode === 17 || e.keyCode === 18 || e.keyCode === 16 || e.keyCode === 27 ||
            e.keyCode === 40 || e.keyCode === 37 || e.keyCode === 38 || e.keyCode === 39 ||
            e.keyCode === 9 || e.keyCode === 20 || e.keyCode === 13) {
            $field.parent().find('.preloader__block').remove();
            return;
        }

        preloader.css({ 'width' : fieldWidth, 'height' : fieldHeight, background : 'transparent', 'z-index' : 9999 });
        $field.css(onAjax);
        $field.after(preloader);

        $.ajax({
            url: 'modules/dadata_demo/request.php',
            type: 'POST',
            data: {
                csrf: csrf,
                get_dadata_demo: Meta.data[num]['type'] == 4 || Meta.data[num]['type'] == 5 ? 'bank' : (
                    Meta.data[num]['type'] == 3 ? 'address' :
                    (Meta.data[num]['type'] == 0 && Meta.data[num]['base'] == 2 ? 'address' : 'party')
                ),
                value: $field.val()
            },
            success: function (data) {
                let response = JSON.parse(data);
                if (response?.error && response?.error == 100) {
                    const outerTop = $field.position().top + fieldHeight;
                    const outerLeft = $field.position().left;
                    const valuesBlock = $('<ul class="ui-menu ui-widget ui-widget-content ui-autocomplete"></ul>');
                    const firstLiElem = $('<li class="ui-menu-item"></li>');
                    const firstEmptyVal = $('<div tabindex="-1" class="ui-menu-item-wrapper">' + (
                        dadata_lang[(config?.lang || 'english')]
                    ) + '</div>');
                    const activeStyle = { background : '#1e90ff', color : 'white' };
                    const defStyle = { background : '', color : '' };
                    $field.siblings('ul.ui-menu').remove();

                    firstLiElem.on('mouseover', function() {
                        $(this).css(activeStyle);
                        $(this).children('div').css(activeStyle);
                    });

                    firstLiElem.on('mouseout', function() {
                        $(this).css(defStyle);
                        $(this).children('div').css(defStyle);
                    });

                    firstLiElem.on('click', function() {
                        $field.css('height', '');
                        valuesBlock.remove();
                        $field.val(e.target.value);
                    });

                    firstLiElem.append(firstEmptyVal);
                    valuesBlock.append(firstLiElem);

                    valuesBlock.css({ top : outerTop, left : outerLeft, width : (fieldWidth - 2) });
                    $field.parent().find('.preloader__block').remove();
                    $field.css(emptyStyle);
                    $field.parent().append(valuesBlock);
                    return;
                }
                const result = JSON.parse(response);

                const suggest = result.suggestions;
                const outerTop = $field.position().top + fieldHeight;
                const outerLeft = $field.position().left;
                const valuesBlock = $('<ul class="ui-menu ui-widget ui-widget-content ui-autocomplete"></ul>');
                const firstLiElem = $('<li class="ui-menu-item"></li>');
                const firstEmptyVal = $('<div tabindex="-1" class="ui-menu-item-wrapper">Очистить поле</div>');
                const activeStyle = { background : '#1e90ff', color : 'white' };
                const defStyle = { background : '', color : '' };

                $field.siblings('ul.ui-menu').remove();

                firstLiElem.on('mouseover', function() {
                    $(this).css(activeStyle);
                    $(this).children('div').css(activeStyle);
                });

                firstLiElem.on('mouseout', function() {
                    $(this).css(defStyle);
                    $(this).children('div').css(defStyle);
                });

                firstLiElem.on('click', function() {
                    saveFoundData('', num, $field);
                    $field.css('height', '');
                    valuesBlock.remove();
                    $field.val(e.target.value);
                });

                firstLiElem.append(firstEmptyVal);
                valuesBlock.append(firstLiElem);

                for (let elem in suggest) {
                    const liElem = $('<li class="ui-menu-item" sug_num="' + elem + '"></li>');
                    const divVal = Meta.data[num]['type'] == 3 || (Meta.data[num]['type'] == 0 && Meta.data[num]['base'] == 2) ?
                        $('<div tabindex="-1" class="ui-menu-item-wrapper">' + suggest[elem]['unrestricted_value'] + '</div>') :
                        $('<div tabindex="-1" class="ui-menu-item-wrapper">' +
                            suggest[elem]['value'] +' ('+
                            (suggest[elem]['data']['kpp'] != null ? suggest[elem]['data']['kpp'] + ', ' : '') +
                            (suggest[elem]['data']['address'] != null ? suggest[elem]['data']['address']['value'] : '')
                            + ')' + '</div>');

                    liElem.on('click', function() {
                        saveFoundData(suggest[elem], num, $field);
                        valuesBlock.remove();
                    });

                    liElem.on('mouseover', function() {
                        $(this).css(activeStyle);
                        $(this).children('div').css(activeStyle);
                    });

                    liElem.on('mouseout', function() {
                        $(this).css(defStyle);
                        $(this).children('div').css(defStyle);
                    });

                    liElem.append(divVal);
                    valuesBlock.append(liElem);
                }

                valuesBlock.css({ top : outerTop, left : outerLeft, width : (fieldWidth - 2) });
                $field.parent().find('.preloader__block').remove();
                $field.css(emptyStyle);
                $field.parent().append(valuesBlock);
            }
        });

        $field.on('blur', function() {
            $field.append(preloader);
            setTimeout(() => {
                $field.siblings('ul.ui-menu').remove();
                $field.siblings('.preloader__block').remove();
            }, 300);
        });
    }

    async function save_current_value(field_id, line_id, val) {
        let formData = new FormData();
        formData.append('field', field_id);
        formData.append('line', line_id);
        formData.append('csrf', csrf);
        formData.append('value', val);
        let res = await fetch('update_value.php', {
            method: 'POST',
            body: formData
        });
        if (res.status == 200) {
            Meta.saved_value.push(await res.text());
        }
        setTimeout(updateColorFormat(line_id), 0);
    }

    function completion_of_saving(resp_arr) {
        for (let i = 0; i < resp_arr.length; i++) {
            completion_of_saving_one_value(resp_arr[i]);
        }
        if (!Meta.is_input && $('#view_block').css('display') != 'none') {
            displayNotification(lang.save_value_notify, 1);
        }
        Meta.is_input = false;
        Meta.saved_value = new Array;
    }


    function completion_of_saving_one_value(resp) {
        var resp_arr = resp.toString().split("\r\n");
        for (let i = 0; i < resp_arr.length; i++) {
            var res_arr = resp_arr[i].toString().split("|");
            if (trim(res_arr[0]) === "saved") {
                UpdateData(resp_arr);
                add_request_to_update_arr(resp_arr);
            }
        }
    }

    async function saveFoundData(value, num, current_field) {
        for (let val in Meta.data[num]) {
            const curValue = Meta.data[num][val];
            const splitData = val.split('*');

            if (val == 'table' || val == 'type' || val == 'base') continue;
            if (Meta.data[num]['type'] == 0 && Meta.data[num]['base'] == 2 && val == 'unrestricted_value') continue;
            if (curValue == 0) continue;
            if (Meta.data[num]['base'] != 3 && val == 'sourceField') continue;

            let str_val = '';
            if (value !== '') {
                if (splitData.length == 2) {
                    if (typeof value[splitData[0]] != 'undefined') {
                        str_val = splitData[1] == 'type'                        // data.type - Тип организации
                            ? getDataType(value[splitData[0]][splitData[1]])
                            : (
                                splitData[1] == 'ogrn_date'                     // data.ogrn_date - Дата выдачи ОГРН
                                    ? getDataOgrnDate(value[splitData[0]][splitData[1]])
                                    : value[splitData[0]][splitData[1]] || ''
                            );
                    }
                } else if (splitData.length == 3) {
                    if (typeof value[splitData[0]][splitData[1]] != 'undefined') {
                        if (splitData[2] == 'status') {
                            str_val = getDataStateStatus(value[splitData[0]][splitData[1]][splitData[2]]);
                        } else {
                            str_val = value[splitData[0]][splitData[1]] == null ? "" : value[splitData[0]][splitData[1]][splitData[2]];
                        }
                    }
                } else {
                    str_val = val == 'sourceField' ? (Meta.data[num]['type'] == 5 ? value['data']['bic'] : value['value']) : value[val];
                }
            }

            if (str_val === undefined) continue;
            console.log('2');
            let temp_field_view = $('#view_cell_' + curValue),
                temp_field_edit = $('#value' + curValue);
            // Если режим быстрого редактирования, то отдаю данные ф-ции кб
            if ($('#view_block').css('display') != 'none') {
                temp_field_view.css('background-color', '#fff8d5');
                temp_field_view.css('border-color', '#ebb95b');
                temp_field_view.val(str_val);
                temp_field_edit.val(str_val);
                await save_current_value(curValue, lineId, str_val);
                setTimeout(function () {
                    temp_field_view.css('background-color', '#fff');
                    temp_field_view.css('border-color', '#ccc');
                }, 1000);
            } else {
                // иначе закидываю значение в поле и все
                temp_field_edit.val(str_val);
            }

            let current_field_id = current_field.attr('field_id') === undefined
                ? current_field.attr('id').replace('view_cell_', '').replace('value', '')
                : current_field.attr('field_id');
            if (curValue == current_field_id) {
                current_field.val(str_val);
            }

        }
        completion_of_saving(Meta.saved_value);
    }

    function afterMetaGetSettings() {
        for (var i in Meta.data) {
            const editField = $('#value' + Meta.data[i]['sourceField']);
            const viewField = $('#view_cell_' + Meta.data[i]['sourceField']);

            editField.on('keyup click', setAutocompleteBlock);
            viewField.on('keyup click', setAutocompleteBlock);
            viewField.on('keydown', function() {
                Meta.is_input = true;
            });
        }
    }

    let call = function() {
        $.ajax({
            url: 'modules/dadata_demo/request.php',
            type: "POST",
            data: { csrf: csrf, calculation: true },
            success: function(response) {
                const json = JSON.parse(response);
                let k = 0;
                for (var item in json?.set) {
                    if (json.set[item]['table'] == tableId) {
                        Meta.data[k] = json.set[item];
                        k++;
                    }
                }
                afterMetaGetSettings();
            }
        });
    };

    call();
};
