/**
* Хранилище настроек и данных формы
*/
export const useEditFormStore = Pinia.defineStore('editFormStore', {
  actions: {
    setFields(fields) {
      this.fields = fields;
    },

    setComposition(composition) {
      this.composition = composition;
    },

    setNotices(notices) {
      this.notices = notices || {};
    },

    getNotice(noticeId) {
      if (this.notices[noticeId]) {
        return this.notices[noticeId];
      } else {
        return noticeId;
      }
    },

    setRootMode(set) {
      this.rootMode = set;
    },

    isRoot() {
      return this.rootMode;
    },

    setDefaultValues(data, fields) {
      for (var fieldId in fields) {
        if (data[fieldId]) {
          continue;
        }

        if (fields[fieldId]['default']) {
          data[fieldId] = fields[fieldId]['default'];
        } else if ((fields[fieldId]['type'] == 'checkbox') && fields[fieldId]['options']) {
          data[fieldId] = [];
        }

        for (var subFieldId in fields[fieldId]) {
          if (fields[fieldId][subFieldId]['type']) {
            data[fieldId] = {};
            this.setDefaultValues(data[fieldId], fields[fieldId]);
          }
        }
      }
    },

    setData(data) {
      this.data = data || {};

      if (this.fields) {
        this.setDefaultValues(this.data, this.fields);
      }
    },

    async setModule(moduleId, loadSettings=true) {
      this.moduleId = "cbext." + moduleId.replace("/", ".");
      this.modulePath = moduleId.replace(".", "/");
      this.apiPath = "./api/dev/settings/" + this.moduleId;

      if (loadSettings) {
        this.loadModuleSettings();
      }
    },

    async api(method, body) {
      let response = await fetch(this.apiPath, {
        method: method,
        credentials: "include",
        headers: {
          'X-Auth-Token' : window.x_auth_token || null,
          'Content-Type': 'application/vnd.api+json'
        },
        body: body
      });

      response = await response.json();
      return response;
    },

    save() {
      //Сохранение настроек модуля
      if (this.moduleId) {
        this.saveModuleSettings();
      }
    },

    async loadModuleSettings() {
      let response = await this.api('GET');
      if (response?.data?.attributes?.value['secret-key']) {
        this.moduleActive = true
      }
      this.setData(response?.data?.attributes?.value);
    },

    async saveModuleSettings() {
      let data = JSON.stringify({
        data: {
          type: 'settings',
          id: this.moduleId,
          attributes: { value: this.data }
        }
      }, null, 4);

      let response = await this.api('PATCH', data);

      if (response?.data?.attributes?.value) {
        this.setData(response?.data?.attributes?.value);
        this.moduleActive = true
        displayNotification(lang.Settings_have_been_saved, 1);
      } else {
        displayNotification(lang.Error_settings_not_saved, 2);
      }
    }
  },

  state: () => ({
    //Список всех полей формы с параметрами
    fields: {},

    //Данные формы
    data: {},

    activeTab: "First Tab",

    //Структура формы
    //Страницы-закладки
    composition: {},

    //Уведомления
    notices: {},

    moduleId: "",

    modulePath: "",

    moduleApiPath: "",


    moduleActive: "false",

    //Признак получения данных конфигурации по API без учета прав доступа
    rootMode: false

  }),
});
