/**
 * Компонент Блок Текста
 */
import { useBlocksStore } from '../storeBlocks.js';

const template = /*html*/`
<p-panel :header="blockinfo.title" toggleable="true" class="mt-2 mb-2 shadow-2 border-round">
  <template #icons>
    <p-button icon="pi pi-times" @click="delBlock(blockinfo.id)" class="p-panel-header-icon p-button-rounded p-button-text mr-2"></p-button>
  </template>
  {{ blockinfo.content }}
</p-panel>
`;

export default {
  template,
  components: {
    "p-button": primevue.button,
    "p-toolbar": primevue.toolbar,
    "p-panel": primevue.panel,
  },

  props: ['blockid'],
  setup(props) {
    const store = useBlocksStore()
    const blockinfo = store.getBlock(props.blockid)
    return {
      blockinfo,
      delBlock: store.delBlock,
    }
  },
}

CB.styles.globed(/*css*/`
`);
