export default Pinia.defineStore('useKOSearchBlockStore', {
  state: () => ({
    block_id: 0,
    block_name: "",
    caption: "",
    table_id: 0,
    use_links: "implicit",
    sort: "",
    limit: 50,
    alignment: "center",
    statuses: "",
    columns: [],

    search_type: 2,
    search_string: "",
    data: [],
    last_lines: [],
  }),

  getters: {
    // Получить значение из хранилища
    getValue: (state) => (key) => {
      return (key in state) ? state[key] : null;
    },
  },

  actions: {
    // Установить значение в хранилище
    async setValue(key, value) {
      if (key in this) this[key] = value;
    },
  },
});
