import columns from './column.js';

/** Главный компонент */
export default function(json) {
  return {
    name: 'kanban-main-component',

    components: {
      columns
    },

    data() {
      return {
        boards: json,
        len: Object.keys(json?.data || {}).length,
        hide: true
      }
    },

    mounted() {
      window[`updateDataKanban${this.boards.settings.num}`] = this.updateData;
    },

    methods: {
      getSortedData() {
        let result = {};
        Object.keys(this.boards.data)
          .sort((a, b) => this.boards.data[a].num - this.boards.data[b].num)
          .forEach(item => result[item] = this.boards.data[item]);

        return result;
      },

      getTitleHeight() {
        let i = 0,
          w = false,
          height = 0;

        for (let key in this.boards.data) {
          let word = this.boards.data[key].title?.value || "";
          let space = (word.slice(0, word.indexOf(" "))).length || 0;

          if (space > 13) {
            w = true;
          }

          let cur_i = Math.ceil((this.boards.data[key].title?.value?.length || 0) / 14);
          if (cur_i > i){
            i = cur_i;
          }
        }

        height = (20 + (i - 1) * 35);
        height = w ? height : height/2;

        return height < 60 ? 60 : height;
      },

      async updateData() {
        let result = await fetch(window.location.href + '&getblock=' + this.boards.settings.num);
        result = await result.json();
        this.boards.data = result.data;
      }
    },

    template: /*html*/`
      <div>
        <div
          class="kanban-header"
          @click="hide = !hide;"
        >{{boards.settings.caption}}</div>

        <transition name="fade">
          <div
            class="kanban-flex-wrap"
            style="display: flex;"
            v-if="hide"
          >
            <columns
              v-for="column of getSortedData()"
              :column="column"
              :len="len"
              :data="boards.data"
              :settings="boards.settings"
              :kanban_id="boards.kanban_id"
              :title_height="getTitleHeight()"
              @update_data="updateData"
            />
          </div>
        </transition>
      </div>
    `
  }
}
