'use strict';

import { Numpad } from "./Numpad.js";
import { CallNotification } from "./CallNotification.js";


/** Основной блок телефонии (строка набора номера, доп клавиши и уведомления) */
export function CallBlock(options) {
  /**
   * Позиционирование блока номер набирателя на экране
   */
  function setCallBlockPosition() {
    let startPosition = localStorage.getItem(`${options.name}_callBlockPosition`);
    let top = $(window).height()/2 + 'px';
    let left = "40%";

    if (startPosition != null) {
      startPosition = JSON.parse(startPosition);
      left = startPosition.left || left;
      top = startPosition.top || top;
    }

    if (window.innerWidth < Number(left.slice(0, -2))) {
      let startLeft = (startPosition?.left || 0);
      startLeft = startLeft.indexOf('px') ? startLeft.slice(0,-2) : startLeft;
      if (window.innerWidth - (Number(startLeft)) < 0) {
        left = "40%"
      }
    } else if (window.innerHeight < Number(top.slice(0, -2))) {
      let startTop = (startPosition?.top || 0);
      startTop = startTop.indexOf('px') ? startTop.slice(0,-2) : startTop;
      if (window.innerHeight - (Number(startTop)) < 0) {
        top = $(window).height()/2 + 'px';
      }
    }

    $(`#call-block__${options.name}`).draggable({
      handle: ".call-content",
      stop: function () {
        top = $(`#call-block__${options.name}`).css("top");
        left = $(`#call-block__${options.name}`).css("left");
        localStorage.setItem(`${options.name}_callBlockPosition`, JSON.stringify({top,left}))
      }
    });

    $(`#call-block__${options.name}`).css({'left': left, 'top': top});
  }

  return {
    components: {
      numpad: Numpad(options),
      notification: CallNotification(options),
    },

    setup() {
      setCallBlockPosition();

      const store = Vuex.useStore();
      const phone_number = Vue.computed(() => store.state[options.prefix].phone_number);

      return {
        prefix: options.prefix,
        phone_number
      }
    },

    computed: {
      getImgSrc(){
        return `./stocks/telephony/images/tel.png`;
      },

      getStyleForAddition(){
        return this.getStoreValue('Call').isCall
          ? 'display:flex;justify-content: space-evenly;'
          : 'display:flex;';
      },

      getCostButtonText(){
        return (
          this.getStoreValue('cost_button_text') == 'Стоимость' ||
          this.getStoreValue('cost_button_text') == void 0 ||
          this.getStoreValue('cost_button_text') == null
        ) ? '' : this.getStoreValue('cost_button_text');
      },

      getStyleMuteButton(){
        return this.getStoreValue('mute') ? 'border-radius: 50%;background: #b1b0b0;' : '';
      },

      getStylePauseButton(){
        return this.getStoreValue('pause') ? 'border-radius: 50%;background: #b1b0b0;' : '';
      },

      getServiceText(){
        return this.getStoreValue('service_text') || '';
      },

      getRedirectItems(){
        return [{id: 0, name: '', short_number: ''}, ...this.getStoreValue('users_info')]
      }
    },

    methods:{
          async handleCostButton(){
              if(this.getStoreValue('service_text').length != 0){
                  this.setStoreValue('service_text', '');
                  return;
              }
              if(trim(this.getStoreValue('phone_number')).length == 0){
                  this.setStoreValue('service_text', l.Number_is_empty + '!');
                  setTimeout(() => {
                      this.setStoreValue('service_text', '');
                  }, 5000);
                  return;
              }
              this.setStoreValue('cost_button_text', '...');
              let result = await this.scall(this.getStoreValue('params'), 'getPriceByDirection2', 'json'); // Выгрузка за период
              if(result.error_message && result.error_message != ''){
                  this.setStoreValue('service_text', result.error_message);
              } else if(result.data['price']){
                  this.setStoreValue('service_text', `Cost per minute - ${result.data['price']} ${result.data['currency']}`);
              }
              this.setStoreValue('cost_button_text', 'Стоимость');
          },

          handleStartRedirectCall(e){
              e.preventDefault();
              this.setStoreValue('show_redirect_block', !this.getStoreValue('show_redirect_block'));
              this.setStoreValue('startReferCall', this.getStoreValue('show_redirect_block'));
          },

          handleMuteCall(e){
              e.preventDefault();
              this.setStoreValue('mute', !this.getStoreValue('mute'));
              this.setStoreValue('muteCall', this.getStoreValue('mute'));
          },

          handlePauseCall(e){
              e.preventDefault();
              this.setStoreValue('pause', !this.getStoreValue('pause'));
              this.setStoreValue('holdCall', this.getStoreValue('pause'));
          },

          closeCallBlock(){
              this.setStoreValue('is_showed_call_block', false);
              //store.set('phone_number', '');
              this.setStoreValue('service_text', '');
          },

          setNumber(e){
              this.setStoreValue('phone_number', e.target.value);
          },

          numberKeyDown(e){
              if(e.keyCode == 13){
                  this.setStoreValue('goCall', true);
              }
              if ( e.keyCode == 46 || e.keyCode == 8 || e.keyCode == 9 || e.keyCode == 27 ||
                  (e.keyCode == 65 && e.ctrlKey === true) ||
                  (e.keyCode == 67 && e.ctrlKey === true) ||
                  (e.keyCode == 86 && e.ctrlKey === true) ||
                  (e.keyCode == 88 && e.ctrlKey === true) ||
                  (e.keyCode >= 35 && e.keyCode <= 39)
              ) {
                  return;
              } else {
                  // Запрещаем все, кроме цифр на основной клавиатуре, а так же Num-клавиатуре
                  if ((e.keyCode < 48 || e.keyCode > 57) && (e.keyCode < 96 || e.keyCode > 105 )) {
                      e.preventDefault();
                  }
              }
          },

          async scall(params, command, mode = 'json'){
              data['rlogin'] = params['rlogin'];
              data['rsign'] = this.calcSignature(data, params['rkey']);

              let result = await this.callRequest(params, command, data, mode);

              return result;
          },

          goCall(){
              this.setStoreValue('goCall', true);
          },

          answerCall(){
              this.setStoreValue('needAnswerCall', true);
          },

          dropCall(){
            store.dispatch(`${options.prefix}/dropCall`);
          },
          showNumpad(e){
              e.preventDefault();
              this.setStoreValue('show_number_block', !!!this.getStoreValue('show_number_block'));
          },
          showAddition(e){
              e.preventDefault();
              this.setStoreValue('show_addition', !!!this.getStoreValue('show_addition'));
          },
          chooseRedirectNumber(e){
              this.setStoreValue('redirect_number', e.target.value);
          },
          forwardCall(){
              this.setStoreValue('forwardCall', true);
          },
          calcSignature(data, rkey){
              keys = [];

              for (i in data)
              if (i != 'svc'
                  && i != 'lang'
                  && i != 'mode'
                  && i != 'charset'
                  && i != 'sid'
                  && i != 'uqk'
                  && i != 'rsign'
                      )
                  keys.push(i);

              keys.sort();

              var s = '';

              for (i in keys) {
                  var key = keys[i];
                  var val = data[key];
                  if (typeof val  === 'object') {
                      val = '[' + arrayToStrForSign ( val ) + ']';
                  }
                  s = s + val + ';';
              }

              s = s + rkey;

              let sign = CryptoJS.MD5(s).toString(CryptoJS.enc.Hex);

              return sign;
          },
    },

    template: /*html*/`
      <div v-if="this.getStoreValue('is_showed_call_block')" class="call-content">

        <!-- закрыть блок -->
        <div class="call-content__close-button">
          <button
            class="call_notification--header-close"
            @click="closeCallBlock"
          >
          </button>
        </div>

        <div class="call-content__addit-button">
          <!-- Стоимость звонка -->
          <div>
            <button v-if="getStoreValue('Call') === '1'"
              class="call_block--btn call_block--btn-cost"
              @click="handleCostButton"
            >
              <img src="./stocks/telephony/images/coins.svg" />
              {{getCostButtonText}}
            </button>
          </div>

          <!-- переадресация звонков -->
          <div>
            <button
              v-if="getStoreValue('Call').isCall"
              class="call_block--btn call_block--btn-redirect"
              @click="handleStartRedirectCall"
            >
              <img src="./stocks/telephony/images/call-forwarding.png" />
            </button>
          </div>

          <!-- выключить звук -->
          <div>
            <button
              v-if="getStoreValue('show_redirect_block')"
              class="call_block--btn call_block--btn-mute"
              :style="getStyleMuteButton"
              @click="handleMuteCall"
            >
              <img src="./stocks/telephony/images/mute.png" />
            </button>
          </div>

          <!-- pause -->
          <div>
            <button
              v-if="getStoreValue('show_redirect_block')"
              class="call_block--btn call_block--btn-pause"
              :style="getStylePauseButton"
              @click="handlePauseCall"
            >
              <img src="./stocks/telephony/images/pause.png" />
            </button>
          </div>
        </div>

        <div>
          <div class="call-content__inner">

            <!-- иконка трубки и инпут -->
            <div class="call_block-tel">
              <input
                type="text"
                id="call_block-tel_number"
                :placeholder="$t('Enter_the_number')"
                :value="phone_number"
                @input="setNumber"
                @keydown="numberKeyDown"
              />
              <!-- <img alt="tel" src="./stocks/telephony/images/tel.png"/> -->
            </div>

            <!-- блок функциональных клавиш -->
            <div class="call_block-buttons_block">

              <!-- Вызов -->
              <button
                v-if="getStoreValue('Call') && !getStoreValue('Call').isCall || !!!getStoreValue('Call')"
                class="call_block--btn call_block--btn-call"
                @click="goCall"
              >{{ $t('Call') }}</button>

              <!-- Ответить -->
              <button
                v-if="getStoreValue('Call') && getStoreValue('Call').isCall && !!!getStoreValue('is_call') && getStoreValue('call_type') == 'incoming'"
                class="call_block--btn call_block--btn-answer"
                @click="answerCall"
              >{{ $t('Answer') }}</button>

              <!-- Отклонить -->
              <button
                v-if="getStoreValue('Call') && getStoreValue('Call').isCall"
                class="call_block--btn call_block--btn-reject"
                style="width: 100%;"
                @click="$store.dispatch(prefix + '/dropCall')"
              >{{ $t('Reject') }}</button>

              <div style="width: 0%;"
                v-if="getStoreValue('Call') && getStoreValue('Call').isCall && getStoreValue('call_type') == 'outgoing'"
              ></div>

              <!-- кнопка показать numpad -->
              <button
                class="call_block--btn call_block--btn-numpad"
                @click="showNumpad"
              >
                <img src="./stocks/telephony/images/keypad.svg" />
              </button>

              <!-- кнопка показать доп.функции -->
              <!--<button
                class="call_block--btn call_block--btn-numpad"
                style="width: 100%;"
                @click="showAddition"
              >
                <img src="./stocks/telephony/images/keypad.svg" />
              </button>-->
            </div>
          </div>

          <div class="call-content__status">{{getServiceText}}</div>

          <div
            v-if="getStoreValue('show_redirect_block')"
            class="call-content__redirect-block"
          >
            <select
              @change="chooseRedirectNumber"
              class="form-control"
            >
              <option
                v-for="item in getRedirectItems"
                :key="item.id"
                :value="item.short_number"
              >{{item.name}}</option>
            </select>

            <button
              class="call_block--btn"
              @click="forwardCall"
            >
              <img src="./stocks/telephony/images/call-forwarding.png"/>
            </button>
          </div>

          <numpad v-if="getStoreValue('show_number_block')" />

          <div
            v-if="!getStoreValue('show_number_block')"
            style="width: 15%;"
          ></div>
        </div>
      </div>

      <!-- Блок карточки клиента -->
      <notification v-if="this.getStoreValue('show_call_notification')"></notification>
    `
  }
}
