/*
ajax запрос для проверки и отображения доп вычислений для всех полей в edit_field.php
 */

$(document).ready(function() {
    var option = document.querySelector('select[name="cb_super_dev"] option[value="2"]')
    var ajaxQueue = [];
    var MAX_SIMULTANEOUS_REQUESTS = 3; // Максимальное количество одновременных запросов
    var currentRequests = 0;

    /**
     * Обрабатывает очередь AJAX-запросов, выполняя не более заданного количества одновременных запросов.
     * @returns {void}
     */
    function processQueue() {
        if (currentRequests < MAX_SIMULTANEOUS_REQUESTS && ajaxQueue.length > 0) {
            currentRequests++;
            var request = ajaxQueue.shift();
            $.ajax(request).always(function() {
                currentRequests--;
                processQueue();
            });
        }
    }

    /**
     * Добавляет AJAX-запрос в очередь и инициирует его обработку.
     * @param {Object} request Объект запроса, содержащий параметры для выполнения AJAX-запроса.
     * @returns {void}
     */
    function addToQueue(request) {
        ajaxQueue.push(request);
        processQueue();
    }

    /**
     * Инициализирует AJAX-запрос для получения данных о действиях, связанных с полем, и добавляет его в очередь запросов.
     * @param {string} searchRequest Строка запроса, содержащая параметры для идентификации поля и связанных с ним действий.
     * @returns {void}
     */
    function initActionsFields(searchRequest) {
        var request = {
            method: 'GET',
            url: 'edit_field_actions.php' + searchRequest,
            headers: {
                'X-Content-Exists': '1',
                'Content-Type': 'application/json; charset=utf-8'
            },
            success: function(resp) {
                //вычисляем fieldId из запроса
                var fieldId = searchRequest.substr(searchRequest.indexOf("field=") + 6);

                //если хоть какое-то действие существует, тогда создаем ссылку php
                if ( resp['buttons'].length != 0 || resp['calcs'].length != 0 || resp['reports'].length != 0 || resp['crons'].length != 0 || resp['ext_files'].length != 0 ) {
                    //создаем структуру для заполнения
                    $('<span>', { class: `mouseHoverTip mouseHoverTip${fieldId}` }).appendTo(`.preloaderBlockForCalcs${fieldId}`);

                    //если есть права, то вставляем ссылку, если нет то просто показываем что вычисление есть, но неативно
                    if ( $(`.preloaderBlockForCalcs${fieldId}`).attr('group_id') == 1 ) {
                        var phpGreenLink = ` <a title="Открыть действие" tabindex="1" class='fieldTipLink mouseHoverTipLink fieldTipLinkGreen'>php`
                        $(`.mouseHoverTip${fieldId}`).append(phpGreenLink)
                    } else {
                        var phpNoActiveLink = "php"
                        $(`.mouseHoverTip${fieldId}`).append(phpNoActiveLink)
                    }
                }

                //проверяем если в ответе есть действия
                for (item in resp) {
                    if ( resp[item].length != 0) {
                        var titleParagraph = `<p class="paragraphInPHPLinks">${resp[item]['title']}:</p>`
                        $('<span>', { class: `mouseHoverAnswer mouseHoverAnswer${fieldId}` }).appendTo(`.mouseHoverTip${fieldId}`);
                        $(`.mouseHoverAnswer${fieldId}`).append(titleParagraph)
                        fillCalcs(resp[item], item, fieldId)
                    }
                }

                //удаляем прелодер
                $(`.preloaderBlockForCalcs${fieldId} .preloader__block`).remove()

                $('.preloader__block').remove()

                if($('.hide-while-loading')) {
                    $('.hide-while-loading').removeClass('hide-while-loading')
                }
            },
            error: function() {
                console.log('Ошибка загрузки');
            }
        };
        addToQueue(request);
    }

    if ( option && option.hasAttribute('selected')){
    //из элемента берем путь для запроса, там ?table_id=111&field_id=1111
        if ($('.cb_super_user a').length) {
            $('.cb_super_user a').each(function () {
                var $this = $(this)
                var searchRequest = $this[0].search
                initActionsFields(searchRequest)
            });
            } else if ($('form a.cb_field_title__link').length){
            $('form a.cb_field_title__link').each(function () {
                var $this = $(this)
                var searchRequest = $this[0].search
                initActionsFields(searchRequest)
            });
            } else {
            $('.preloader__block').remove()
            if($('.hide-while-loading')) {
                $('.hide-while-loading').removeClass('hide-while-loading')
            }
        }
    }

    $('.preloader__block').remove()
    if($('.hide-while-loading')) {
        $('.hide-while-loading').removeClass('hide-while-loading')
    }

    //заполняем поля
    function fillCalcs(response, item, fieldId) {
      var resultLink = "";

      // цикл по элементам ответа
      for (let i in response) {
        //шагаем по массиву действий
        if (i == "title") {
          continue;
        }

        for (let elem in response[i]) {
          var actionId   = response[i][elem]['id'];
          var actionName = response[i][elem]['name'];
          var actionCode = response[i][elem]['ko'] ? "" : response[i][elem]['code'];
          var actionHelp = response[i][elem]['help'];
          sumCalcs(item, fieldId, resultLink, actionId, actionName, actionCode, actionHelp);
        }
      }
    }

    //заполнение ссылок
    function sumCalcs(item, fieldId, resultLink, actionId, actionName, actionCode, actionHelp) {
        switch (item) {
            case "buttons":
                resultLink += `<a target='_blank' href='edit_button.php?button=${actionId}' title='${actionHelp}'>${actionName}</a>&nbsp;(<a style='cursor: pointer;' onclick=\"open_calc('part=button_php&button=${actionId}',0);return false;\">${actionCode}</a>)`;
                break;

            case "calcs":
                resultLink += `<a target='_blank' href='edit_calc.php?calc_id=${actionId}' title='${actionHelp}'>${actionName}</a>&nbsp;(<a style='cursor: pointer;' onclick=\"open_calc('calc_id=${actionId}',0);return false;\">${actionCode}</a>)`;
                break;

            case "reports":
                resultLink += `<a target='_blank' href='edit_report.php?report=${actionId}' title='${actionHelp}'>${actionName}</a>`;
                if (actionCode != '') {
                  resultLink += `(&nbsp;<a style='cursor: pointer;' onclick=\"open_calc('report=${actionId}&part=report_code',0);return false;\">${actionCode}</a>)`;
                }
                break;

            case "crons":
                resultLink += `<a target='_blank' href='edit_cron.php?cron_id=${actionId}' title='${actionHelp}'>${actionName}</a>&nbsp;(<a style='cursor: pointer;' onclick=\"open_calc('cron_id=${actionId}&part=cron_php',0);return false;\">${actionCode}</a>)`;
                break;

            case "ext_files":
                resultLink += `<a style='cursor: pointer;' onclick=\"open_calc('ext_file_id=${actionId}',0);return false;\">${actionName}</a>`;
                break;

            default:
                break;
        }

        resultLink += "<br/>";

        //вставляем ссылку с вычислениями(внутреннее окно)
        $('<span>', { class: `mouseHoverAnswer mouseHoverAnswer${fieldId}` }).appendTo(`.mouseHoverTip${fieldId}`);
        $(`.mouseHoverAnswer${fieldId}`).append(resultLink)
        //навешиваем событие при клике чтобы вылазило окно с действиями + закрытие всех открытых
        $(`.mouseHoverTip${fieldId}`).find("a[tabindex='1']").on("click", function () {
            $(document).find('span.mouseHoverAnswer , span.mouseHoverAnswer-left').hide();
            $(this).next().removeClass('mouseHoverAnswer').addClass('mouseHoverAnswer-left a-top').css('display','block')
        });
    }
})
