var status_checkbox = $('#status-checkbox');
var datepicker = $('.inner__datepicker');

datepicker.datepicker({
    'dateFormat': lang.date_js_format,
    'width': 100 + 'px'
}).attr('placeholder', lang.date_placeholder);

complete_paid_progress();
complete_account_data();
calculate_table_results();
change_special_checkbox('Отсуствую', 'Присутствую', status_checkbox);

status_checkbox.on('change', function() {
    change_special_checkbox('Отсуствую', 'Присутствую', status_checkbox);
});

function complete_paid_progress() {
    var paid_progress = $('#paid-progress');
    if ($('*').is(paid_progress)) {
        var paid_total = parseInt($('#paid-total').html());
        var paid_invoice = parseInt($('#paid-invoice').html());
        var paid_coeff = paid_invoice / paid_total;

        if (paid_coeff > 0) {
            paid_progress.append('<div class="paid-line"></div>');
            $('.paid-line').css({
                'width': paid_coeff * 100 + '%'
            });
        }
        if (paid_coeff > 1) {
            $('.paid-line').css({
                'width': 100 + '%'
            });
        }
    }
}

function complete_account_data() {
    var account_data = $('#account-data');

    if ($('*').is(account_data)) {
        var account_complete = parseInt($('#account-complete').html());
        var account_queue = parseInt($('#account-queue').html());
        var account_coeff = Math.round(account_complete / account_queue * 100);
        var account_percent = $('#account-percent');

        account_data.attr({
            'value': account_coeff
        });

        if (account_coeff < 10) {
            account_percent.css({
                'left': '43px'
            });
        } else if (account_coeff >= 10 && account_coeff < 100) {
            account_percent.css({
                'left': '50px'
            });
        } else if (account_coeff >= 100) {
            account_percent.css({
                'left': '57px'
            });
        }

        account_data.knob({
            'width': 90,
            'height': 90
        });
    }
}

function calculate_table_results() {
    var table = $('.inner__stat-table');
    var result_row = $('.inner__stat-row--result');
    if ($('*').is(table) && $('*').is(result_row)) {
        var simple_row = $('.inner__stat-row--simple');
        var cell = $('.inner__stat-cell');

        simple_row.eq(0).find(cell).each(function (i) {
           if (i > 0) {
               var result = 0;
               simple_row.each(function (j) {
                   result += parseFloat(simple_row.eq(j).find(cell).eq(i).text());
               })
               result_row.find(cell).eq(i).text(result);
           }
        });
    }
}

/* ----------------- chart.js ----------------------- */

var draw = Chart.controllers.line.prototype.draw;
Chart.controllers.line = Chart.controllers.line.extend({
    draw: function() {
        draw.apply(this, arguments);
        var ctx = this.chart.chart.ctx;
        var _stroke = ctx.stroke;
        ctx.stroke = function() {
            ctx.save();
            ctx.shadowColor = 'rgb(129, 214, 0)';
            ctx.shadowBlur = 20;
            ctx.shadowOffsetX = 0;
            ctx.shadowOffsetY = 5;
            _stroke.apply(this, arguments)
            ctx.restore();
        }
    }
});

var main_chart = document.getElementById("main-chart");
var little_chart = document.querySelectorAll('.inner__canvas--secondary');

if (little_chart.length > 0) {
    for (var i = 0; i < little_chart.length; i++) {
        getChart(little_chart[i]);
    }
}

if (main_chart) {
    getChart(main_chart);
}

function getChart(elem) {
    var ctx = elem.getContext('2d');
    Chart.defaults.global.defaultFontColor = 'rgb(142, 142, 142)';
    Chart.defaults.global.defaultFontSize = 13;
    var myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: ["00:00", "3:00", "6:00", "9:00", "12:00", "15:00", "18:00", "21:00"],
            datasets: [{
                label: '# of Votes',
                data: [30, 60, 18, 30, 45, 60, 48, 30],
                borderColor: [
                    'rgb(129, 214, 0)'
                ],
                backgroundColor: [
                    'rgb(255, 255, 255)'
                ],
                borderWidth: 3
            }]
        },
        options: {
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero:true
                    }
                }]
            },
            legend: {
                labels: {
                }
            }
        }
    });
}