<?php

$result = sql_fetch_assoc(sql_select_field(
    $config['table_prefix']. 'settings', '*',
    'name="cbext.clientbase.wazzup"'
));

if (
    isset($result['value']) && !empty($result['value']) &&
    isset($result['value']['yaml']) && !empty($result['value']['yaml'])
) {
    $settings = \Symfony\Component\Yaml\Yaml::parse($result['value']['yaml']);

    if (isset($settings['report_id'])) {
        @sql_query('DELETE FROM '. $config['table_prefix'] .'reports '.
            'WHERE id='. $settings['report_id']);
        @sql_query('DELETE FROM '. $config['table_prefix'] .'acc_reports ' .
            'WHERE report_id='. $settings['report_id']);
        unset($settings['report_id']);
    }

    function wazzup_extension_genId() {
        return mb_strcut(sprintf('%04x%04x%04x%04x',
            mt_rand(0, 0xffff), mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0x0fff) | 0x4000,
            mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        ), 1, -2);
    }

    foreach(($settings['channels'] ?? []) as $channel_id => $channel) {
        if (
            isset($channel['additional_option']) &&
            isset($channel['additional_option']['table_id'])
        ) {
            $settings['channels'][$channel_id] = [
                'channel_id' => $channel['channel_id'],
                'channel_name' => $channel['channel_name'],
                'plain_id' => $channel['plain_id'],
                'transport' => $channel['transport'],
                'create_new_entry' => (
                    $channel['create_new_entry'] ?? $channel['additional_option']['table_id'] ?? 0
                ),
                'additional_option' => [
                    [
                        'id' => $channel['additional_option']['id'] ?? wazzup_extension_genId(),
                        'table_id' => $channel['additional_option']['table_id'],
                        'phone_field_id' => $channel['additional_option']['phone_field_id'],
                        'deleted' => $channel['additional_option']['deleted'] ?? false,
                        'priority' => $channel['additional_option']['priority'] ?? 'low',
                        'filter' => $channel['additional_option']['filter'] ?? 0,
                        'def_channel' => $channel['additional_option']['def_channel'] ?? false,
                        'link_field_id' => $channel['additional_option']['link_field_id'],
                        'subtable_id' => $channel['additional_option']['subtable_id'],
                        'button_id' => $channel['additional_option']['button_id'],
                    ]
                ]
            ];
        } else {
            $new_channels[$channel_id] = $channel;
        }
    }

    unset($settings['migrations']);
    unset($settings['migrate']);

    $field_type_chat = $settings['table']['fields']['chat_type'] ?? null;

    if (
        !isset($field_type_chat['field_id']) || empty($field_type_chat['field_id'])
    ) {
        $next_num = (sql_fetch_assoc(sql_select_field(
            $config['table_prefix'] .'fields',
            'max(field_num) as num',
            'table_id = ' .$settings['table']['id']
        ))['num'] ?? 0) + 1;

        $new_field_id = sql_insert($config['table_prefix'] .'fields', [
            'table_id' => $settings['table']['id'],
            'field_num' => $next_num,
            'name_field' => 'Тип чата',
            'type_field' => 4,
            'type_value' => "instagram\r\nwhatsapp\r\ntelegram",
            'default_value' => '',
            'main' => 0,
            'uniq_field' => 0,
            'javascript' => '',
            'help' => '',
            'scw_set' => '',
            'prefix' => '',
            'postfix' => '',
            '`last_value`' => '',
            'placeholder' => '',
            'mult_value' => 0,
        ]);

        @sql_query(
            'ALTER TABLE '. $config['table_prefix'] .'data'. $settings['table']['id'] .
            ' ADD f'. $new_field_id .' '. \CB\CornyFunc::sql_type(FIELD_LIST, '', 0)
        );

        sql_query('DELETE FROM '. $config['table_prefix'] .
            'acc_fields WHERE field_id='. $new_field_id);
        foreach ($settings['groups'] ?? [] as $group_id) {
            sql_insert($config['table_prefix'] .'acc_fields', [
                "group_id" => $group_id,
                "table_id" => $settings['table']['id'],
                "field_id" => $new_field_id,
                "view_tb" => 1,
                "view_sub" => 1,
                "view_add" => 0,
                "view_edit" => 0,
                "view" => 1,
                "read_acc" => 1,
                "write_acc" => 1,
            ]);
        }

        $settings['table']['fields']['chat_type'] = [
            "field_id" => $new_field_id,
            "short_name" => "chat_type",
            "field_name" => "Тип чата"
        ];
    } else {
        run_query(
            'UPDATE '. FIELDS_TABLE .
            ' SET type_value="instagram\r\nwhatsapp\r\ntelegram"' .
            ' WHERE id=' . $field_type_chat['field_id']
        );
    }

    sql_update($config['table_prefix']. 'settings', [
        'value' => \Symfony\Component\Yaml\Yaml::dump($settings, 8, 2)
    ], 'name="cbext.clientbase.wazzup"');
} else if(
    isset($result['value']) && !empty($result['value'])
) {
    $settings = \Symfony\Component\Yaml\Yaml::parse($result['value']);

    if (isset($settings['migrations'])) {
        unset($settings['migrations']);
        unset($settings['migrate']);

        sql_update($config['table_prefix']. 'settings', [
            'value' => \Symfony\Component\Yaml\Yaml::dump($settings, 8, 2)
        ], 'name="cbext.clientbase.wazzup"');
    }
}
