<?php

include_once __DIR__.'/../vendor/autoload.php';

use \PhpOffice\PhpSpreadsheet\Spreadsheet;
use \PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use \PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class bm_excel
{
    var $print_mode = 1;

    var $res_templ = array();
    var $origin_templ = array();
    var $print_lines = array();

    var $header_templ = array();
    var $headers_array = array();
    var $templ = array();
    var $footer_templ = array();
    var $footers_array = array();

    var $table_header_templ = array();
    var $table_headers_array = array();
    var $table_footer_templ = array();
    var $table_footers_array = array();

    var $file_name = "";
    var $files = array();
    var $img_for_excel = 0;
    var $use_out = 0;
    var $line_count = 0;
    var $mode_3_shift = 0;

    var $field_sum = array();
    var $line_array = array();
    var $line_array_fields = array();
    var $line_array_advanced = array();
    var $line_array_fields_advanced = array();

    const USE_FILES = 1;

    private $writer_id = 1;
    public $dlines = array();
    private $paper_height = 0;

    private $page_size = '9';
    private $orientation = '-P';

    /** @var Spreadsheet */
    private $spreadsheet;

    //Массив размеров бумаги в миллиметрах
    //Например, A4 это номер 9
    private $paperSizeDimensions = [

        1 => [215.9, 279.4],
        2 => [215.9, 279.4],
        3 => [279.4, 431.8],
        4 => [431.8, 279.4],
        5 => [215.9, 355.6],
        6 => [139.7, 215.9],
        7 => [184.15, 266.7],
        8 => [297, 420],
        9 => [210, 297],
        10 => [210, 297],
        11 => [148, 210],
        12 => [250, 353],
        13 => [176, 250],
        14 => [215.9, 330.2],
        15 => [215, 275],
        16 => [254, 355.6],
        17 => [279.4, 431.8],
        18 => [215.9, 279.4],
        19 => [98.425, 225.425],
        20 => [104.775, 241.3],
        21 => [114.3, 263.525],
        22 => [120.65, 279.4],
        23 => [127, 292.1],
        24 => [431.8, 558.8],
        25 => [558.8, 863.6],
        26 => [863.6, 1117.6],
        27 => [110, 220],
        28 => [162, 229],
        29 => [324, 458],
        30 => [229, 324],
        31 => [114, 162],
        32 => [114, 229],
        33 => [250, 353],
        34 => [176, 250],
        35 => [176, 125],
        36 => [110, 230],
        37 => [98.425, 190.5],
        38 => [92.075, 165.1],
        39 => [377.825, 279.4],
        40 => [215.9, 304.8],
        41 => [215.9, 330.2],
        42 => [250, 353],
        43 => [200, 148],
        44 => [228.6, 279.4],
        45 => [254, 279.4],
        46 => [381, 279.4],
        47 => [220, 220],
        50 => [235.585, 304.8],
        51 => [235.585, 381],
        52 => [296.926, 457.2],
        53 => [236, 322],
        54 => [210.185, 279.4],
        55 => [210, 297],
        56 => [235.585, 304.8],
        57 => [227, 356],
        58 => [305, 487],
        59 => [215.9, 322.326],
        60 => [210, 330],
        61 => [148, 210],
        62 => [182, 257],
        63 => [322, 445],
        64 => [174, 235],
        65 => [201, 276],
        66 => [420, 594],
        67 => [297, 420],
        68 => [322, 445]

    ];

    /**
     *  Многостраничный шаблон
     */
    private $isMultiPages = false;

    /**
     * Данные мультистраничного шаблона для использования между функциями
     */
    private $multiData = [];

    /**
     * Функции, которые можно использовать в многостраничных шаблонах
     * search - по какой строке искать функцию в тексте
     * replace - по какому выражению заменять функцию в тексте
     * real - функция класса, вычисляющая значение
     */
    private $multiFunctions = [
        'Печать.СтрНомер' => [
            'search' => 'Печать.СтрНомер',
            'replace' => '/\{Печать\.СтрНомер\}/si',
            'real' => 'x_multiPageNumber',
        ],    
        'CуммаПоПолюНаСтранице' => [
            'search' => 'CуммаПоПолюНаСтранице(',
            'replace' => '/\{CуммаПоПолюНаСтранице\([^)]+\)\}/si',            
            'real' => 'x_multiSumm',
        ],  
        'CуммаПоПолюНаСтраницеНДС' => [
            'search' => 'CуммаПоПолюНаСтраницеНДС(',
            'replace' => '/\{CуммаПоПолюНаСтраницеНДС\([^)]+\)\}/si',            
            'real' => 'x_multiSummNDS',
        ],  
        'CуммаПоПолюНаСтраницеМинусНДС' => [
            'search' => 'CуммаПоПолюНаСтраницеМинусНДС(',
            'replace' => '/\{CуммаПоПолюНаСтраницеМинусНДС\([^)]+\)\}/si',            
            'real' => 'x_multiSummNoNDS',
        ],    
    ];

    //Временный файл xlsx, загруженный из базы
    public $xlsxFile = '';

    /**
     * Индексы страниц по типам в многостраничном шаблоне
     */
    const MI_BODY = 0;
    const MI_HEADER = 1;
    const MI_FOOTER = 2;
    const MI_THEADER = 3;
    const MI_TFOOTER = 4;


    // при создании объекта сразу берем шаблон
    public function __construct($templ = array(), $type = 'xls')
    {
        global $xls_ext, $config;

        switch ($type) {
            case 'xlsx':
                $reader = new Xlsx();

                $filePath = '';
                if (file_exists($templ['body_form'])) {
                    //Версия 1 - файл сохранен в папке files
                    $filePath = $templ['body_form'];
                    $this->spreadsheet = $reader->load($filePath);
                } else {
                    //Версия 2 (корректная) - файл сохранен в базе
                    $fileContent = \CB\Tool\FileSystemFunctions::getFormFile($templ['id'], $templ['body_form']);
                    $filePath = \CB\Tool\FileSystemFunctions::getSitePath() . '/temp/' . uniqid($templ['body_form']) . '.xlsx';
                    $file = fopen($filePath, "w");
                    fputs($file, $fileContent['content']);
                    fclose($file);
                    $this->spreadsheet = $reader->load($filePath);
                    $this->xlsxFile = $filePath;
                    //unlink($filePath);
                }

                $this->spreadsheet = $reader->load($filePath);

                $xls_ext = new bm_excel_ext();
                $this->isMultiPages = !empty($templ['page_break']);
                break;

            // старый формат шаблонов Excel
            case 'xls':
            default:
                if ($templ) {
                    $this->header_templ = $templ['header'];
                    $this->origin_header_templ = $templ['header'];
                    $this->templ = $templ['body'];
                    $this->origin_templ = $templ['body'];
                    $this->footer_templ = $templ['footer'];
                    $this->origin_footer_templ = $templ['footer'];

                    $this->table_header_templ = $templ['table_header'];
                    $this->origin_table_header_templ = $templ['table_header'];
                    $this->table_footer_templ = $templ['table_footer'];
                    $this->origin_table_footer_templ = $templ['table_footer'];

                    if (!$this->templ) {
                        $this->templ = $templ;
                        $this->origin_templ = $templ;
                    }
                }

                $xls_ext = new bm_excel_ext();
                break;
        }
    }

    private function getAdditionalFields(array $table, array $line = [], $i=0) {

        $table_fields = get_table_fields($table);
        $one_subtable = sql_select_array(SUBTABLES_TABLE, "table_id=", $table['id'], " LIMIT 1");
        if ($one_subtable) {
            $link_field_name = form_int_name($one_subtable['link_field_id']);
            $test123 = data_select_array($one_subtable['link_table_id'], ALL_ROWS,
                "$link_field_name='" . $line[$i]['id'] . "' AND status=0");
            if (!empty($test123)) {
                $this->line_array[] = data_select_array($one_subtable['link_table_id'], ALL_ROWS,
                    "$link_field_name='" . $line[$i]['id'] . "' AND status=0");
            }
            $this->line_array_fields = sql_select_array(FIELDS_TABLE, ALL_ROWS, "table_id=",
                $one_subtable['link_table_id']);
        }
        foreach ($table_fields AS $one_field) {
            if ($one_field['type_field'] == 5) {
                if (!empty($line[$i][$one_field['int_name']]) && $line[$i][$one_field['int_name']] > 0) {
                    $resultDataSelect = data_select_array($one_field['s_table_id'],
                        "id='" . $line[$i][$one_field['int_name']] . "'");
                    if ($resultDataSelect) {
                        $this->line_array_advanced += $resultDataSelect;
                    }
                }

                $resultFieldsSelect = sql_select_array(FIELDS_TABLE, ALL_ROWS, "table_id=",
                    $one_field['s_table_id']);
                if ($resultFieldsSelect) {
                    $this->line_array_fields_advanced += $resultFieldsSelect;
                }
            }
        }

    }

    public function getTempl() {
        return $this->templ;
    }

    private function templFromSheet() {

        $worksheet = $this->spreadsheet->getActiveSheet();
        //Собираем ячейки и кладем в tmepl
        foreach ($worksheet->getRowIterator() as $row) {
            $rowIndex = $row->getRowIndex();
            $this->templ[$rowIndex] = [];
            $cellIterator = $row->getCellIterator();

            foreach ($cellIterator as $cell) {
                $value = $cell->getValue();
                $this->templ[$rowIndex][] = [
                    'value' => $value,
                    'source' => $value,
                    'col' => $cell->getColumn(),
                    'row' => $cell->getRow()
                ];
            }

            //Убираем лишнее, в конце строки всегда идут пустые ячейки
            for (end($this->templ[$rowIndex]); ($key = key($this->templ[$rowIndex])) !== null; prev($this->templ[$rowIndex]) ) {
                $current = current($this->templ[$rowIndex]);
                if (empty($current['value'])) {
                    unset($this->templ[$rowIndex][$key]);
                    //end($this->templ[$rowIndex][$key]);
                } else {
                    break;
                }
            }
        }
        $this->origin_templ = $this->templ;
    }


    private function sheetCopyRange($sheet, $srcRange, $dstCell, $targetSheet = null) {

        if (!$targetSheet) {
            $targetSheet = $sheet;
        }

        // Validate source range. Examples: A2:A3, A2:AB2, A27:B100
        if( !preg_match('/^([A-Z]+)(\d+):([A-Z]+)(\d+)$/', $srcRange, $srcRangeMatch) ) {
            // Wrong source range
            return;
        }
        // Validate destination cell. Examples: A2, AB3, A27
        if( !preg_match('/^([A-Z]+)(\d+)$/', $dstCell, $destCellMatch) ) {
            // Wrong destination cell
            return;
        }

        $srcColumnStart = $srcRangeMatch[1];
        $srcRowStart = $srcRangeMatch[2];
        $srcColumnEnd = $srcRangeMatch[3];
        $srcRowEnd = $srcRangeMatch[4];

        $destColumnStart = $destCellMatch[1];
        $destRowStart = $destCellMatch[2];

        // For looping purposes we need to convert the indexes instead
        // Note: We need to subtract 1 since column are 0-based and not 1-based like this method acts.

        $srcColumnStart = Coordinate::columnIndexFromString($srcColumnStart) - 1;
        $srcColumnEnd = Coordinate::columnIndexFromString($srcColumnEnd);
        $destColumnStart = Coordinate::columnIndexFromString($destColumnStart) - 1;

        $rowCount = 0;
        for ($row = $srcRowStart; $row <= $srcRowEnd; $row++) {
            $colCount = 0;
            for ($col = $srcColumnStart; $col <= $srcColumnEnd; $col++) {
                $cell = $sheet->getCellByColumnAndRow($col, $row);
                $style = $sheet->getStyleByColumnAndRow($col, $row);
                $dstCell = Coordinate::stringFromColumnIndex($destColumnStart + $colCount) . (string)($destRowStart + $rowCount);
                
                //Кладем значение и стиль в ячейку
                $targetSheet->setCellValue($dstCell, $cell->getValue());
                $targetSheet->duplicateStyle($style, $dstCell);

                // Set width of column, but only once per row
                if ($rowCount === 0) {
                    $w = $sheet->getColumnDimensionByColumn($col)->getWidth();
                    $targetSheet->getColumnDimensionByColumn ($destColumnStart + $colCount)->setAutoSize(false);
                    $targetSheet->getColumnDimensionByColumn ($destColumnStart + $colCount)->setWidth($w);
                }

                $colCount++;
            }

            $h = $sheet->getRowDimension($row)->getRowHeight();
            $targetSheet->getRowDimension($destRowStart + $rowCount)->setRowHeight($h);

            $rowCount++;
        }

        foreach ($sheet->getMergeCells() as $mergeCell) {
            $mc = explode(":", $mergeCell);
            $mergeColSrcStart = Coordinate::columnIndexFromString(preg_replace("/[0-9]*/", "", $mc[0])) - 1;
            $mergeColSrcEnd = Coordinate::columnIndexFromString(preg_replace("/[0-9]*/", "", $mc[1])) - 1;
            $mergeRowSrcStart = ((int)preg_replace("/[A-Z]*/", "", $mc[0]));
            $mergeRowSrcEnd = ((int)preg_replace("/[A-Z]*/", "", $mc[1]));

            $relativeColStart = $mergeColSrcStart - $srcColumnStart + 1;
            $relativeColEnd = $mergeColSrcEnd - $srcColumnStart + 1;
            $relativeRowStart = $mergeRowSrcStart - $srcRowStart;
            $relativeRowEnd = $mergeRowSrcEnd - $srcRowStart;

            if (0 <= $mergeRowSrcStart && $mergeRowSrcStart >= $srcRowStart && $mergeRowSrcEnd <= $srcRowEnd) {
                $targetColStart = Coordinate::stringFromColumnIndex($destColumnStart + $relativeColStart);
                $targetColEnd = Coordinate::stringFromColumnIndex($destColumnStart + $relativeColEnd);
                $targetRowStart = $destRowStart + $relativeRowStart;
                $targetRowEnd = $destRowStart + $relativeRowEnd;

                $merge = (string)$targetColStart . (string)($targetRowStart) . ":" . (string)$targetColEnd . (string)($targetRowEnd);
                //Объединяем ячейки
                $targetSheet->mergeCells($merge);
            }
        }

    }


    /**
     * Заполнить лист данными.
     *
     * @param integer $page_number      Номер страницы
     * @return void
     */
    private function sheetFromPrintLines(int $page_number): void
    {
        // назначаю активную страницу
        $this->spreadsheet->setActiveSheetIndex($page_number);
        // выбирую активную страницу для подмены данных в шаблоне
        $worksheet = $this->spreadsheet->getActiveSheet();

        $lastColIndex = "";//$worksheet->getHighestColumn();

        $shiftedRow = false;

        //Для эксперимента только одностраничный документ
        foreach ($this->print_lines[0] as $rowIndex => $row) {

            if (!empty($row['shifted'])) {

                //Обработка списка, копируем строки

                $row['shift'] = $row['shift'] ?? 0;

                if ($shiftedRow) {

                    //Это не первая строка, нужно копировать

                    //Копируем текущую строку
                    $worksheet->insertNewRowBefore($rowIndex);

                    //Таблица сдвинулась вниз, источник для копирования остался выше
                    $tempRowIndex = $rowIndex-1;

                    //Копируем строку, чтобы скопировать стили и объединения

                    if (!$lastColIndex) {

                        foreach ($row as $cell) {
                            if (!empty($cell['col'])) {
                                $lastColIndex = $cell['col'];
                            }
                        }

                    }

                    $sourceRange = 'A' . $tempRowIndex . ':' . $lastColIndex . $tempRowIndex;

                    $targetCell = 'A' . (string) $rowIndex;

                    $this->sheetCopyRange($worksheet, $sourceRange, $targetCell);

                }

                $shiftedRow = true;

            } else {

                //Возможно закончился список - на всякий случай сбрасываем
                $shiftedRow = false;
                $lastColIndex = "";
            }

            foreach ($row as $cell) {

                if ($cell['value'] !== $cell['source']) {

                    $coords = $cell['col'] . $rowIndex;

                    $worksheet->setCellValue($coords, $cell['value']);

                }

            }

        }

    }

    /**
    * Получить высоту заданного формата листа документа в миллиметрах
    * Нужно для разбиения на страницы для печати
    */
    private function getWorksheetPaperHeight($worksheet, $withoutMargins = true) 
    {

        $pageSetup = $worksheet->getPageSetup();

        //Получаем формат страницы (н-р А4 = 9)
        $paperSize = $pageSetup->getPaperSize();

        //Получаем ориентацию страницы (portrait/landscape)
        $paperOrientation = $pageSetup->getOrientation();

        //Берем размеры страницы по формату из справочника
        $paperDimensions = $this->paperSizeDimensions[$paperSize];

        //В зависимости от ориентации, возвращаем высоту/ширину
        $paperHeight = $paperDimensions[ ($paperOrientation == 'portrait') ? 1 : 0];

        //Нужно получить высоту без отступов (высота содержимого)
        if ($withoutMargins) {
            //Получаем класс отступов
            $margins = $worksheet->getPageMargins();
            //Получаем верхний-нижний отступы
            $topMargin = $margins->toMillimeters($margins->getTop());
            $bottomMargin = $margins->toMillimeters($margins->getBottom());  
            //Вычитаем отступы из высоты 
            $paperHeight = $paperHeight - $topMargin - $bottomMargin;
        }
        return $paperHeight;
    }

    /**
     * Получить высоту диапазона строк (или всей страницы) в миллиметрах
     * Нужно для разбиения на страницы при печати
     */
    private function getRowsHeight($worksheet, $startRow = 1, $stopRow = 0)
    {
        //Если не задана последняя строка - берем последнюю строку в таблице
        if ($stopRow < 1) {
            $stopRow = $worksheet->getHighestRow();
        }

        //На всякий случай проверяем, вдруг передали некорректное значение
        if ($startRow < 1) {
            $startRow = 1;
        }

        $height = 0;

        for ($i = $startRow; $i <= $stopRow; $i++) { // забиваем высоты
            $height += $worksheet->getRowDimension($i)->getRowHeight("mm");
        }  

        return $height;

    }

    private function multiGetPageSumm($fieldId)
    {
        $result = 0;
        $i = -1;
        $stopItem = $this->multiData['pageStartItem'] + $this->multiData['pageItems'];
        $lineId = $this->multiData['currentLine'];
        foreach ($this->line_array[$lineId] as $id => $arr) {
            $i++;
            if ($i < $this->multiData['pageStartItem']) {
                continue;
            } elseif ($i >= $stopItem) {
                break;
            } else {
                $result += $arr['f' . $fieldId];
            }
        }

        return $result;
    }

    private function x_multiPageNumber($value)
    {
        return $this->multiData['pageNumber'];
    }

    private function x_multiSummNoNDS($value)
    {
        return $this->x_multiSummNDS($value, 0);
    }

    private function x_multiSummNDS($value, $withNDS = 1)
    {
        //Получаем поле, по которому нужно суммировать, и параметры НДС
        list($fieldId, $percent, $p) = $this->get_summ_fields($value); 
        
        //Получаем сумму
        $return_sum = $this->multiGetPageSumm($fieldId);       
        
        //Обработка НДС
        if ($percent > 0) {
            if ($p == 2 && $withNDS == 1) {
                return $return_sum * $percent / 100;
            }
            if ($withNDS == 1) {
                return $return_sum * $percent / (100 + $percent);
            }
            if ($p != 2) {
                $return_sum -= $return_sum * $percent / (100 + $percent);
            }
        } elseif ($withNDS == 1) {
            return '';
        }

        return $return_sum;
    }    

    private function x_multiSumm($value)
    {
        //Получаем поле, по которому нужно суммировать
        list($fieldId) = $this->get_summ_fields($value);
        $result = $this->multiGetPageSumm($fieldId);
        /*
        $result = 0;
        $i = -1;
        $stopItem = $this->multiData['pageStartItem'] + $this->multiData['pageItems'];

        foreach ($this->line_array[0] as $id => $arr) {
            $i++;
            if ($i < $this->multiData['pageStartItem']) {
                continue;
            } elseif ($i >= $stopItem) {
                break;
            } else {
                $result += $arr['f' . $fieldId];
            }
        }
        */
        return $result;
    }

    private function multiApplyFunctions($template)
    {
        $template = $this->multiData['templates'][$template];
        //Если для шаблона есть функции, вставляем их значения в нужные места
        if (!empty($this->multiData['functions'][$template['index']])) {
            foreach ($this->multiData['functions'][$template['index']] as $function) {
                //Получаем результат работы функции
                $funcName = $this->multiFunctions[$function['function']]['real'];
                $funcResult = $this->$funcName($function['value']);
                //Записываем результат в ячейку
                $coords = $function['col'] . ($this->multiData['currentRow'] + $function['row'] - 1);
                $cell = $this->multiData['templates']['header']['worksheet']->getCell($coords);
                $value = $cell->getValue();
                $value = str_replace("__" . $function['function'] . "__", $funcResult, $value);
                $cell->setValue($value);                
            }
        }
    }

    private function multiCopyTemplateToPaper($template, $range = '')
    {
        $this->sheetCopyRange($this->multiData['templates'][$template]['worksheet'], $range ? $range : $this->multiData['templates'][$template]['range'], "A" . $this->multiData['currentRow'], $this->multiData['templates']['header']['worksheet']);
        $this->multiApplyFunctions($template);
        if ($template != 'body') {
            $this->multiData['currentRow'] += $this->multiData['templates'][$template]['rows'];
        } else {
            $this->multiData['currentRow'] += $this->multiData['templateBodyRows'];
        }
    }

    private function multiFillTemplates()
    {
        $templateType = count($this->multiData['workIndexes']);

        //В массиве templates собраем все нужные данные по шаблонам
        $templates = [
            'body' => [
                'index' => $this->multiData['workIndexes'][self::MI_BODY]
            ]
        ];
        switch ($templateType) {
            //3 - копируем подвал на каждую страницу
            case 3:    
                $templates['tfooter'] = ['index' => $this->multiData['workIndexes'][self::MI_FOOTER]];
            //3 и 2 - копируем шапку на каждую страницу
            case 2:
                $templates['theader'] = ['index' => $this->multiData['workIndexes'][self::MI_HEADER]];
                break;
            //больше 4 - полная обработка        
            case ($templateType > 4):
                $templates['tfooter'] = ['index' => $this->multiData['workIndexes'][self::MI_TFOOTER]];   
            //4 - всё кроме общего футера     
            case 4:
                $templates['header'] = ['index' => $this->multiData['workIndexes'][self::MI_HEADER]];
                $templates['theader'] = ['index' => $this->multiData['workIndexes'][self::MI_THEADER]];
                $templates['footer'] = ['index' => $this->multiData['workIndexes'][self::MI_FOOTER]];  
                break;                         
        }

        //Собираем нужные данные по всем страницам шаблона
        foreach ($templates as $template => $params) {
            $templates[$template]['worksheet'] = $this->spreadsheet->getSheet($params['index']);
            $templates[$template]['rows'] = $templates[$template]['worksheet']->getHighestRow();
            $templates[$template]['column'] = $templates[$template]['worksheet']->getHighestColumn();
            $templates[$template]['range'] = "A1:" . $templates[$template]['column'] . $templates[$template]['rows'];
            $templates[$template]['height'] = $this->getRowsHeight($templates[$template]['worksheet']);
        }

        //Если в шаблоне меньше 4-х страниц, header совпадает с theader
        if ($templateType < 4) {
            $templates['header'] = $templates['theader'];
        }    
        $this->multiData['templates'] = $templates;
    }

    /**
     *  Собираем страницу из заготовок при включенной галочке "Мультистраничный шаблон"
     * @param array $workIndexes массив соответствий "шаблон - заполненная копия"
     */
    private function multiXLSX()
    {
        //Определяем, как обрабатывать шаблон, по количеству страниц в шаблоне
        $templateType = count($this->multiData['workIndexes']);
        //1 - обычный шаблон, в этой функции ничего не делаем
        if ($templateType == 1) {
            return ;
        }

        //Заполняем данные по шаблонам в $this->multiData['templates']
        $this->multiFillTemplates();

        //Количество элементов в body
        $bodyItems = $this->multiData['templates']['body']['rows'] / $this->multiData['templateBodyRows'];

        //Собирать итоговую страницу будем на странице Header
        
        //Текущий номер строки для вставки
        $this->multiData['currentRow'] = $this->multiData['templates']['header']['rows'] + 1;

        //Номер страницы в итоговом документе
        $this->multiData['pageNumber'] = 0;
        //Количество элементов на странице
        $this->multiData['pageItems'] = 0;

        //Признак пустой страницы (начинаем новую страницу)
        $blankPage = true;

        //Высота текущей страницы
        $pageHeight = $headerHeight;

        //Высота обработанных body item
        $bodySkipHeight = 0;     
        
        //Перебираем элементы в body и собираем страницу
        for ($i = 0; $i < $bodyItems; $i++) {

            //Признак что нужно вставить body item
            $insertBody = false;

            //Координаты для копирования очередного body
            $startRow = $this->multiData['templateBodyRows'] * $i + 1;
            $stopRow = $this->multiData['templateBodyRows'] * ($i+1);
            $bodyItemRange = "A" . $startRow . ":" . $this->multiData['templates']['body']['column'] . $stopRow;

            //Высота очередного body
            $bodyItemHeight = $this->getRowsHeight($this->multiData['templates']['body']['worksheet'], $startRow, $stopRow);

            //Если продолжаем уже начатую страницу
            if (!$blankPage) {

                //Проверяем, возможно мы уже на последней странице
                //Если все оставшиеся строки влезают с учетом footer и tfooter - значит последняя
                //Определяем высоту оставшегося body
                $bodyEndHeight = $this->multiData['templates']['body']['height'] - $bodySkipHeight;

                //Определяем сколько еще пустого места на странице (вычитаем футеры так как их нужно будет вставить. Футеров может не быть, поэтому проверяем)
                $isLastPage = $this->multiData['paperHeight'] - $pageHeight - $bodyEndHeight - (isset($this->multiData['templates']['tfooter']) ? $this->multiData['templates']['tfooter']['height'] : 0) - (isset($this->multiData['templates']['footer']) ? $this->multiData['templates']['footer']['height'] : 0);
                
                //Если это последняя страница - просто вставляем строку
                if ($isLastPage >= 0) {
                    //Вставить строку
                    $insertBody = true;
                } else {
                    //Проверяем, влезет ли еще один body item на текущую страницу
                    $isAddable = $this->multiData['paperHeight'] - $pageHeight - $bodyItemHeight - (isset($this->multiData['templates']['tfooter']) ? $this->multiData['templates']['tfooter']['height'] : 0);
                    if ($isAddable >= 0) {
                        //Вставить строку
                        $insertBody = true;
                    } else {
                        //Вставить tfooter (если он есть)
                        $this->multiData['pageStopItem'] = $i;
                        if (isset($this->multiData['templates']['tfooter'])) {
                            $this->multiCopyTemplateToPaper('tfooter');   
                        }
                        
                        //Добавляем разрыв страницы
                        $this->multiData['templates']['header']['worksheet']->setBreak('A' . $this->multiData['currentRow'], \PhpOffice\PhpSpreadsheet\Worksheet\Worksheet::BREAK_ROW);
                        $this->multiData['currentRow']++;

                        //Начать новую страницу
                        $blankPage = true;
                        $pageHeight = 0;

                    }
                }
            }

            //Если начали новую страницу
            if ($blankPage) {
                $this->multiData['pageNumber'] = $this->multiData['pageNumber'] + 1;
                $this->multiData['pageItems'] = 0;
                $this->multiData['pageStartItem'] = $i;
                //Копируем tableHeader
                //Если в шаблоне меньше 4 страниц, на первой странице копировать заголовок не нужно (так как он там уже есть - собираем на странице заголовка)
                if (($templateType > 3) || ($this->multiData['pageNumber'] > 1)) {
                    $this->multiCopyTemplateToPaper('theader');
                    $pageHeight += $this->multiData['templates']['theader']['height'];
                }
                //Вставить строку - Не проверяем влезет ли он по высоте, так как на страницу должен попасть хотя-бы один элемент
                $insertBody = true;
                $blankPage = false;
            }

            if ($insertBody) {
                //Копируем текущий body
                $this->multiCopyTemplateToPaper('body', $bodyItemRange);
                $bodySkipHeight += $bodyItemHeight;
                $pageHeight += $bodyItemHeight;
                $this->multiData['pageItems']++;
            }
        }

        //Вставляем tfooter
        $this->multiData['pageStopItem'] = 0;
        if (isset($this->multiData['templates']['tfooter'])) {
            $this->multiCopyTemplateToPaper('tfooter');
            //Заодно удаляем страницу из документа
            $this->spreadsheet->removeSheetByIndex($this->multiData['templates']['tfooter']['index']);
        }

        //Если 4 или 5 страниц в шаблоне - удаляем theader
        if ($templateType > 3) {
            $this->spreadsheet->removeSheetByIndex($this->multiData['templates']['theader']['index']); 
        }

        //Вставляем footer
        if (isset($this->multiData['templates']['footer'])) {
            $this->multiCopyTemplateToPaper('footer');
            //Заодно удаляем страницу из документа
            $this->spreadsheet->removeSheetByIndex($this->multiData['templates']['footer']['index']);            
        }        

        //Удаляем body
        $this->spreadsheet->removeSheetByIndex($this->multiData['templates']['body']['index']);               

    }

    /**
     * Сформировать документ XLSX.
     *
     * @param array $table      Информация о текущей таблице
     * @param array $line       Записи, по которым необходимо сформировать документ
     * @return Spreadsheet
     */
    public function generateFromXLSX(array $table = [], array $line = []): Spreadsheet
    {
        global $xls_functions_list_ext;

        $isMulti = $this->isMultiPages;

        //Получаем количество страниц исходного шаблона
        $templateCount = $this->spreadsheet->getSheetCount();

        if ($isMulti) {
            //Сохраняем высоту исходного BODY
            $bodyWorksheet = $this->spreadsheet->getSheet(self::MI_BODY);
            $this->multiData['templateBodyHeight'] = $this->getRowsHeight($bodyWorksheet);
            //Сохраняем кол-во строк исходного BODY
            $this->multiData['templateBodyRows'] = $bodyWorksheet->getHighestRow();
            //Сохраняем высоту итоговой страницы (высота минус margin)
            $this->multiData['paperHeight'] = $this->getWorksheetPaperHeight($bodyWorksheet);
        }

        //Перебираем выделенные для экспорта записи
        for ($i = 0; $i < count($line); $i++) {

            //Массив для сохранения индексов копий шаблона
            //Копии шаблонов будем заполнять данными записи
            //Индексы будут нужны для мультистраничных шаблонов
            if ($isMulti) {            
                $this->multiData['workIndexes'] = [];
                $this->multiData['currentLine'] = $i;
            }    

            //Создаем копии страниц-шаблонов для заполнения данными из записей
            $templateIndex = 0;
            for ($templateIndex = 0; $templateIndex < $templateCount; $templateIndex++) {

                //Копируем шаблон
                $worksheet = clone $this->spreadsheet->getSheet($templateIndex);
                $title = $worksheet->getTitle();
                $newTitle = $title . " " . ($i+1);

                //Добавляем к имени номер записи
                $worksheet->setTitle($newTitle);
                //Добавляем страницу с шаблоном
                $newWorksheet = $this->spreadsheet->addSheet($worksheet);
                $newIndex = $this->spreadsheet->getIndex($newWorksheet);

                //Назначаем созданную страницу активной
                $this->spreadsheet->setActiveSheetIndex($newIndex);

                //Сохраняем индекс текущего шаблона для использования в функциях генерации данных
                $this->multiData['currentTemplate'] = $newIndex;

                $this->templ = [];
                //Сохраняем структуру активной страницы для обработки
                $this->templFromSheet();

                //Готовим данные для заполнения шаблонов
                $this->print_lines = [];
                $this->getAdditionalFields($table, $line, $i);
                $this->read_dline($table, $line[$i]);
                $this->apply_dline();
                $this->dlines = array();                 

                //Заполняем данными созданную копию шаблона
                $this->sheetFromPrintLines($newIndex);

                //Добавляем индекс шаблона в массив индексов (для мультистраничных)
                if ($isMulti) {
                    $this->multiData['workIndexes'][$templateIndex] = $newIndex;
                }
            
           }

            //Если мульти-шаблон, делаем обработку         
            if ($this->isMultiPages) {
                $this->multiXLSX();
            }

        }

        //Удаляем исходные страницы-шаблоны        
        for ($i = 0; $i < $templateCount; $i++) {
            $this->spreadsheet->removeSheetByIndex(0);
        }
        
        return $this->spreadsheet;
    }

    // читаем xls файл в массив для сохранения в базе
    public function read($filename)
    {
        //подключаем класс и читаем файл в объект
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load($filename);

        $page_i = 1;

        foreach ($objPHPExcel->getWorksheetIterator() as $worksheet) {
            $this->templ = array(); // временный контейнер
            //Определяем размеры листа xls
            $highestRow = $worksheet->getHighestRow();
            $highestColumn = $worksheet->getHighestColumn();
            $highestColumnIndex = Coordinate::columnIndexFromString($highestColumn);
            $scale = $worksheet->getPageSetup()->getScale(); // Определяем масштаб, при записи ширины умножаем на масштаб
            if ($scale && $scale != 100) {
                $this->templ[1][1]['scale'] = $scale / 100;
            }

            //определяем объедененные ячейки
            $valm = array();
            $q = $worksheet->getmergeCells();
            foreach ($q as $mer => $value) {
                $val = explode(":", $mer);
                $valm[$val[0]][] = $val[0];
                $valm[$val[0]][] = $val[1];
            }

            //Определяем размеры столбцов и строк
            for ($i = 1; $i <= ($highestRow); $i++) { // забиваем высоты
                $height = $worksheet->getRowDimension($i)->getrowHeight();
                if ($height >= 0 && $height != 12.75) {
                    $this->templ[$i]['height'] = $height;
                }
            }
            for ($j = 1; $j <= $highestColumnIndex; $j++) { // забиваем ширину
                $j1 = $j;
                $column = Coordinate::stringFromColumnIndex($j);
                $width = $worksheet->getColumnDimension($column)->getWidth();
                if ($width >= 0) {
                    $this->templ[1][$j1]['width'] = $width;
                }
            }
            // Формируем список склееных ячеек
            $templ_merged = array();
            if ($valm) {
                foreach ($valm as $cell) {
                    $start_cell = $this->splitcell($cell[0]);
                    $end_cell = $this->splitcell($cell[1]);
                    $start_col = Coordinate::columnIndexFromString($start_cell['col']);
                    $end_col = Coordinate::columnIndexFromString($end_cell['col']);
                    $cs = $end_col - $start_col + 1;
                    $rs = $end_cell['row'] - $start_cell['row'] + 1;
                    if ($cs > 1) {
                        $this->templ[$start_cell['row']][$start_col]['colspan'] = $cs;
                    }
                    if ($rs > 1) {
                        $this->templ[$start_cell['row']][$start_col]['rowspan'] = $rs;
                    }
                    for ($j = 1; $j < $rs; $j++) {
                        $templ_merged[$start_cell['row'] + $j][$start_col] = 1;
                        for ($i = 1; $i < $cs; $i++) {
                            $templ_merged[$start_cell['row'] + $j][$start_col + $i] = 1;
                        }
                    }
                    for ($i = 1; $i < $cs; $i++) {
                        $templ_merged[$start_cell['row']][$start_col + $i] = 1;
                    }
                }
            }

            $last_was_value = '';
            //забираем данные ячейки
            for ($i = 1; $i <= ($highestRow); $i++) {
                $was_value = 0;
                for ($j = 1; $j <= $highestColumnIndex; $j++) {
                    $j1 = $j;
                    if ($templ_merged[$i][$j1]) {
                        continue;
                    } // Пропускаем склееные ячейки
                    $column = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($j);
                    $cell = $column . $i;
                    $cell_style = $worksheet->getStyle($cell);
                    $cell_value = trim($worksheet->getCell($cell)->getValue());
                    if ($cell_value || $cell_value === '0') {
                        $this->templ[$i][$j1]['value'] = $cell_value;
                        // Если есть значение, читаем параметры шрифта
                        if (($c = $cell_style->getFont()->getName()) != 'Arial') {
                            $this->templ[$i][$j1]['font']['shrift'] = $c;
                        }
                        if (($c = $cell_style->getFont()->getSize()) != 10) {
                            $this->templ[$i][$j1]['font']['fontsize'] = $c;
                        }

                        if (($c = $cell_style->getNumberFormat()->getFormatCode()) != "GENERAL") {
                            $this->templ[$i][$j1]['format'] = $c;
                        }
                        if ($c = $cell_style->getFont()->getBold()) {
                            $this->templ[$i][$j1]['font']['bold'] = $c;
                        }
                        if ($c = $cell_style->getFont()->getItalic()) {
                            $this->templ[$i][$j1]['font']['italic'] = $c;
                        }
                        if (($c = $cell_underline = $cell_style->getFont()->getUnderline()) != 'none') {
                            $this->templ[$i][$j1]['font']['underline'] = $c;
                        }
                        if (($c = $cell_style->getFont()->getColor()->getRGB()) != "000000") {
                            $this->templ[$i][$j1]['font']['fontcolor'] = $c;
                        }

                        //выравнивание
                        if (($c = $cell_style->getAlignment()->getHorizontal()) != "general") {
                            $this->templ[$i][$j1]['alighment']['horizontal'] = $c;
                        }
                        if (($c = $cell_style->getAlignment()->getVertical()) != "bottom") {
                            $this->templ[$i][$j1]['alighment']['vertical'] = $c;
                        }
                        if (($c = $cell_style->getAlignment()->getTextRotation()) != "0") {
                            $this->templ[$i][$j1]['alighment']['textRotation'] = $c;
                        }
                        if (($c = $cell_style->getAlignment()->getWrapText()) != "") {
                            $this->templ[$i][$j1]['alighment']['wrapText'] = $c;
                        }
                        if (($c = $cell_style->getAlignment()->getShrinkToFit()) != "") {
                            $this->templ[$i][$j1]['alighment']['shrinkToFit'] = $c;
                        }
                        if (($c = $cell_style->getAlignment()->getIndent()) != "0") {
                            $this->templ[$i][$j1]['alighment']['indent'] = $c;
                        }
                        $was_value = 1;
                    }

                    // заливка
                    $cell_fillcolor = $cell_style->getFill()->getStartColor()->getARGB();
                    $cell_typefill = $cell_style->getFill()->getFillType();

                    if ($cell_typefill == "solid") { // Сплошная заливка, определяем используется ли цвета подтаблиц
                        if ($cell_fillcolor == "FFCCCCCC") {
                            $cell_typefill = "none";
                            $cell_fillcolor = "FF000000";
                        }
                    }
                    if ($cell_fillcolor != "FF000000") {
                        $this->templ[$i][$j1]['fillcolor'] = $cell_fillcolor;
                    }
                    if ($cell_typefill != "none") {
                        $this->templ[$i][$j1]['typefill'] = $cell_typefill;
                    }

                    //бордер
                    if (($c = $cell_style->getBorders()->GetLeft()->GetColor()->GetRgb()) != "000000") {
                        $this->templ[$i][$j1]['border']['leftcolor'] = $c;
                    }
                    if (($c = $cell_style->getBorders()->GetRight()->GetColor()->GetRgb()) != "000000") {
                        $this->templ[$i][$j1]['border']['rightcolor'] = $c;
                    }
                    if (($c = $cell_style->getBorders()->GetTop()->GetColor()->GetRgb()) != "000000") {
                        $this->templ[$i][$j1]['border']['topcolor'] = $c;
                    }
                    if (($c = $cell_style->getBorders()->GetBottom()->GetColor()->GetRgb()) != "000000") {
                        $this->templ[$i][$j1]['border']['bottomcolor'] = $c;
                    }

                    if (($c = $cell_style->getBorders()->GetLeft()->GetBorderStyle()) != "none") {
                        $this->templ[$i][$j1]['border']['leftstyle'] = $c;
                    }
                    if (($c = $cell_style->getBorders()->GetRight()->GetBorderStyle()) != "none") {
                        $this->templ[$i][$j1]['border']['rightstyle'] = $c;
                    }
                    if (($c = $cell_style->getBorders()->GetTop()->GetBorderStyle()) != "none") {
                        $this->templ[$i][$j1]['border']['topstyle'] = $c;
                    }
                    if (($c = $cell_style->getBorders()->GetBottom()->GetBorderStyle()) != "none") {
                        $this->templ[$i][$j1]['border']['bottomstyle'] = $c;
                    }

                }
                if ($was_value) {
                    $last_was_value = $i;
                } else { // Защита от неверного $highestRow, т.к. в случае использования генератора шаблона возможно значение 65536
                    if ($highestRow > 10000) {
                        if ($i > ($last_was_value + 100)) { // 100 строк нет никаких значений
                            break;
                        }
                    }
                }
            }

            // Сортируем массив по индексу - у
            ksort($this->templ);
            // Сортируем массив по индексу - x
            foreach ($this->templ as $k => $y1) {
                ksort($y1);
                $this->templ[$k] = $y1;
            }
            foreach ($worksheet->getDrawingCollection() as $drawing) {
                $drw = $drawing;
                if ($drw instanceof \PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing) {
                    ob_start();
                    call_user_func($drw->getRenderingFunction(), $drw->getImageResource());
                    $imageContents = (ob_get_contents());
                    ob_end_clean();
                    $coord = $drw->getCoordinates();

                    if ($this->files[$coord]) {
                        $coord_arr_temp = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::coordinateFromString($coord);
                        $coord = $coord_arr_temp[0] . ($coord_arr_temp[1] + 1);
                        if ($this->files[$coord]) {
                            $coord_arr_temp = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::coordinateFromString($coord);
                            $coord = $coord_arr_temp[0] . ($coord_arr_temp[1] + 1);
                            $this->files[$coord]['page_shift'] = 2;
                        } else {
                            $this->files[$coord]['page_shift'] = 1;
                        }
                    }

                    $this->files[$coord]['img'] = $imageContents;
                    $this->files[$coord]['offset_x'] = $drw->getOffsetX();
                    $this->files[$coord]['offset_y'] = $drw->getOffsetY();
                    $this->files[$coord]['width'] = $drw->getWidth();
                    $this->files[$coord]['height'] = $drw->getHeight();
                    $coord_arr = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::coordinateFromString($coord);
                    $this->files[$coord]['cell_x'] = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($coord_arr[0]) - 1;
                    $this->files[$coord]['cell_y'] = $coord_arr[1];
                    $this->files[$coord]['page_i'] = $page_i;
                    if ($this->files[$coord]['cell_x'] == 0) {
                        $this->files[$coord]['cell_x'] = 1;
                    }

                    // Пишем пустые символы, чтобы ячейки участвовали в шаблоне
                    $temp_height = $this->files[$coord]['height'] - 25;
                    $temp_y = $this->files[$coord]['cell_y'];
                    $prev_h = 12.75;
                    $first_iter = 0;
                    $max_iter = 100;// защита от зацикливания
                    while ($temp_height > 0 && $first_iter < $max_iter) {
                        if (!$this->templ[$temp_y])//[$this->files[$coord]['cell_x']]
                        {
                            $this->templ[$temp_y][$this->files[$coord]['cell_x']]['value'] = ' ';
                        }

                        $temp_h = $worksheet->getRowDimension($temp_y)->getrowHeight();//12.75
                        if ($temp_h > 0) {
                            $prev_h = $temp_h;
                        } else {
                            $temp_h = $prev_h;
                        }
                        $this->templ[$temp_y]['height'] = $temp_h;

                        $temp_height = $temp_height - $temp_h;
                        $temp_y++;
                        $first_iter++;
                    }
                }
            }

            if ($page_i == 1) {
                $this->res_templ = $this->templ;
            } elseif ($page_i == 2) {
                ksort($this->templ);
                $this->header_templ = $this->templ;
            } elseif ($page_i == 3) {
                $this->footer_templ = $this->templ;
            } elseif ($page_i == 4) {
                $this->table_header_templ = $this->templ;
            } elseif ($page_i == 5) {
                $this->table_footer_templ = $this->templ;
            }

            $page_i++;
        }

        $this->templ = array();
        $this->templ['header'] = $this->header_templ;
        $this->templ['body'] = $this->res_templ;
        $this->templ['footer'] = $this->footer_templ;
        $this->templ['table_header'] = $this->table_header_templ;
        $this->templ['table_footer'] = $this->table_footer_templ;
    }

    // Подготовить данные для вставки в Excel
    // $table - данные о таблице полученные через get_table
    // $line  - строка о которой необходимо получить данные
    // Заполняет массив $dlines, который может быть применен в функции apply_line
    public function read_dline($table, $line, $mode = 0)
    {
        global $user;
        if ($mode == 1) {
            $old_templ = $this->templ;
            $this->templ = $this->origin_header_templ;
        } elseif ($mode == 2) {
            $old_templ = $this->templ;
            $this->templ = $this->origin_footer_templ;
        }

        $lang_line_number = 'НомерСтроки';

        $table_fields = get_table_fields($table);
        // На основе шаблона формируем список переменных используемых в шаблоне
        $this->dlines = array();
        $l_tables = array();
        $l_fields = array();
        // Формируем список подтаблиц
        $result = sql_select(SUBTABLES_TABLE, "table_id=", $table['id']);
        while ($row = sql_fetch_assoc($result)) {
            $link_table_id = $row['link_table_id'];
            $link_field_id = $row['link_field_id'];
            $st_filter_id = $row['filter_id'];
            $name_subtable = $row['name'];
            $sub_table = get_table($link_table_id);
            $sub_fields = get_table_fields($sub_table);
            $sub_table['link_field_id'] = $link_field_id;
            $sub_table['link_field_int_name'] = $sub_fields[$link_field_id]['int_name'];

            // Фильтр в подчиненной таблице
            $filter = "";
            if ($st_filter_id) { # в свойствах подтаблицы выбран конкретный фильтр
                $sqlQuery = "SELECT a.* FROM " . FILTERS_TABLE . " a, " . ACC_FILTERS_TABLE . " b WHERE a.id=b.filter_id AND b.group_id=" . $user['group_id'] . " AND b.filter_id=$st_filter_id AND (access=1 OR def_use=1)";
                $result2 = sql_query($sqlQuery);
                if ($row2 = sql_fetch_assoc($result2)) { # фильтр найден и доступен пользователю
                    $filter = filter_tpl_replace($row2['value'], $row2['calculate']);
                } else { # фильтр не доступен, сбрасываем
                    $st_filter_id = 0;
                }
            }
            if (!$st_filter_id) { # фильтр не выбран или недоступен
                $sqlQuery = "SELECT a.* FROM " . FILTERS_TABLE . " a, " . ACC_FILTERS_TABLE . " b WHERE a.id=b.filter_id AND b.group_id=" . $user['group_id'] . " AND b.table_id=$link_table_id AND (access=1 OR def_use=1)";
                $result2 = sql_query($sqlQuery);
                while ($row2 = sql_fetch_assoc($result2)) { # объединяем все доступные пользователю фильтры, т.к. в подтаблице нет возможности их переключать
                    $row2['value'] = filter_tpl_replace($row2['value'], $row2['calculate']);
                    if ($row2['value']) {
                        $filter .= "(" . $row2['value'] . ") OR ";
                    } else { // Все записи
                        $filter = "";
                        break;
                    }
                }
                if ($filter) {
                    $filter = substr($filter, 0, -4);
                }
            }
            if ($filter) {
                $filter = " AND (" . $filter . ")";
            }
            $sub_table['filter'] = $filter;

            $name_fields = array();
            foreach ($sub_fields as $one_field) {
                $name_fields[$one_field['name_field']] = $one_field;
            }

            $name_fields['t9301$'] = $sub_table; // Волшебное число t9301$ :)
            $l_tables[$name_subtable] = $name_fields;
        }

        // Формируем обратный массив полей, по именам
        $name_fields = array();
        foreach ($table_fields as $one_field) {
            $name_fields[$one_field['name_field']] = $one_field;
            if ($one_field['type_field'] == 5) { // Считываем поля связи, 1-ый уровень
                $s_table = get_table($one_field['s_table_id']);
                $s_table_fields = get_table_fields($s_table);
                foreach ($s_table_fields as $one_sub_field) {
                    $l_fields[$one_field['name_field']][$one_sub_field['name_field']] = $one_sub_field;
                    $l_fields[$one_field['name_field']]['t9301$'] = $one_field;
                }
            }
        }
        // Для приведения чисел к единому формату удаляем пробелы и запятые
        $d_r = array(" ", ",");
        $d_r2 = array("", ".");
        // Перебираем весь шаблон, выделяем переменные
        foreach ($this->templ as $row => $value_arr) {
            foreach ($value_arr as $col => $data) {
                if ((intval($col) . "") != ($col . "")) {
                    continue;
                } // Если не число, то пропускаем
                $value = $data['value'];
                if (!$value) {
                    continue;
                }
                preg_match_all("/\{.+}/U", $value, $a);
                $a = $a[0];
                foreach ($a as $one_var) {
                    $one_var = substr($one_var, 1, -1);
                    // Смотрим есть ли в строке обычные поля
                    foreach ($name_fields as $one_field) {
                        $p = 0;
                        do {  // Может быть несколько полей связи в одной строке
                            $p = strpos($one_var, $one_field['name_field'], $p);
                            if ($p !== false) {  // Если найдена локальная переменная, помещаем ее в $this->dlines
                                // Переменная найдена
                                $fine_left = 1;
                                if ($p > 0) { // Проверяем левую границу
                                    $f_char = $one_var[$p - 1];
                                    if (!$this->delimeters()[$f_char]) {
                                        $fine_left = 0;
                                    }
                                }
                                $fine_right = 1;
                                // Проверяем правую границу
                                $f_char = $one_var[$p + strlen($one_field['name_field'])];
                                if ($f_char && !$this->delimeters()[$f_char]) {
                                    $fine_right = 0;
                                }

                                if ($fine_left && $f_char == '.') { // Поле связь
                                    $p1 = $one_field['name_field'];
                                    foreach ($l_fields[$p1] as $show_field) {
                                        // Вычисляем, совпадает ли второй конец
                                        if (substr($one_var, $p + strlen($p1) + 1,
                                                strlen($show_field['name_field'])) != $show_field['name_field']
                                        ) {
                                            continue;
                                        }
                                        // Совпало с полем, проверяем правую границу
                                        $check_right_char = $one_var[$p + strlen($p1) + 1 + strlen($show_field['name_field'])];
                                        if ($check_right_char && !$this->delimeters()[$check_right_char]) {
                                            continue;
                                        } // Заканивается не разделителем
                                        $l_field = $l_fields[$p1]['t9301$'];
                                        $s_line_id = (is_array($line[$l_field['int_name']])) ? $line[$l_field['int_name']]['raw'] : $line[$l_field['int_name']];
                                        // Делаем выборку из базы по данному полю
                                        //Учитываем множественный выбор
                                        if ($s_line_id[0] == '-') { // множественная связь
                                            $s_lines = explode('-', substr($s_line_id, 1, -1));
                                        } else {
                                            $s_lines = [$s_line_id];
                                        }                 
                                        $s_value = '';
                                        foreach ($s_lines as $s_one_id) {
                                            $sub_line = data_select_array($show_field['table_id'], 'id=', $s_one_id);
                                            $s_value = $s_value . ($s_value ? "\n" : '') . form_display_type($show_field,
                                            $sub_line, 'text');
                                        }
                                        $this->dlines[$p1 . "." . $show_field['name_field']] = $s_value;
                                        if ($show_field['type_field'] == 1) {
                                            $this->dlines[$p1 . "." . $show_field['name_field']] = str_replace($d_r,
                                                $d_r2, $this->dlines[$p1 . "." . $show_field['name_field']]);
                                        }
                                    }
                                } else {
                                    if ($fine_left && $fine_right) { // Обычное поле
                                        $this->dlines[$one_field['name_field']] = form_display_type($one_field, $line, 'text');
                                        if ($one_field['type_field'] == 1) {
                                            $this->dlines[$one_field['name_field']] = str_replace($d_r, $d_r2, $this->dlines[$one_field['name_field']]);
                                        }
                                    }
                                }
                                $p++;
                            }
                        } while ($p !== false);
                    }
                    // Смотрим по связным таблицам
                    foreach ($l_tables as $l_table_name => $l_table) {
                        foreach ($l_table as $l_field_name => $l_field) {
                            $p = strpos($one_var, $l_table_name . "." . $l_field_name);
                            if ($p !== false) { // Поле существует
                                $fine_left = 1;
                                if ($p > 0) { // Проверяем левую границу
                                    $f_char = $one_var[$p - 1];
                                    if (!$this->delimeters()[$f_char]) {
                                        $fine_left = 0;
                                    }
                                }
                                $fine_right = 1;
                                // Проверяем правую границу
                                $f_char = $one_var[$p + strlen($l_table_name . "." . $l_field_name)];
                                if ($f_char && !$this->delimeters()[$f_char]) {
                                    $fine_right = 0;
                                }
                                if ($fine_left && $fine_right) { // Данные из связной таблицы
                                    $l_table_info = $l_table['t9301$'];
                                    $show_field = $l_field;
                                    // Выбираем строки по данной связной таблице
                                    // Работает sql кеш
                                    $line_number = 1;
                                    $result = data_select($l_table_info['id'],
                                        '' . $l_table_info['link_field_int_name'] . '=', $line['id'],
                                        ' and status=0' . $l_table_info['filter'] . ' ORDER BY ' . ($l_table_info['def_sort'] ? str_replace("`",
                                            "", $l_table_info['def_sort']) : 'id'));
                                    while ($sub_line = sql_fetch_assoc($result)) {

                                        $this->dlines[$l_table_name . "." . $lang_line_number][$sub_line['id']] = $line_number;
                                        $this->dlines[$l_table_name . "." . $l_field_name][$sub_line['id']] = form_display_type($show_field,
                                            $sub_line, 'text');
                                        if ($show_field['type_field'] == 1) {
                                            $this->dlines[$l_table_name . "." . $l_field_name][$sub_line['id']] = str_replace($d_r,
                                                $d_r2,
                                                $this->dlines[$l_table_name . "." . $l_field_name][$sub_line['id']]);
                                        }
                                        $line_number++;
                                    }

                                };
                            }
                        }
                    }
                }
            }
        }
        // Сортируем $this->dlines по длинне переменных
        if (!function_exists('dline_cmp')) {
            function dline_cmp($l1, $l2)
            {
                return mb_strlen($l1) < mb_strlen($l2);
            }
        }
        uksort($this->dlines, "dline_cmp");

        if ($mode == 1) {
            $this->header_templ = $this->templ;
            $this->templ = $old_templ;
        } elseif ($mode == 2) {
            $this->footer_templ = $this->templ;
            $this->templ = $old_templ;
        }
    }

    // Применить к шаблону excel значения строк и подтаблиц
    // $this->templ - шаблон excel
    // $this->dlines  - данные для вставки в шаблон в формате
    //           $this->dlines['Компания']='База'
    //           $this->dlines['Работа с клиентом.Описание'][43]='Звонок клиенту, успешный.';
    //           $this->dlines['Работа с клиентом.Описание'][45]='Продажа продукта.';
    // В случае если второй элемент является массивом, то интерпретировать как подтаблицу, иначе как обычное поле
    // Возвращает обработанный шаблон готовый к формированию excel файла
    public function apply_dline($mode = 0)
    {
        global $user, $deployed_tables, $xls_functions_list_ext;

        if ($mode == 1) {
            $old_templ = $this->templ;
            $this->templ = $this->header_templ;
        } elseif ($mode == 2) {
            $old_templ = $this->templ;
            $this->templ = $this->footer_templ;
        } elseif ($mode == 3) {
            $old_templ = $this->templ;
            $this->templ = $this->table_header_templ;
        } elseif ($mode == 4) {
            $old_templ = $this->templ;
            $this->templ = $this->table_footer_templ;
        }

        // Массив функций поддерживаемых XLS классом
        // Две функции так как был баг:
        // В этих функциях буква "C" латинская.
        // Чтобы не переписывать все существующие шаблоны у всех клиентов необходимо добавить точно такие же функции только с кириллической "С".
        // Чтобы и старые работали и новые.
        $xls_functions_list = array(
            '$xls_ext->x_propis' => array('Прописью', 'InWords'),
            '$xls_ext->x_propis_m' => array('ПрописьюРублей', 'MoneyInWords'),
            '$xls_ext->x_summ_field' => array('СуммаПоПолю', 'CуммаПоПолю', 'SummOnField'),
            //'$xls_ext->x_summ_field_page'=>array('CуммаПоПолюНаСтранице','SummOnFieldOnPage'),
            '$xls_ext->x_lines_count' => array('КоличествоСтрок', 'LinesCount'),
            '$xls_ext->x_propis_date' => array('ПрописьюДата', 'DateInWords'),
            '$xls_ext->x_propis_month' => array('ПрописьюМесяц', 'MonthInWords'),
            '$xls_ext->x_date_day' => array('ДатаЧисло', 'DateDay'),
            '$xls_ext->x_date_month' => array('ДатаМесяц', 'DateMonth'),
            '$xls_ext->x_date_year' => array('ДатаГод', 'DateYear'),
            '$xls_ext->x_digit' => array('ЧислоФормат', 'DigitFormat'),
        );
        if ($xls_functions_list_ext) {
            $xls_functions_list = array_merge($xls_functions_list, $xls_functions_list_ext);
        } // Позволяем добавить свои функции
        // Формируем обратный массив функций
        foreach ($xls_functions_list as $f_real_name => $xls_names) {
            foreach ($xls_names as $f_xls_name) {
                $f_xls_names[$f_xls_name] = $f_real_name;
            }
        }

        if ($mode != 1 && $mode != 2 && $mode != 3 && $mode != 4) {
            // Трансформируем массив $dlines к $deployed_tables, в котором данные представленны в другом стуктуром виде
            $deployed_tables = array();
            foreach ($this->dlines as $dkey => $one_dline) {
                if (is_array($one_dline)) {  // Подтаблица
                    $p = strpos($dkey, '.');
                    if (!$p) { // Некорректная строка, пропускаем
                        continue;
                    }
                    $p1 = substr($dkey, 0, $p);
                    $p2 = substr($dkey, $p + 1);
                    foreach ($one_dline as $l_id => $val) {
                        $deployed_tables[$p1][$l_id][$p2] = $val;
                    }
                }
            }
        }

        //Инизиализируем переменные для сохранения многостраничных функций
        if ($this->isMultiPages) {
            $currentTemplateIndex = $this->multiData['currentTemplate'] ?: 0;
            if (empty($this->multiData['functions'])) {
                $this->multiData['functions'] = [];
            }
            if (empty($this->multiData['functions'][$currentTemplateIndex])) {
                $this->multiData['functions'][$currentTemplateIndex] = [];
            }   
        }    

        // Перебираем весь шаблон, выделяем переменные, функции, вычисляем значения
        do {
            $repeat_cycle = 0;
            foreach ($this->templ as $row => $value_arr) {
                if ($row['applyed']) {
                    continue;
                }
                foreach ($value_arr as $col => $data) {
                    if ((intval($col) . "") != ($col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    $value = $data['value'];
                    if (!$value) {
                        continue;
                    }

                    preg_match_all("/\{.+}/sU", $value, $a);
                    $a = $a[0];
                    foreach ($a as $one_var) {
                        $orig_var = $one_var = substr($one_var, 1, -1);
                        // Приводим фукнции к вычисляемому виду
                        foreach ($f_xls_names as $one_funct_name => $real_name) {
                            $one_var = str_replace($one_funct_name . "(", $real_name . "(", $one_var);
                        }

                        /*if (strpos($one_var, 'CуммаПоПолюНаСтранице')!==false ||
                         strpos($one_var, 'CуммаПоПолюНаСтраницеНДС')!==false ||
                         strpos($one_var, 'CуммаПоПолюНаСтраницеМинусНДС')!==false)
                       {
                         continue;
                       }*/

                        // Заменяем переменные
                        foreach ($this->dlines as $dkey => $one_dline) {
                            // Смотрим находиться ли данная переменная в ячейке
                            $p = strpos($one_var, $dkey);
                            if ($dkey == "№") {
                                $p = false;
                            }
                            if ($p !== false) {  // Переменная найдена
                                $fine_quotas = 2;
                                $fine_left = 1;
                                if ($p > 0) { // Проверяем левую границу
                                    $f_char = $one_var[$p - 1];
                                    if ($f_char != "'") {
                                        $fine_quotas--;
                                    }
                                    if (!$this->delimeters()[$f_char]) {
                                        $fine_left = 0;
                                    }
                                } else {
                                    $fine_quotas--;
                                }
                                $fine_right = 1;
                                // Проверяем правую границу
                                $f_char = $one_var[$p + strlen($dkey)];
                                if ($f_char != "'") {
                                    $fine_quotas--;
                                }
                                if ($f_char && !$this->delimeters()[$f_char]) {
                                    $fine_right = 0;
                                }
                                if ($fine_left && $fine_right && ($fine_quotas == 0)) { // Цельное слово, находиться не в кавычках
                                    if (is_array($one_dline)) { // Сдвигаем вниз
                                        if (!$this->templ[$row]['shifted']) { // Если не смещали строки, смещаем
                                            $this->shift_templ($this->templ, $row, count($one_dline));
                                            // В результате смещения ломается цикл foreach ($this->templ as $row, перезапускаем его
                                            $repeat_cycle = 1;
                                        }
                                        $i = 0;
                                        foreach ($one_dline as $d_val) { // Особенность подтаблиц, замена переменных происходит не внутри скобок { }, а по всей ячейке!!!
                                            $d_val = str_replace("'", "\\'", $d_val);
                                            $this->templ[$row + $i][$col]['value'] = str_replace($dkey,
                                                "'" . $d_val . "'", $this->templ[$row + $i][$col]['value']);
                                            $one_var = str_replace($dkey, "'" . $d_val . "'", $one_var);
                                            $repeat_cycle = 1;
                                            $i++;
                                        }
                                    } else { // Простейшая замена
                                        $one_dline = str_replace("'", "\\'", $one_dline);
                                        $one_var = str_replace($dkey, "'" . $one_dline . "'", $one_var);
                                    }
                                }
                            }
                        }
                        if ($repeat_cycle) {
                            break;
                        }
                        // Вычисляем значение
                        $one_var = "return " . $one_var . ";"; // Приклеиваем в конец точку с запятой, для правильного синтаксиса
                        if (($user['group_id'] == 1) && $_REQUEST['test_calc']) {
                            echo "<br>\n" . $one_var;
                        }

                        if (strstr($one_var, "'")) {
                            $one_var = calc_form_var($one_var);
                        } else {
                            $one_var = '';
                        }
                        $one_var = str_replace("\r", "", $one_var);
                        if (($user['group_id'] == 1) && $_REQUEST['test_calc']) {
                            echo " - DONE: '" . $one_var . "'";
                        }

                        //Сохраняем координаты ячеек с функциями для многостраничного XLSX-шаблона
                        if ($this->isMultiPages) {                        
                            foreach ($this->multiFunctions as $funcId => $multiFunction) {
                                //Если в ячейке есть функция, сохраняем координаты ячейки, название функции и значение ячейки
                                //Для заполнения в дальнейшем, при генерации итогового многостраничного шаблона
                                if (strpos($value, $multiFunction['search']) !== false) {                                                       
                                    $this->multiData['functions'][$currentTemplateIndex][] = [
                                        'row' => $this->templ[$row][$col]['row'],
                                        'col' => $this->templ[$row][$col]['col'],
                                        'function' => $funcId,
                                        'value' => $value
                                    ];
                                    //Заменяем функцию на заглушку для замены на значение в дальнейшем при обработке
                                    $value = preg_replace($multiFunction['replace'], "__" . $funcId . "__", $value);
                                }
                            }
                        }  

                        // Пишем результат в ячейку
                        $value = $this->templ[$row][$col]['value'] = str_replace('{' . $orig_var . '}', $one_var,
                            $value);
                    }
                    if (!$repeat_cycle) {
                        $this->templ[$row]['applyed'] = 1;
                    }
                }
                if ($repeat_cycle) {
                    break;
                }
            };
        } while ($repeat_cycle);
        // Фиксируем формулы, учитывая смещения
        foreach ($this->templ as $row => $value_arr) {
            unset($this->templ[$row]['applyed']);
            foreach ($value_arr as $col => $data) {
                if ((intval($col) . "") != ($col . "")) {
                    continue;
                } // Если не число, то пропускаем
                if ($data['value'] && substr($data['value'], 0, 1) == '=') {
                    $this->templ[$row][$col]['value'] = $this->shift_formula($this->templ, $row, $col);
                }
            }
        }

        if ($mode == 1) {
            $this->header_templ = $this->templ;
            $this->templ = $old_templ;
        } elseif ($mode == 2) {
            $this->footer_templ = $this->templ;
            $this->templ = $old_templ;
        } elseif ($mode == 3) {
            $this->table_header_templ = $this->templ;
            $this->templ = $old_templ;
        } elseif ($mode == 4) {
            $this->table_footer_templ = $this->templ;
            $this->templ = $old_templ;
        } else {
            // Складываем строки
            $this->print_lines[] = $this->templ;
        }

        // Возвращаем шаблон в первоначальное состояние для следующей строки
        $this->templ = $this->origin_templ;

        //return $this->print_lines;

    }

    // Список разделителей переменных
    private function delimeters(): array
    {
        return array(
            ' ' => 1,
            '~' => 1,
            '!' => 1,
            '@' => 1,
            '#' => 1,
            '$' => 1,
            '%' => 1,
            '^' => 1,
            '&' => 1,
            '*' => 1,
            '(' => 1,
            ')' => 1,
            '-' => 1,
            '+' => 1,
            '`' => 1,
            ';' => 1,
            ',' => 1,
            '/' => 1,
            '<' => 1,
            '>' => 1,
            ':' => 1,
            '|' => 1,
            '\\' => 1,
            '[' => 1,
            ']' => 1,
            '"' => 1,
            '?' => 1,
            '=' => 1
        );
    }

    public function get_shift_for_image($line_num = 0)
    {
        if ($line_num == 0) {
            // высота шапки
            $header_len = 0;
            $lk = key(array_slice($this->header_templ, -1, 1, true));
            for ($i = 0; $i < $lk; $i++) {
                if ($this->header_templ[$i]['height']) {
                    $header_len += $this->header_templ[$i]['height'] * $this->default_pt;
                } else {
                    $header_len += $this->default_row_height;
                }
            }

            // высота футера
            $footer_len = 0;
            $lk = key(array_slice($this->footer_templ, -1, 1, true));
            for ($i = 0; $i < $lk; $i++) {
                if ($this->footer_templ[$i]['height']) {
                    $footer_len += $this->footer_templ[$i]['height'] * $this->default_pt;
                } else {
                    $footer_len += $this->default_row_height;
                }
            }

            $paper_len = $this->paper_height;
            $body_max = $paper_len - $footer_len - $header_len;

            $temp_res_templ = $this->header_templ;

            foreach ($this->print_lines as $one_line) {
                foreach ($one_line as $k => $v) {
                    $one_line_size = 0;
                    if ($v['height']) {
                        $now += $v['height'] * $this->default_pt;
                        $one_line_size += $v['height'] * $this->default_pt;
                    } else {
                        $now += $this->default_row_height;
                        $one_line_size += $this->default_row_height;
                    }

                    if ($v['spaned']) {
                        foreach ($v['spaned_arr'] as $span_key => $span_val) {
                            if ($span_val['height']) {
                                $now += $span_val['height'] * $this->default_pt;
                                $one_line_size += $span_val['height'] * $this->default_pt;
                            } else {
                                $now += $this->default_row_height;
                                $one_line_size += $this->default_row_height;
                            }
                        }
                    }

                    if ($now < $body_max) {
                        $temp_res_templ[] = $v;
                    } else {
                        $lk = key(array_slice($temp_res_templ, -1, 1, true)) - 1;
                        if ($temp_res_templ) {
                            $lk++;
                        }
                        $new_templ = array();
                        foreach ($this->footer_templ as $k => $v) {
                            $new_templ[$k + $lk] = $v;
                        }
                        $temp_res_templ = $temp_res_templ + $new_templ;

                        $lk = key(array_slice($temp_res_templ, -1, 1, true));
                        $this->add_h_page_break($temp_res_templ, $lk);

                        $lk = key(array_slice($temp_res_templ, -1, 1, true)) - 1;
                        if ($temp_res_templ) {
                            $lk++;
                        }
                        $new_templ = array();
                        foreach ($this->header_templ as $k => $v) {
                            $new_templ[$k + $lk] = $v;
                        }
                        $temp_res_templ = $temp_res_templ + $new_templ;
                        $now = $one_line_size;
                        $this->mode_3_shift = 1;
                        return key(array_slice($temp_res_templ, -1, 1, true));
                    }
                }
            }
        } else {
            // высота шапки
            $header_len = 0;
            $lk = key(array_slice($this->header_templ, -1, 1, true));
            for ($i = 0; $i < $lk; $i++) {
                if ($this->header_templ[$i]['height']) {
                    $header_len += $this->header_templ[$i]['height'] * $this->default_pt;
                } else {
                    $header_len += $this->default_row_height;
                }
            }

            // высота футера
            $footer_len = 0;
            $lk = key(array_slice($this->footer_templ, -1, 1, true));
            for ($i = 0; $i < $lk; $i++) {
                if ($this->footer_templ[$i]['height']) {
                    $footer_len += $this->footer_templ[$i]['height'] * $this->default_pt;
                } else {
                    $footer_len += $this->default_row_height;
                }
            }

            $paper_len = $this->paper_height;
            $body_max = $paper_len - $footer_len - $header_len;

            $temp_res_templ = $this->header_templ;

            $shift = key(array_slice($this->header_templ, -1, 1, true)) + key(array_slice($this->footer_templ, -1, 1,
                    true));

            foreach ($this->print_lines as $key_line => $one_line) {

                foreach ($one_line as $k => $v) {
                    $shift++;
                    $one_line_size = 0;
                    if ($v['height']) {
                        $now += $v['height'] * $this->default_pt;
                        $one_line_size += $v['height'] * $this->default_pt;
                    } else {
                        $now += $this->default_row_height;
                        $one_line_size += $this->default_row_height;
                    }

                    if ($v['spaned']) {
                        foreach ($v['spaned_arr'] as $span_key => $span_val) {
                            if ($span_val['height']) {
                                $now += $span_val['height'] * $this->default_pt;
                                $one_line_size += $span_val['height'] * $this->default_pt;
                            } else {
                                $now += $this->default_row_height;
                                $one_line_size += $this->default_row_height;
                            }
                        }
                    }

                    if ($now < $body_max) {
                        $temp_res_templ[] = $v;
                    } else {
                        $lk = key(array_slice($temp_res_templ, -1, 1, true)) - 1;
                        if ($temp_res_templ) {
                            $lk++;
                        }
                        $new_templ = array();
                        foreach ($this->footer_templ as $k => $v) {
                            $new_templ[$k + $lk] = $v;
                        }
                        $temp_res_templ = $temp_res_templ + $new_templ;

                        $lk = key(array_slice($temp_res_templ, -1, 1, true));
                        $this->add_h_page_break($temp_res_templ, $lk);

                        $lk = key(array_slice($temp_res_templ, -1, 1, true)) - 1;
                        if ($temp_res_templ) {
                            $lk++;
                        }
                        $new_templ = array();
                        foreach ($this->header_templ as $k => $v) {
                            $new_templ[$k + $lk] = $v;
                        }
                        $temp_res_templ = $temp_res_templ + $new_templ;
                        $now = $one_line_size;
                        $this->mode_3_shift = 1;

                        $shift += key(array_slice($this->header_templ, -1, 1, true));
                        $shift += key(array_slice($this->footer_templ, -1, 1, true));
                    }
                }
                if ($line_num == $key_line) {
                    return $shift;
                }
            }
        }
        return $shift;
    }

    private function fix_formuls_out($out = 0)
    {
        $header_len = key(array_slice($this->header_templ, -1, 1, true));//$header_len = count($this->header_templ);
        $now = 0;
        $now_line = 1;
        $f_header_len = $header_len;

        for ($i = 0; $i < $this->line_count; $i++) {
            foreach ($this->res_templ as $row => $val) {
                if ($val['line_num'] > $now_line) {
                    $now = $row;
                    $header_len = $row - 1;// - $f_header_len + 1
                    break;
                }

                if ($this->res_templ[$row] != 'h_page_break') {
                    $this->res_templ[$row]['shift'] = $header_len;
                }
                if ($val['line_num'] == $now_line) {
                    foreach ($val as $col => $data) {
                        if ((intval($col) . "") != ($col . "")) {
                            continue;
                        } // Если не число, то пропускаем
                        if ($data['value'] && substr($data['value'], 0, 1) == '=') {
                            $this->res_templ[$row][$col]['value'] = $this->shift_formula($this->res_templ, $row, $col);
                        }
                    }
                }
            }
            $now_line++;
        }

        $this->header_templ = array();
        $this->footer_templ = array();
    }

    // фиксируем формулы при размножении шаблона на страницы
    private function fix_formuls_pages()
    {
        $header_len = key(array_slice($this->header_templ, -1, 1, true));
        $body_len = count($this->templ);
        $footer_len = key(array_slice($this->footer_templ, -1, 1, true));
        $now_line = 1;

        for ($i = 0; $i < count($this->print_lines); $i++) {
            foreach ($this->res_templ as $row => $val) {
                if ($i == 0) {
                    if ($this->res_templ[$row] != 'h_page_break') {
                        $this->res_templ[$row]['shift'] = $header_len;
                    }
                } else {
                    if ($this->res_templ[$row] != 'h_page_break') {
                        $this->res_templ[$row]['shift'] = $header_len + ($header_len + $body_len + $footer_len) * $i + $i * 2;
                    }
                }

                if ($val['line_num'] == $now_line) {
                    foreach ($val as $col => $data) {
                        if ((intval($col) . "") != ($col . "")) {
                            continue;
                        } // Если не число, то пропускаем
                        if ($data['value'] && substr($data['value'], 0, 1) == '=') {
                            $this->res_templ[$row]['shift'] = $now_size;
                            $this->res_templ[$row][$col]['value'] = $this->shift_formula($this->res_templ, $row, $col);
                        }
                    }
                }
            }
            $now_line++;
        }
    }

    private function fix_formuls_pages_implode()
    {
        $header_len = key(array_slice($this->header_templ, -1, 1, true));//count($this->header_templ);
        $now = 0;
        $now_line = 1;
        $f_header_len = $header_len;
        $this->line_count = count($this->print_lines);

        for ($i = 0; $i < $this->line_count; $i++) {
            foreach ($this->res_templ as $row => $val) {
                if ($val['line_num'] > $now_line) {
                    $now = $row;
                    $header_len = $row - 1;// - $f_header_len + 1;
                    break;
                }

                if ($this->res_templ[$row] != 'h_page_break') {
                    $this->res_templ[$row]['shift'] = $header_len;
                }
                if ($val['line_num'] == $now_line) {
                    foreach ($val as $col => $data) {
                        if ((intval($col) . "") != ($col . "")) {
                            continue;
                        } // Если не число, то пропускаем
                        if ($data['value'] && substr($data['value'], 0, 1) == '=') {
                            $this->res_templ[$row][$col]['value'] = $this->shift_formula($this->res_templ, $row, $col);
                        }
                    }
                }
            }
            $now_line++;
        }

        $this->header_templ = array();
        $this->footer_templ = array();
    }

    public function prepare_body_templ()
    {
        $new_templ_img = $this->templ;
        foreach ($new_templ_img as $row => $col_arr) {
            foreach ($col_arr as $col => $val) {
                if (is_array($val) && $val['rowspan'] > 1) {
                    for ($i = $val['rowspan']; $i > 0; $i--) {
                        if (!$new_templ_img[$row + $val['rowspan'] - 1]) {
                            $new_templ_img[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
        }
        return $new_templ_img;
    }

    public function prepare_header_templ()
    {
        $new_header = $this->header_templ;
        foreach ($new_header as $row => $col_arr) {
            foreach ($col_arr as $col => $val) {
                if (is_array($val) && $val['rowspan'] > 1) {
                    for ($i = $val['rowspan']; $i > 0; $i--) {
                        if (!$new_header[$row + $val['rowspan'] - 1]) {
                            $new_header[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
        }
        $this->header_templ = $new_header;
        return $new_header;
    }

    public function prepare_footer_templ()
    {
        $new_footer = $this->footer_templ;
        foreach ($new_footer as $row => $col_arr) {
            foreach ($col_arr as $col => $val) {
                if (is_array($val) && $val['rowspan'] > 1) {
                    for ($i = $val['rowspan']; $i > 0; $i--) {
                        if (!$new_footer[$row + $val['rowspan'] - $i]) {
                            $new_footer[$row + $val['rowspan'] - $i] = array();
                        }
                    }
                }
            }
        }
        $this->footer_templ = $new_footer;
        return $new_footer;
    }

    public function prepare_table_header_templ()
    {
        $new_header = $this->table_header_templ;
        foreach ($new_header as $row => $col_arr) {
            foreach ($col_arr as $col => $val) {
                if (is_array($val) && $val['rowspan'] > 1) {
                    for ($i = $val['rowspan']; $i > 0; $i--) {
                        if (!$new_header[$row + $val['rowspan'] - 1]) {
                            $new_header[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            if (count($col_arr) == 1 && $col_arr['height']) {
                unset($new_header[$row]);
            }
        }
        $this->table_header_templ = $new_header;
        return $new_header;
    }

    public function prepare_table_footer_templ()
    {
        $new_footer = $this->table_footer_templ;
        foreach ($new_footer as $row => $col_arr) {
            foreach ($col_arr as $col => $val) {
                if (is_array($val) && $val['rowspan'] > 1) {
                    for ($i = $val['rowspan']; $i > 0; $i--) {
                        if (!$new_footer[$row + $val['rowspan'] - $i]) {
                            $new_footer[$row + $val['rowspan'] - $i] = array();
                        }
                    }
                } elseif (is_array($val) && count($val) == 1 && $val['width']) {
                    unset($new_footer[$row][$col]);
                }
            }
            if (count($col_arr) == 1 && $col_arr['height']) {
                unset($new_footer[$row]);
            }
        }
        $this->table_footer_templ = $new_footer;
        return $new_footer;
    }

    public function prepare_out()
    {
        $this->get_paper_size();

        // vA - print all in one page
        if ($this->print_mode == 1) {
            $this->out_va();
        }

        // vC - print every line on separate page, vD - implode lines
        if ($this->print_mode == 2) {
            if (!$this->table_header_templ && !$this->table_footer_templ) {
                $this->out_vc2(2);
            } else {
                $this->out_vc(2);
            }
        }
        if ($this->print_mode == 3) {
            $this->out_vD();
        }// O_o lol, see l:2484 function_cron.php

        // Fix formuls
        // 1 - vA
        // 2 - vB
        // 3 - vC
        if ($this->print_mode == 1) {
            $this->fix_formuls_out(0);
        } elseif ($this->print_mode == 2) {
            $this->fix_formuls_pages();
        } elseif ($this->print_mode == 3) {
            $this->fix_formuls_pages_implode();
        }

        unset($this->header_templ);
        unset($this->table_header_templ);
        unset($this->footer_templ);
        unset($this->table_footer_templ);
    }

    private function get_paper_size()
    {
        // mm
        if ($this->orientation != '-L') {
            $this->paper_height_origin = 297;
        } else {
            $this->paper_height_origin = 210;
        }
        $this->default_row_height = 4.5;
        $this->default_top_margin = 25.4;
        $this->default_bottom_margin = 25.4;
        $this->default_pt = 0.3527;//0.40 or 0.3527 ( maybe = 0.48? ) wtf?
        $this->magic_width_coef = 0.82;// magic width coef =) 0.72
        $this->magic_height_coef = 1.07;// magic height coef - please kill me... 1.07

        if ($this->page_size == 11) {
            if ($this->orientation != '-L') {
                $this->paper_height = 183;
            }//210;
            else {
                $this->paper_height = 138;
            }//148;
        } elseif ($this->page_size == 8) {
            if ($this->orientation != '-L') {
                $this->paper_height = 393;
            }//420;
            else {
                $this->paper_height = 287;
            }//297;
        } else {
            if ($this->orientation != '-L') {
                $this->paper_height = 270;
            } else {
                $this->paper_height = 200;
            }
        }

        // inches
        $this->default_top_margin_in = 0;
        $this->default_bottom_margin_in = 0;

        $this->default_left_margin_in = 0.2;
        $this->default_right_margin_in = 0.2;
    }

    // Добавление горизонтального разрыва страницы
    public function add_h_page_break(&$new_templ, $key = 0)
    {
        if (!$key) {
            array_push($this->res_templ, 'h_page_break');
        } else {
            if ($new_templ[$key]) {
                $new_templ[$key][] = 'h_page_break';
            } else {
                $new_templ[$key] = 'h_page_break';
            }
        }
    }

    private function out_vc2($mode = 2)
    {
        $this->use_out = 1;

        $page_i = 0;
        $page_last = count($this->print_lines) - 1;
        $prev_page_ost = 0;
        $page_inline = 0;

        foreach ($this->print_lines as $k => $v) {
            foreach ($v as $k2 => $v2) {
                if (count($v2) == 1 && $v2['height']) {
                    unset($this->print_lines[$k][$k2]);
                }
                if (count($v2) == 2 && $v2['height'] && $v2['shift']) {
                    unset($this->print_lines[$k][$k2]);
                }
                if (count($v2) == 1 && $v2['shift']) {
                    unset($this->print_lines[$k][$k2]);
                }
            }
        }

        foreach ($this->print_lines as $k => $one_line) {
            $this->header_templ = $this->headers_array[$k];
            $this->footer_templ = $this->footers_array[$k];

            if ($mode == 2) {
                $prev_page_ost = 0;
            }
            foreach ($this->header_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->header_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->header_templ[$row + $val['rowspan'] - 1]) {
                            $this->header_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->header_templ);

            foreach ($this->footer_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->footer_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->footer_templ[$row + $val['rowspan'] - 1]) {
                            $this->footer_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->footer_templ);

            foreach ($one_line as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $one_line[$row]['spaned'] = $val['rowspan'];
                        if (!$one_line[$row + $val['rowspan'] - 1]) {
                            $one_line[$row + $val['rowspan'] - 1] = array();
                        }
                        $one_line[$row]['spaned_arr'][$row + $val['rowspan'] - 1] = $one_line[$row + $val['rowspan'] - 1]['height'];
                    }
                }
            }
            ksort($one_line);

            if ($mode == 2 || $page_i == 0 || $page_inline) {
                $lk = key(array_slice($this->res_templ, -1, 1, true));
                $new_templ = array();
                foreach ($this->header_templ as $k => $v) {
                    $new_templ[$k + $lk] = $v;
                }
                $this->res_templ = $this->res_templ + $new_templ;
            }

            // высота шапки
            $now = $prev_page_ost * $this->default_row_height;
            foreach ($this->header_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now += $col_arr['height'] * $this->default_pt;
                } else {
                    $now += $this->default_row_height;
                }
            }

            // высота футера
            $now_f = 0;
            foreach ($this->footer_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now_f += $col_arr['height'] * $this->default_pt;
                } else {
                    $now_f += $this->default_row_height;
                }
            }

            $first_now = $now;
            $lk = key(array_slice($this->res_templ, -1, 1, true));
            $new_templ = array();
            $one_line_page = 1;
            foreach ($one_line as $k => $v) {
                $one_line_now = 0;

                $v['line_num'] = $page_i + 1;// метка строки
                if ($v['height']) {
                    $now += $v['height'] * $this->default_pt;
                    $one_line_now += $v['height'] * $this->default_pt;
                } else {
                    $now += $this->default_row_height;
                    $one_line_now += $this->default_row_height;
                }

                $old_now = $now;
                if ($v['spaned']) {
                    foreach ($v['spaned_arr'] as $span_key => $span_val) {
                        if ($span_val['height']) {
                            $now += $span_val['height'] * $this->default_pt;
                            $one_line_now += $span_val['height'] * $this->default_pt;
                        } else {
                            $now += $this->default_row_height;
                            $one_line_now += $this->default_row_height;
                        }
                    }
                }
                if ($now < ($this->paper_height - $now_f)) {
                    $now = $old_now;
                }

                if ($now < ($this->paper_height - $now_f) || $page_i == 0) {
                    $page_inline = 1;
                } else {
                    $page_inline = 0;
                }

                if ($now >= ($this->paper_height - $now_f))// && $mode!=2 && $page_inline==0
                {
                    $new_lk = 0;
                    $bow = $now - $one_line_now;

                    $lk2 = key(array_slice($new_templ, -1, 1, true));

                    $new_templ2 = array();
                    foreach ($this->footer_templ as $k2 => $v2) {
                        $new_templ2[$k2 + $lk2] = $v2;
                    }
                    $new_templ = $new_templ + $new_templ2;
                    $new_lk += count($new_templ2);

                    $this->add_h_page_break($new_templ, $k2 + $lk2);

                    $lk2 = key(array_slice($new_templ, -1, 1, true));
                    $new_templ2 = array();
                    foreach ($this->header_templ as $k2 => $v2) {
                        $new_templ2[$k2 + $lk2] = $v2;
                    }
                    $new_templ = $new_templ + $new_templ2;
                    $new_lk += count($new_templ2);

                    $now = $first_now;
                    $lk = $lk + $new_lk;
                    $one_line_page++;
                    $prev_page_ost = 0;
                    $the_pb = 1;
                }
                $prev_page_ost++;
                $new_templ[$k + $lk] = $v;
            }
            $this->res_templ = $this->res_templ + $new_templ;
            $page_inline = 0;
            if ($mode == 2 || $page_last == $page_i || $page_inline) {
                $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
                if ($this->res_templ) {
                    $lk++;
                }
                $new_templ = array();
                foreach ($this->footer_templ as $k => $v) {
                    $new_templ[$k + $lk] = $v;
                }
                $this->res_templ = $this->res_templ + $new_templ;

            }
            $lk = key(array_slice($this->res_templ, -1, 1, true));
            if ($mode == 2 || $page_inline) {
                if ($this->print_lines[$page_i + 1] || $page_inline) {
                    $this->add_h_page_break($this->res_templ, $lk);
                }
            }//+1
            if (!$the_pb) {
                $prev_page_ost = 0;
            }
            $page_i++;
        }
    }

    public function check_out_vd()
    {
        $this->get_paper_size();
        // высота шапки
        $header_len = 0;
        $lk = key(array_slice($this->header_templ, -1, 1, true));
        for ($i = 0; $i < $lk; $i++) {
            if ($this->header_templ[$i]['height']) {
                $header_len += $this->header_templ[$i]['height'] * $this->default_pt;
            } else {
                $header_len += $this->default_row_height;
            }
        }

        // высота футера
        $footer_len = 0;
        $lk = key(array_slice($this->footer_templ, -1, 1, true));
        for ($i = 0; $i < $lk; $i++) {
            if ($this->footer_templ[$i]['height']) {
                $footer_len += $this->footer_templ[$i]['height'] * $this->default_pt;
            } else {
                $footer_len += $this->default_row_height;
            }
        }

        $paper_len = $this->paper_height;
        $body_max = $paper_len - $footer_len - $header_len;

        if ($body_max < 4.5) {
            return 0;
        } else {
            return 1;
        }
    }

    private function out_vd()
    {
        $this->use_out = 1;

        // высота шапки
        $header_len = 0;
        $lk = key(array_slice($this->header_templ, -1, 1, true));
        for ($i = 0; $i < $lk; $i++) {
            if ($this->header_templ[$i]['height']) {
                $header_len += $this->header_templ[$i]['height'] * $this->default_pt;
            } else {
                $header_len += $this->default_row_height;
            }
        }

        // высота футера
        $footer_len = 0;
        $lk = key(array_slice($this->footer_templ, -1, 1, true));
        for ($i = 0; $i < $lk; $i++) {
            if ($this->footer_templ[$i]['height']) {
                $footer_len += $this->footer_templ[$i]['height'] * $this->default_pt;
            } else {
                $footer_len += $this->default_row_height;
            }
        }

        $paper_len = $this->paper_height;
        $body_max = $paper_len - $footer_len - $header_len;

        $this->res_templ = $this->header_templ;

        foreach ($this->print_lines as $one_line) {
            foreach ($one_line as $k => $v) {
                $one_line_size = 0;
                if ($v['height']) {
                    $now += $v['height'] * $this->default_pt;
                    $one_line_size += $v['height'] * $this->default_pt;
                } else {
                    $now += $this->default_row_height;
                    $one_line_size += $this->default_row_height;
                }

                if ($v['spaned']) {
                    foreach ($v['spaned_arr'] as $span_key => $span_val) {
                        if ($span_val['height']) {
                            $now += $span_val['height'] * $this->default_pt;
                            $one_line_size += $span_val['height'] * $this->default_pt;
                        } else {
                            $now += $this->default_row_height;
                            $one_line_size += $this->default_row_height;
                        }
                    }
                }

                if ($now < $body_max) {
                    $this->res_templ[] = $v;
                } else {
                    $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
                    if ($this->res_templ) {
                        $lk++;
                    }
                    $new_templ = array();
                    foreach ($this->footer_templ as $k => $v) {
                        $new_templ[$k + $lk] = $v;
                    }
                    $this->res_templ = $this->res_templ + $new_templ;

                    $lk = key(array_slice($this->res_templ, -1, 1, true));
                    $this->add_h_page_break($this->res_templ, $lk);

                    $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
                    if ($this->res_templ) {
                        $lk++;
                    }
                    $new_templ = array();
                    foreach ($this->header_templ as $k => $v) {
                        $new_templ[$k + $lk] = $v;
                    }
                    $this->res_templ = $this->res_templ + $new_templ;
                    $now = $one_line_size;
                }
            }
        }

        $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
        if ($this->res_templ) {
            $lk++;
        }
        $new_templ = array();
        foreach ($this->footer_templ as $k => $v) {
            $new_templ[$k + $lk] = $v;
        }
        $this->res_templ = $this->res_templ + $new_templ;
    }

    private function out_vc($mode = 2)
    {
        $this->use_out = 1;

        $page_i = 0;
        $page_last = count($this->print_lines) - 1;
        $prev_page_ost = 0;
        $page_inline = 0;
        foreach ($this->print_lines as $k => $v) {
            foreach ($v as $k2 => $v2) {
                if (count($v2) == 1 && isset($v2['height'])) {
                    unset($this->print_lines[$k][$k2]);
                }
                if (count($v2) == 2 && isset($v2['height']) && isset($v2['shift'])) {
                    unset($this->print_lines[$k][$k2]);
                }
                if (count($v2) == 1 && isset($v2['shift'])) {
                    unset($this->print_lines[$k][$k2]);
                }
            }
        }
        foreach ($this->print_lines as $k => $one_line) {
            $this->header_templ = $this->headers_array[$k];
            $this->footer_templ = $this->footers_array[$k];

            $this->table_header_templ = $this->table_headers_array[$k];
            $this->table_footer_templ = $this->table_footers_array[$k];

            if ($mode == 2) {
                $prev_page_ost = 0;
            }
            foreach ($this->header_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->header_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->header_templ[$row + $val['rowspan'] - 1]) {
                            $this->header_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->header_templ);

            foreach ($this->footer_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->footer_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->footer_templ[$row + $val['rowspan'] - 1]) {
                            $this->footer_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->footer_templ);

            foreach ($this->table_header_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->table_header_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->table_header_templ[$row + $val['rowspan'] - 1]) {
                            $this->table_header_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->table_header_templ);

            foreach ($this->table_footer_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->table_footer_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->table_footer_templ[$row + $val['rowspan'] - 1]) {
                            $this->table_footer_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->table_footer_templ);


            foreach ($one_line as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $one_line[$row]['spaned'] = $val['rowspan'];
                        if (!$one_line[$row + $val['rowspan'] - 1]) {
                            $one_line[$row + $val['rowspan'] - 1] = array();
                        }
                        $one_line[$row]['spaned_arr'][$row + $val['rowspan'] - 1] = $one_line[$row + $val['rowspan'] - 1]['height'];
                    }
                }
            }
            ksort($one_line);

            if ($mode == 2 || $page_i == 0 || $page_inline) {
                //if ($page_i<1)
                //{
                $lk = key(array_slice($this->res_templ, -1, 1, true));
                $new_templ = array();
                foreach ($this->header_templ as $k => $v) {
                    $new_templ[$k + $lk] = $v;
                }
                $this->res_templ = $this->res_templ + $new_templ;
                //}
            }

            $now_TH = 0;
            $now_TF = 0;
            // высота шапки
            $now = $prev_page_ost * $this->default_row_height;
            foreach ($this->header_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now += $col_arr['height'] * $this->default_pt;
                } else {
                    $now += $this->default_row_height;
                }
            }


            if ($mode == 2 || $page_i == 0 || $page_inline) {
                $lk = key(array_slice($this->res_templ, -1, 1, true));
                $new_templ = array();
                foreach ($this->table_header_templ as $k => $v) {
                    foreach ($v as $t_v => $d_v) {
                        if ($d_v['value']) {
                            $v[$t_v]['value'] = str_replace('{Печать.СтрНомер}', '1', $d_v['value']);
                        }
                    }
                    $new_templ[$k + $lk] = $v;
                }
                $this->res_templ = $this->res_templ + $new_templ;
            }

            // высота TABLE шапки
            foreach ($this->table_header_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now += $col_arr['height'] * $this->default_pt;
                    $now_TH += $col_arr['height'] * $this->default_pt * $this->magic_height_coef;
                } else {
                    $now += $this->default_row_height;
                    $now_TH += $this->default_row_height * $this->magic_height_coef;
                }
            }

            // высота TABLE футера
            foreach ($this->table_footer_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now_TF += $col_arr['height'] * $this->default_pt * $this->magic_height_coef;
                } else {
                    $now_TF += $this->default_row_height * $this->magic_height_coef;
                }
            }


            // высота футера
            $now_f = 0;
            foreach ($this->footer_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now_f += $col_arr['height'] * $this->default_pt;
                } else {
                    $now_f += $this->default_row_height;
                }
            }
            //if ($page_i==0)
            $now_foot2 = $now_f;
            $now_f = 0;

            $first_now = $now;
            $lk = key(array_slice($this->res_templ, -1, 1, true));
            $new_templ = array();
            $one_line_page = 1;
            $now_lines_in = 0;
            $now_lines_out = 0;

            foreach ($one_line as $k => $v) {
                if ($v['height'] && !$base_height) {
                    $base_height = $v['height'];
                } elseif (!$base_height) {
                    $base_height = 8.5;
                } else {
                    $v['height'] = $base_height;
                }

                $now_lines_out++;
                $one_line_now = 0;

                $v['line_num'] = $page_i + 1;// метка строки

                $max_strlen = 0;
                foreach ($v as $temp_k => $temp_v) {
                    if ($temp_v['value'] && $max_strlen < mb_strlen($temp_v['value']) && !is_numeric($temp_v['value'])) {

                        $temp = explode("\n", $temp_v['value']);
                        if (count($temp) > 1 && $v['height']) {
                            //$v['height'] = $v['height'] * 1.2;
                            foreach ($temp as $temp_k2 => $temp_v2) {
                                if (mb_strlen($temp_v2) > 40) {
                                    $v['height'] = $v['height'] * intval(mb_strlen($temp_v2) / 40);
                                }
                            }
                        } else {
                            if (mb_strlen($temp_v['value']) > 120) {
                                $v['height'] = $v['height'] * (mb_strlen($temp_v['value']) / 42);
                                //if (intval(strlen($temp_v['value'])/40)<3) $v['height'] = $v['height'] * 1.2;
                            } elseif (mb_strlen($temp_v['value']) > 28) {
                                $v['height'] = $v['height'] * 1.7 - 1;// + 0.8;
                            }
                        }
                        $v['height'] = $v['height'] * 1.5;
                        $max_strlen = mb_strlen($temp_v['value']);
                    }
                }

                if ($v['height']) {
                    $now += $v['height'] * $this->default_pt;
                    $one_line_now += $v['height'] * $this->default_pt;
                } else {
                    $now += $this->default_row_height;
                    $one_line_now += $this->default_row_height;
                }

                $old_now = $now;
                if ($v['spaned']) {
                    foreach ($v['spaned_arr'] as $span_key => $span_val) {
                        if ($span_val['height']) {
                            $now += $span_val['height'] * $this->default_pt;
                            $one_line_now += $span_val['height'] * $this->default_pt;
                        } else {
                            $now += $this->default_row_height;
                            $one_line_now += $this->default_row_height;
                        }
                    }
                }
                if ($now < ($this->paper_height - $now_f)) {
                    $now = $old_now;
                }

                if ($now < ($this->paper_height - $now_f))// || $page_i==0
                {
                    $page_inline = 1;
                } else {
                    $page_inline = 0;
                }
                $ld_now = $now;

                if ($now >= ($this->paper_height - $now_f) && $page_inline == 0)// && $mode!=2
                {
                    $new_lk = 0;
                    $bow = $now - $one_line_now;

                    $lk2 = key(array_slice($new_templ, -1, 1, true));

                    $new_templ2 = array();
                    foreach ($this->table_footer_templ as $k2 => $v2) {
                        foreach ($v2 as $k3 => $v3) {
                            $var_temp = ($one_line_page <= 2 ? 0 : 1);
                            // Две функции так как был баг:
                            // В этих функциях буква "C" латинская.
                            // Чтобы не переписывать все существующие шаблоны у всех клиентов необходимо добавить точно такие же функции только с кириллической "С".
                            // Чтобы и старые работали и новые.
                            if ((strpos($v3['value'], '{CуммаПоПолюНаСтраницеНДС(') !== false) || (strpos($v3['value'],
                                        '{СуммаПоПолюНаСтраницеНДС(') !== false)
                            ) {
                                $v2[$k3]['value'] = $this->get_lines_info_advanced($v3['value'],
                                    $now_lines_out + $var_temp, $now_lines_in + $var_temp, 1, $page_i, $one_line_page);
                            } elseif ((strpos($v3['value'],
                                        '{CуммаПоПолюНаСтранице(') !== false) || (strpos($v3['value'],
                                        '{СуммаПоПолюНаСтранице(') !== false)
                            ) {
                                $v2[$k3]['value'] = str_replace($v3['value'],
                                    $this->get_lines_info($v3['value'], $now_lines_out + $var_temp,
                                        $now_lines_in + $var_temp, $page_i, $one_line_page), $v3['value']);
                            } elseif ((strpos($v3['value'],
                                        '{CуммаПоПолюНаСтраницеБезНДС(') !== false) || (strpos($v3['value'],
                                        '{СуммаПоПолюНаСтраницеБезНДС(') !== false)
                            ) {
                                $v2[$k3]['value'] = str_replace($v3['value'],
                                    $this->get_lines_info($v3['value'], $now_lines_out + $var_temp,
                                        $now_lines_in + $var_temp, $page_i, $one_line_page, 1), $v3['value']);
                            } elseif ((strpos($v3['value'],
                                        '{CуммаПоПолюНаСтраницеМинусНДС(') !== false) || (strpos($v3['value'],
                                        '{СуммаПоПолюНаСтраницеМинусНДС(') !== false)
                            ) {
                                $v2[$k3]['value'] = $this->get_lines_info_advanced($v3['value'],
                                    $now_lines_out + $var_temp, $now_lines_in + $var_temp, 0, $page_i, $one_line_page);
                            }
                        }
                        $new_templ2[$k2 + $lk2] = $v2;
                    }

                    $new_templ = $new_templ + $new_templ2;
                    $new_lk += count($new_templ2);

                    if ($page_i != 0) {
                        /*$new_templ2 = array();
                    foreach ($this->footer_templ as $k2=>$v2)
                    {
                      $new_templ2[$k2+$lk2] = $v2;
                    }
                    $new_templ = $new_templ + $new_templ2;
                    $new_lk+=count($new_templ2);*/
                    }

                    $this->add_h_page_break($new_templ, $k2 + $lk2);
                    $page_last++;
                    //$now_lines_out = 0;
                    $now_lines_in = $now_lines_out;

                    $lk2 = key(array_slice($new_templ, -1, 1, true));
                    $new_templ2 = array();

                    /*foreach ($this->header_templ as $k2=>$v2)
                {
                  $new_templ2[$k2+$lk2] = $v2;
                }*/

                    /*if ($page_i<1)*/
                    $one_line_page++;
                    foreach ($this->table_header_templ as $k2 => $v2) {
                        foreach ($v2 as $t_v => $d_v) {
                            if ($d_v['value']) {
                                $v2[$t_v]['value'] = str_replace('{Печать.СтрНомер}', $one_line_page, $d_v['value']);
                            }
                        }
                        $new_templ2[$k2 + $lk2] = $v2;
                    }
                    //if ($page_i>0) $one_line_page++;
                    //$one_line_page++;
                    $new_templ = $new_templ + $new_templ2;
                    $new_lk += count($new_templ2);
                    $ld_now = $now;
                    $now = $first_now;
                    $lk = $lk + $new_lk;

                    $prev_page_ost = 0;
                    $the_pb = 1;

                    $now = ($now_TH + $now_TF) * 1.5;
                }
                $prev_page_ost++;
                $new_templ[$k + $lk] = $v;
            }
            $this->res_templ = $this->res_templ + $new_templ;

            $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
            if ($this->res_templ) {
                $lk++;
            }
            $new_templ = array();
            foreach ($this->table_footer_templ as $k => $v) {
                foreach ($v as $k3 => $v3) {
                    $var_temp = ($one_line_page >= 2 ? 1 : 2);
                    // Две функции так как был баг:
                    // В этих функциях буква "C" латинская.
                    // Чтобы не переписывать все существующие шаблоны у всех клиентов необходимо добавить точно такие же функции только с кириллической "С".
                    // Чтобы и старые работали и новые.
                    if ((strpos($v3['value'], '{CуммаПоПолюНаСтраницеНДС(') !== false) || (strpos($v3['value'],
                                '{СуммаПоПолюНаСтраницеНДС(') !== false)
                    ) {
                        $v[$k3]['value'] = $this->get_lines_info_advanced($v3['value'], 0,
                            $now_lines_in + $one_line_page - $var_temp, 1, $page_i, $one_line_page);
                    } elseif ((strpos($v3['value'], '{CуммаПоПолюНаСтранице(') !== false) || (strpos($v3['value'],
                                '{СуммаПоПолюНаСтранице(') !== false)
                    ) {
                        $v[$k3]['value'] = str_replace($v3['value'],
                            $this->get_lines_info($v3['value'], 0, $now_lines_in + $one_line_page - $var_temp, $page_i,
                                $one_line_page), $v3['value']);
                    } elseif ((strpos($v3['value'], '{CуммаПоПолюНаСтраницеБезНДС(') !== false) || (strpos($v3['value'],
                                '{СуммаПоПолюНаСтраницеБезНДС(') !== false)
                    ) {
                        $v[$k3]['value'] = str_replace($v3['value'],
                            $this->get_lines_info($v3['value'], 0, $now_lines_in + $one_line_page - $var_temp, $page_i,
                                $one_line_page, 1), $v3['value']);
                    } elseif ((strpos($v3['value'],
                                '{CуммаПоПолюНаСтраницеМинусНДС(') !== false) || (strpos($v3['value'],
                                '{СуммаПоПолюНаСтраницеМинусНДС(') !== false)
                    ) {
                        $v[$k3]['value'] = $this->get_lines_info_advanced($v3['value'], 0,
                            $now_lines_in + $one_line_page - $var_temp, 0, $page_i, $one_line_page);
                    }
                }
                $new_templ[$k + $lk] = $v;
            }
            $this->res_templ = $this->res_templ + $new_templ;

            if (($ld_now + $now_foot2) > $this->paper_height) {
                $lk_ld = key(array_slice($this->res_templ, -1, 1, true));
                $this->add_h_page_break($this->res_templ, $lk_ld);
            }

            $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
            if ($this->res_templ) {
                $lk++;
            }
            $new_templ = array();
            foreach ($this->footer_templ as $k => $v) {
                $new_templ[$k + $lk] = $v;
            }
            $this->res_templ = $this->res_templ + $new_templ;

            //}
            $lk = key(array_slice($this->res_templ, -1, 1, true));
            if ($mode == 2 || $page_inline) {
                if ($this->print_lines[$page_i + 1] || $page_inline) {
                    $this->add_h_page_break($this->res_templ, $lk);
                }
            }//+1
            if (!$the_pb) {
                $prev_page_ost = 0;
            }
            $page_i++;
        }

        foreach ($this->res_templ as $line => $col_arr) {
            foreach ($col_arr as $col_id => $col) {
                if ($col['width'] && $col['width'] != 'h') {
                    $this->res_templ[$line][$col_id]['width'] = $col['width'] * $this->magic_width_coef;
                }// =)
            }
            if ($col_arr['height']) {
                $this->res_templ[$line]['height'] = $col_arr['height'] * $this->magic_height_coef;
            }// =)
        }
    }

    private function out_vb()
    {
        $this->use_out = 1;

        $page_i = 0;
        $prev_page_ost = 0;
        foreach ($this->print_lines as $one_line) {
            foreach ($this->header_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->header_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->header_templ[$row + $val['rowspan'] - 1]) {
                            $this->header_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->header_templ);

            foreach ($this->footer_templ as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $this->footer_templ[$row]['spaned'] = $val['rowspan'];
                        if (!$this->footer_templ[$row + $val['rowspan'] - 1]) {
                            $this->footer_templ[$row + $val['rowspan'] - 1] = array();
                        }
                    }
                }
            }
            ksort($this->footer_templ);

            foreach ($one_line as $row => $col_arr) {
                foreach ($col_arr as $col => $val) {
                    if (is_array($val) && $val['rowspan'] > 1) {
                        $one_line[$row]['spaned'] = $val['rowspan'];
                        if (!$one_line[$row + $val['rowspan'] - 1]) {
                            $one_line[$row + $val['rowspan'] - 1] = array();
                        }
                        $one_line[$row]['spaned_arr'][$row + $val['rowspan'] - 1] = $one_line[$row + $val['rowspan'] - 1]['height'];
                    }
                }
            }
            ksort($one_line);

            if ($page_i == 0) {
                $lk = key(array_slice($this->res_templ, -1, 1, true));
                $new_templ = array();
                foreach ($this->header_templ as $k => $v) {
                    $new_templ[$k + $lk] = $v;
                }
                $this->res_templ = $this->res_templ + $new_templ;
            }

            // высота шапки
            $now = $prev_page_ost * $this->default_row_height;
            foreach ($this->header_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now += $col_arr['height'] * $this->default_pt;
                } else {
                    $now += $this->default_row_height;
                }
            }

            // высота футера
            $now_f = 0;
            foreach ($this->footer_templ as $row => $col_arr) {
                if ($col_arr['height']) {
                    $now_f += $col_arr['height'] * $this->default_pt;
                } else {
                    $now_f += $this->default_row_height;
                }
            }

            $first_now = $now;
            $lk = key(array_slice($this->res_templ, -1, 1, true));
            $new_templ = array();
            $one_line_page = 1;
            foreach ($one_line as $k => $v) {
                if ($v['height']) {
                    $now += $v['height'] * $this->default_pt;
                } else {
                    $now += $this->default_row_height;
                }

                $old_now = $now;
                if ($v['spaned']) {
                    foreach ($v['spaned_arr'] as $span_key => $span_val) {
                        if ($span_val['height']) {
                            $now += $span_val['height'] * $this->default_pt;
                        } else {
                            $now += $this->default_row_height;
                        }
                    }
                }
                if ($now < ($this->paper_height - $now_f)) {
                    $now = $old_now;
                }

                if ($now >= ($this->paper_height - $now_f)) {
                    $new_lk = 0;

                    $lk2 = key(array_slice($new_templ, -1, 1,
                            true)) + ceil(abs($this->paper_height - $now_f - $now) / 4.5);
                    $new_templ2 = array();
                    foreach ($this->footer_templ as $k2 => $v2) {
                        $new_templ2[$k2 + $lk2] = $v2;
                    }
                    $new_templ = $new_templ + $new_templ2;
                    $new_lk += count($new_templ2);

                    $this->add_h_page_break($new_templ, $k2 + $lk2);

                    $lk2 = key(array_slice($new_templ, -1, 1, true));
                    $new_templ2 = array();
                    foreach ($this->header_templ as $k2 => $v2) {
                        $new_templ2[$k2 + $lk2] = $v2;
                    }
                    $new_templ = $new_templ + $new_templ2;
                    $new_lk += count($new_templ2);

                    $now = $first_now;
                    $lk = $lk + $new_lk + 1;
                    $one_line_page++;
                    $prev_page_ost = 0;
                }
                $prev_page_ost++;
                $new_templ[$k + $lk] = $v;
            }

            $this->res_templ = $this->res_templ + $new_templ;

            if ($page_i == 0 && count($this->print_lines) == 1) {
                $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
                if ($this->res_templ) {
                    $lk++;
                }
                $new_templ = array();
                foreach ($this->footer_templ as $k => $v) {
                    $new_templ[$k + $lk] = $v;
                }
                $this->res_templ = $this->res_templ + $new_templ;
            }
            if ($page_i == (count($this->print_lines) - 1)) {
                $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
                if ($this->res_templ) {
                    $lk++;
                }
                $new_templ = array();
                foreach ($this->footer_templ as $k => $v) {
                    $new_templ[$k + $lk] = $v;
                }
                $this->res_templ = $this->res_templ + $new_templ;
            }

            $page_i++;
        }
    }

    private function out_va()
    {
        $this->use_out = 1;
        $i = 1;

        foreach ($this->print_lines as $one_line) {
            $this->line_count++;

            if (!$this->res_templ) {
                $lk = key(array_slice($this->res_templ, -1, 1, true));
            } else {
                $lk = key(array_slice($this->res_templ, -1, 1, true)) - 1;
            }
            if ($this->res_templ) {
                $lk++;
            }
            $new_templ = array();
            foreach ($one_line as $k => $v) {
                $v['line_num'] = $i;// метка строки
                $new_templ[$k + $lk] = $v;
            }
            $this->res_templ = $this->res_templ + $new_templ;
            $i++;
        }

        foreach ($this->header_templ as $row => $col_arr) {
            foreach ($col_arr as $col => $val) {
                if (is_array($val) && $val['rowspan'] > 1) {
                    if (!$this->header_templ[$row + $val['rowspan'] - 1]) {
                        $this->header_templ[$row + $val['rowspan'] - 1] = array();
                    }
                }
            }
        }

        foreach ($this->res_templ as $row => $col_arr) {
            foreach ($col_arr as $col => $val) {
                if (is_array($val) && isset($val['rowspan']) && ($val['rowspan'] > 1)) {
                    if (!$this->res_templ[$row + $val['rowspan'] - 1]) {
                        $this->res_templ[$row + $val['rowspan'] - 1] = array();
                    }
                }
            }
        }

        $lk = key(array_slice($this->header_templ, -1, 1, true));
        $new_templ = array();
        foreach ($this->res_templ as $k => $v) {
            $new_templ[$k + $lk] = $v;
        }
        $this->res_templ = $new_templ;

        $lk = key(array_slice($this->res_templ, -1, 1, true));
        $new_templ = array();
        foreach ($this->footer_templ as $k => $v) {
            $new_templ[$k + $lk] = $v;
        }
        $this->footer_templ = $new_templ;

        $this->res_templ = array('0' => array()) + (array)$this->header_templ + (array)$this->res_templ + (array)$this->footer_templ;

        ksort($this->res_templ);
    }

    // Записать шаблон excel в результирующий файл
    //  $this->templ - шаблон
    //  $file_name - имя файла на диске в который будет записан файл
    //  $files - массив изображений который будет вставлен в excel файла
    //  $writer_id - id  класса который будет использоваться для формирования результирующего файла
    public function out($file_name = "", $files = "", $writer_id = 1)
    {
        global $user;

        $this->file_name = $file_name;
        $this->files = $files;
        $this->writer_id = $writer_id;

        // Применяем к шаблону результат
        if ($this->res_templ) {
            $this->templ = $this->res_templ;
        }

        if ($this->writer_id === 1) {
            $this->out_spreadshit();
        } elseif ($this->writer_id === 2) {
            $this->out_phpexcel($this->templ, $file_name, $files);
        }

        if (($user['group_id'] == 1) && $_REQUEST['test_calc']) {
            die('<br>\nFINISH.');
        }
    }

    // Устанавливаем размер страницы и ориентацию
    public function set_paper_options($page_size = 9, $orientation = '-P')
    {
        $this->page_size = $page_size;
        $this->orientation = $orientation;
    }

    private function underline_for_spreadshit($val)
    {
        switch ($val) {
            case 'none':
                return 0;
            case 'single':
            case 'singleAccounting':
                return 1;
            case 'double':
            case 'doubleAccounting':
                return 2;
            default:
                return $val;
        }
    }

    // Функция вывода из массива в Excel
    // $this->templ - массив в котором описываются данные документа
    // $this->file_name - имя файла на диске в который будет сохранен документ
    // $this->files - массив в котором указываются файлы
    //   $this->files[]['img'] - данные изображения
    //   $this->files[]['img_type'] - формат данных изображения PNG, GIF, BMP
    //   $this->files[]['img_file'] - прямая ссылка на файл, заменяет параметр $files[]['img']
    //   $this->files[]['width'] - ширина изображения. опциональный параметр, если не задан определяется автоматически исходя из размер изображения
    //   $this->files[]['height'] - высотра изображения. опциональный параметр, если не задан определяется автоматически исходя из размер изображения
    //   $this->files[]['сell_x'] - x позиция в документе адрес ячейки
    //   $this->files[]['offset_x'] - смещение x относительно ячейчки
    //   $this->files[]['cell_y'] - y позиция в документе адрес ячейки
    //   $this->files[]['offset_y'] - смещение y относительно ячейчки
    // $this->writer_id  - 1 - EXCEL_SPREADSHEAT (по умолчанию) , 2 - EXCEL_PHPEXCEL
    private function out_spreadshit()
    {
        $xls_export = new Spreadsheet_Excel_Writer($this->file_name);
        $xls_export->setVersion(8);
        $xls_export->_tmp_dir = $GLOBALS['config']['site_path'] . "/temp";

        if ($this->header_templ) {
            $sheet = $xls_export->addWorksheet('Body');
        } else {
            $sheet = $xls_export->addWorksheet('Binary Count');
        }
        $sheet->setInputEncoding('UTF-8');

        $sheet->setPaper($this->page_size);

        $sheet->setMarginTop($this->default_top_margin_in);
        $sheet->setMarginBottom($this->default_bottom_margin_in);
        $sheet->setMarginLeft($this->default_left_margin_in);
        $sheet->setMarginRight($this->default_right_margin_in);

        $sheet->setHeader('', 0);
        $sheet->setFooter('', 0);

        //$sheet->fitToPages(1, 297);

        if ($this->orientation == '-L') {
            $sheet->setLandscape();
        } else {
            $sheet->setPortrait();
        }

        $sheet->hideGridlines();

        foreach ($this->templ as $row => $value_arr) {
            foreach ($value_arr as $col => $data) {
                if ((intval($col) . "") != ($col . "")) {
                    continue;
                } // Если не число, то пропускаем
                // Объединенные ячейки
                if ($data['rowspan'] || $data['colspan']) {
                    $sheet->setMerge($row - 1, $col - 1, $row - 2 + ($data['rowspan'] ? $data['rowspan'] : 1),
                        $col + ($data['colspan'] ? $data['colspan'] : 1) - 2);
                }
            }
        }
        foreach ($this->templ as $row => $value_arr) {
            if ($value_arr == 'h_page_break') {
                // ставим разрыв страницы
                $sheet->setHPageBreaks(array($row));
                continue;
            }

            foreach ($value_arr as $cur_col => $data) {
                if ($data == 'h_page_break') {
                    // ставим разрыв страницы
                    $sheet->setHPageBreaks(array($row));
                    continue;
                }

                if ($cur_col == 'height') {
                    $sheet->setRow($row - 1, intval($data));
                    continue;
                }
                if ((intval($cur_col) . "") != ($cur_col . "")) {
                    continue;
                } // Если не число, то пропускаем
                $col = $cur_col - 1; // Возвращаем столбец в 0
                if ($data['width']) {
                    $sheet->setColumn($col, $col,
                        (floatval($data['width']) - 0.72) * ($this->templ[1][1]['scale'] ? $this->templ[1][1]['scale'] : 1));
                } else {
                    if ($row == 0) {
                        $sheet->setColumn($col, $col, 10.88);
                    }  // Ширина по умолчанию
                }
                if (isset($data['alighment']) || isset($data['border']) || isset($data['font']) || isset($data['fillcolor']) || (strpos($data['value'],
                            "\n") !== false)
                ) { // Есть форматирование
                    $format = $xls_export->addFormat();
                    if ($data['alighment']['vertical'] == 'center' or $data['alighment']['vertical'] == 'justify') {
                        $valign = "v" . $data['alighment']['vertical'];
                        $format->setAlign($valign);
                    } else {
                        $format->setAlign($data['alighment']['vertical']);
                    }

                    $format->setAlign($data['alighment']['horizontal']);
                    if ($data['alighment']['wrapText'] || (strpos($data['value'], "\n") !== false)) {
                        $format->setTextWrap();
                    }
                    // рамки: 1- тонкая, 2 - средняя, 5 толстая
                    $format->setLeft($this->borders_style_xls($data['border']['leftstyle']));
                    $format->setRight($this->borders_style_xls($data['border']['rightstyle']));
                    $format->setTop($this->borders_style_xls($data['border']['topstyle']));
                    $format->setBottom($this->borders_style_xls($data['border']['bottomstyle']));


                    // цвет рамок
                    if ($data['border']['leftcolor']) {
                        $format->setLeftColor($this->color_pick($data['border']['leftcolor']));
                    }
                    if ($data['border']['rightcolor']) {
                        $format->setRightColor($this->color_pick($data['border']['rightcolor']));
                    }
                    if ($data['border']['topcolor']) {
                        $format->setTopColor($this->color_pick($data['border']['topcolor']));
                    }
                    if ($data['border']['bottomcolor']) {
                        $format->setBottomColor($this->color_pick($data['border']['bottomcolor']));
                    }

                    if ($data['font']['shrift']) {
                        $format->setFontFamily($data['font']['shrift']);
                    }
                    if ($data['font']['bold']) {
                        $format->setBold($data['font']['bold']);
                    }
                    if ($data['font']['italic']) {
                        $format->setItalic();
                    }
                    if ($data['font']['fontsize']) {
                        $format->setSize($data['font']['fontsize']);
                    }
                    if ($data['font']['underline']) {
                        $format->setUnderline($this->underline_for_spreadshit($data['font']['underline']));
                    }
                    if ($data['font']['fontcolor']) {
                        $format->setColor($this->color_pick($data['font']['fontcolor']));
                    }
                    if ($data['fillcolor'] && $data['fillcolor'] != 'FF000000') {
                        $format->setFgColor($this->color_pick(substr($data['fillcolor'], 2, 6)));
                        $format->setPattern(1);
                    }
                    $format->setNumFormat($data['format']);
                    if ($data['rowspan'] || $data['colspan']) {
                        for ($j = 1; $j < $data['rowspan']; $j++) {
                            $this->innerWrite($sheet, $row - 1 + $j, $col, "", $format);
                            if ($data['colspan']) {
                                $this->innerWrite($sheet, $row - 1 + $j, $col + $data['colspan'] - 1, "", $format);
                            }
                        }
                        for ($i = 1; $i < $data['colspan']; $i++) {
                            $this->innerWrite($sheet, $row - 1, $col + $i, "", $format);
                            if ($data['rowspan']) {
                                $this->innerWrite($sheet, $row - 2 + $data['rowspan'], $col + $i, "", $format);
                            }
                        }
                    }
                    $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']), $format);
                } else {
                    $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']));
                }
            }
        }

        require_once('bmpImage/phpthumb.functions.php');
        require_once('bmpImage/BmpImage.class.php');
        if ($this->files) {
            foreach ($this->files as $img_one) {
                if ($img_one['page_i'] > 1 && !$this->use_out) {
                    continue;
                }
                $this->handleImageInsertion($sheet, $img_one);
            }
        }

        if ($this->header_templ) {
            $sheet = $xls_export->addWorksheet('Header');
            $sheet->setInputEncoding('UTF-8');

            $sheet->setPaper($this->page_size);
            if ($this->orientation == '-L') {
                $sheet->setLandscape();
            } else {
                $sheet->setPortrait();
            }

            foreach ($this->header_templ as $row => $value_arr) {
                foreach ($value_arr as $col => $data) {
                    if ((intval($col) . "") != ($col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    // Объединенные ячейки
                    if ($data['rowspan'] || $data['colspan']) {
                        $sheet->setMerge($row - 1, $col - 1, $row - 2 + ($data['rowspan'] ? $data['rowspan'] : 1),
                            $col + ($data['colspan'] ? $data['colspan'] : 1) - 2);
                    }
                }
            }
            foreach ($this->header_templ as $row => $value_arr) {
                if ($value_arr == 'h_page_break') {
                    // ставим разрыв страницы
                    $sheet->setHPageBreaks(array($row));
                    continue;
                }

                foreach ($value_arr as $cur_col => $data) {
                    if ($cur_col == 'height') {
                        $sheet->setRow($row - 1, intval($data));
                        continue;
                    }
                    if ((intval($cur_col) . "") != ($cur_col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    $col = $cur_col - 1; // Возвращаем столбец в 0
                    if ($data['width']) {
                        $sheet->setColumn($col, $col,
                            (floatval($data['width']) - 0.72) * ($this->header_templ[1][1]['scale'] ? $this->header_templ[1][1]['scale'] : 1));
                    } else {
                        if ($row == 0) {
                            $sheet->setColumn($col, $col, 10.88);
                        }  // Ширина по умолчанию
                    }
                    if (isset($data['alighment']) || isset($data['border']) || isset($data['font']) || isset($data['fillcolor']) || (strpos($data['value'],
                                "\n") !== false)
                    ) { // Есть форматирование
                        $format = $xls_export->addFormat();
                        if ($data['alighment']['vertical'] == 'center' or $data['alighment']['vertical'] == 'justify') {
                            $valign = "v" . $data['alighment']['vertical'];
                            $format->setAlign($valign);
                        } else {
                            $format->setAlign($data['alighment']['vertical']);
                        }

                        $format->setAlign($data['alighment']['horizontal']);
                        if ($data['alighment']['wrapText'] || (strpos($data['value'], "\n") !== false)) {
                            $format->setTextWrap();
                        }
                        // рамки: 1- тонкая, 2 - средняя, 5 толстая
                        $format->setLeft($this->borders_style_xls($data['border']['leftstyle']));
                        $format->setRight($this->borders_style_xls($data['border']['rightstyle']));
                        $format->setTop($this->borders_style_xls($data['border']['topstyle']));
                        $format->setBottom($this->borders_style_xls($data['border']['bottomstyle']));


                        // цвет рамок
                        if ($data['border']['leftcolor']) {
                            $format->setLeftColor($this->color_pick($data['border']['leftcolor']));
                        }
                        if ($data['border']['rightcolor']) {
                            $format->setRightColor($this->color_pick($data['border']['rightcolor']));
                        }
                        if ($data['border']['topcolor']) {
                            $format->setTopColor($this->color_pick($data['border']['topcolor']));
                        }
                        if ($data['border']['bottomcolor']) {
                            $format->setBottomColor($this->color_pick($data['border']['bottomcolor']));
                        }

                        if ($data['font']['shrift']) {
                            $format->setFontFamily($data['font']['shrift']);
                        }
                        if ($data['font']['bold']) {
                            $format->setBold($data['font']['bold']);
                        }
                        if ($data['font']['italic']) {
                            $format->setItalic();
                        }
                        if ($data['font']['fontsize']) {
                            $format->setSize($data['font']['fontsize']);
                        }
                        if ($data['font']['underline']) {
                            $format->setUnderline($this->underline_for_spreadshit($data['font']['underline']));
                        }
                        if ($data['font']['fontcolor']) {
                            $format->setColor($this->color_pick($data['font']['fontcolor']));
                        }
                        if ($data['fillcolor'] && $data['fillcolor'] != 'FF000000') {
                            $format->setFgColor($this->color_pick(substr($data['fillcolor'], 2, 6)));
                            $format->setPattern(1);
                        }
                        $format->setNumFormat($data['format']);
                        if ($data['rowspan'] || $data['colspan']) {
                            for ($j = 1; $j < $data['rowspan']; $j++) {
                                $this->innerWrite($sheet, $row - 1 + $j, $col, "", $format);
                                if ($data['colspan']) {
                                    $this->innerWrite($sheet, $row - 1 + $j, $col + $data['colspan'] - 1, "", $format);
                                }
                            }
                            for ($i = 1; $i < $data['colspan']; $i++) {
                                $this->innerWrite($sheet, $row - 1, $col + $i, "", $format);
                                if ($data['rowspan']) {
                                    $this->innerWrite($sheet, $row - 2 + $data['rowspan'], $col + $i, "", $format);
                                }
                            }
                        }
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']), $format);
                    } else {
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']));
                    }
                }
            }

            if ($this->files) {
                foreach ($this->files as $img_one) {
                    if ($img_one['page_i'] != 2) {
                        continue;
                    }
                    $this->handleImageInsertion($sheet, $img_one);
                }
            }
        }

        if ($this->footer_templ) {
            $sheet = $xls_export->addWorksheet('Footer');
            $sheet->setInputEncoding('UTF-8');

            $sheet->setPaper($this->page_size);
            if ($this->orientation == '-L') {
                $sheet->setLandscape();
            } else {
                $sheet->setPortrait();
            }

            foreach ($this->footer_templ as $row => $value_arr) {
                foreach ($value_arr as $col => $data) {
                    if ((intval($col) . "") != ($col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    // Объединенные ячейки
                    if ($data['rowspan'] || $data['colspan']) {
                        $sheet->setMerge($row - 1, $col - 1, $row - 2 + ($data['rowspan'] ? $data['rowspan'] : 1),
                            $col + ($data['colspan'] ? $data['colspan'] : 1) - 2);
                    }
                }
            }
            foreach ($this->footer_templ as $row => $value_arr) {
                if ($value_arr == 'h_page_break') {
                    // ставим разрыв страницы
                    $sheet->setHPageBreaks(array($row));
                    continue;
                }

                foreach ($value_arr as $cur_col => $data) {
                    if ($cur_col == 'height') {
                        $sheet->setRow($row - 1, intval($data));
                        continue;
                    }
                    if ((intval($cur_col) . "") != ($cur_col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    $col = $cur_col - 1; // Возвращаем столбец в 0
                    if ($data['width']) {
                        $sheet->setColumn($col, $col,
                            (floatval($data['width']) - 0.72) * ($this->footer_templ[1][1]['scale'] ? $this->footer_templ[1][1]['scale'] : 1));
                    } else {
                        if ($row == 0) {
                            $sheet->setColumn($col, $col, 10.88);
                        }  // Ширина по умолчанию
                    }
                    if (isset($data['alighment']) || isset($data['border']) || isset($data['font']) || isset($data['fillcolor']) || (strpos($data['value'],
                                "\n") !== false)
                    ) { // Есть форматирование
                        $format = $xls_export->addFormat();
                        if ($data['alighment']['vertical'] == 'center' or $data['alighment']['vertical'] == 'justify') {
                            $valign = "v" . $data['alighment']['vertical'];
                            $format->setAlign($valign);
                        } else {
                            $format->setAlign($data['alighment']['vertical']);
                        }

                        $format->setAlign($data['alighment']['horizontal']);
                        if ($data['alighment']['wrapText'] || (strpos($data['value'], "\n") !== false)) {
                            $format->setTextWrap();
                        }
                        // рамки: 1- тонкая, 2 - средняя, 5 толстая
                        $format->setLeft($this->borders_style_xls($data['border']['leftstyle']));
                        $format->setRight($this->borders_style_xls($data['border']['rightstyle']));
                        $format->setTop($this->borders_style_xls($data['border']['topstyle']));
                        $format->setBottom($this->borders_style_xls($data['border']['bottomstyle']));


                        // цвет рамок
                        if ($data['border']['leftcolor']) {
                            $format->setLeftColor($this->color_pick($data['border']['leftcolor']));
                        }
                        if ($data['border']['rightcolor']) {
                            $format->setRightColor($this->color_pick($data['border']['rightcolor']));
                        }
                        if ($data['border']['topcolor']) {
                            $format->setTopColor($this->color_pick($data['border']['topcolor']));
                        }
                        if ($data['border']['bottomcolor']) {
                            $format->setBottomColor($this->color_pick($data['border']['bottomcolor']));
                        }

                        if ($data['font']['shrift']) {
                            $format->setFontFamily($data['font']['shrift']);
                        }
                        if ($data['font']['bold']) {
                            $format->setBold($data['font']['bold']);
                        }
                        if ($data['font']['italic']) {
                            $format->setItalic();
                        }
                        if ($data['font']['fontsize']) {
                            $format->setSize($data['font']['fontsize']);
                        }
                        if ($data['font']['underline']) {
                            $format->setUnderline($this->underline_for_spreadshit($data['font']['underline']));
                        }
                        if ($data['font']['fontcolor']) {
                            $format->setColor($this->color_pick($data['font']['fontcolor']));
                        }
                        if ($data['fillcolor'] && $data['fillcolor'] != 'FF000000') {
                            $format->setFgColor($this->color_pick(substr($data['fillcolor'], 2, 6)));
                            $format->setPattern(1);
                        }
                        $format->setNumFormat($data['format']);
                        if ($data['rowspan'] || $data['colspan']) {
                            for ($j = 1; $j < $data['rowspan']; $j++) {
                                $this->innerWrite($sheet, $row - 1 + $j, $col, "", $format);
                                if ($data['colspan']) {
                                    $this->innerWrite($sheet, $row - 1 + $j, $col + $data['colspan'] - 1, "", $format);
                                }
                            }
                            for ($i = 1; $i < $data['colspan']; $i++) {
                                $this->innerWrite($sheet, $row - 1, $col + $i, "", $format);
                                if ($data['rowspan']) {
                                    $this->innerWrite($sheet, $row - 2 + $data['rowspan'], $col + $i, "", $format);
                                }
                            }
                        }
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']), $format);
                    } else {
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']));
                    }
                }
            }

            if ($this->files) {
                foreach ($this->files as $img_one) {
                    if ($img_one['page_i'] != 3) {
                        continue;
                    }
                    $this->handleImageInsertion($sheet, $img_one);
                }
            }
        }

        if ($this->table_header_templ) {
            $sheet = $xls_export->addWorksheet('Table Header');
            $sheet->setInputEncoding('UTF-8');

            $sheet->setPaper($this->page_size);
            if ($this->orientation == '-L') {
                $sheet->setLandscape();
            } else {
                $sheet->setPortrait();
            }

            foreach ($this->table_header_templ as $row => $value_arr) {
                foreach ($value_arr as $col => $data) {
                    if ((intval($col) . "") != ($col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    // Объединенные ячейки
                    if ($data['rowspan'] || $data['colspan']) {
                        $sheet->setMerge($row - 1, $col - 1, $row - 2 + ($data['rowspan'] ? $data['rowspan'] : 1),
                            $col + ($data['colspan'] ? $data['colspan'] : 1) - 2);
                    }
                }
            }
            foreach ($this->table_header_templ as $row => $value_arr) {
                if ($value_arr == 'h_page_break') {
                    // ставим разрыв страницы
                    $sheet->setHPageBreaks(array($row));
                    continue;
                }

                foreach ($value_arr as $cur_col => $data) {
                    if ($cur_col == 'height') {
                        $sheet->setRow($row - 1, intval($data));
                        continue;
                    }
                    if ((intval($cur_col) . "") != ($cur_col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    $col = $cur_col - 1; // Возвращаем столбец в 0
                    if ($data['width']) {
                        $sheet->setColumn($col, $col,
                            (floatval($data['width']) - 0.72) * ($this->table_header_templ[1][1]['scale'] ? $this->table_header_templ[1][1]['scale'] : 1));
                    } else {
                        if ($row == 0) {
                            $sheet->setColumn($col, $col, 10.88);
                        }  // Ширина по умолчанию
                    }
                    if (isset($data['alighment']) || isset($data['border']) || isset($data['font']) || isset($data['fillcolor']) || (strpos($data['value'],
                                "\n") !== false)
                    ) { // Есть форматирование
                        $format = $xls_export->addFormat();
                        if ($data['alighment']['vertical'] == 'center' or $data['alighment']['vertical'] == 'justify') {
                            $valign = "v" . $data['alighment']['vertical'];
                            $format->setAlign($valign);
                        } else {
                            $format->setAlign($data['alighment']['vertical']);
                        }

                        $format->setAlign($data['alighment']['horizontal']);
                        if ($data['alighment']['wrapText'] || (strpos($data['value'], "\n") !== false)) {
                            $format->setTextWrap();
                        }
                        // рамки: 1- тонкая, 2 - средняя, 5 толстая
                        $format->setLeft($this->borders_style_xls($data['border']['leftstyle']));
                        $format->setRight($this->borders_style_xls($data['border']['rightstyle']));
                        $format->setTop($this->borders_style_xls($data['border']['topstyle']));
                        $format->setBottom($this->borders_style_xls($data['border']['bottomstyle']));


                        // цвет рамок
                        if ($data['border']['leftcolor']) {
                            $format->setLeftColor($this->color_pick($data['border']['leftcolor']));
                        }
                        if ($data['border']['rightcolor']) {
                            $format->setRightColor($this->color_pick($data['border']['rightcolor']));
                        }
                        if ($data['border']['topcolor']) {
                            $format->setTopColor($this->color_pick($data['border']['topcolor']));
                        }
                        if ($data['border']['bottomcolor']) {
                            $format->setBottomColor($this->color_pick($data['border']['bottomcolor']));
                        }

                        if ($data['font']['shrift']) {
                            $format->setFontFamily($data['font']['shrift']);
                        }
                        if ($data['font']['bold']) {
                            $format->setBold($data['font']['bold']);
                        }
                        if ($data['font']['italic']) {
                            $format->setItalic();
                        }
                        if ($data['font']['fontsize']) {
                            $format->setSize($data['font']['fontsize']);
                        }
                        if ($data['font']['underline']) {
                            $format->setUnderline($this->underline_for_spreadshit($data['font']['underline']));
                        }
                        if ($data['font']['fontcolor']) {
                            $format->setColor($this->color_pick($data['font']['fontcolor']));
                        }
                        if ($data['fillcolor'] && $data['fillcolor'] != 'FF000000') {
                            $format->setFgColor($this->color_pick(substr($data['fillcolor'], 2, 6)));
                            $format->setPattern(1);
                        }
                        $format->setNumFormat($data['format']);
                        if ($data['rowspan'] || $data['colspan']) {
                            for ($j = 1; $j < $data['rowspan']; $j++) {
                                $this->innerWrite($sheet, $row - 1 + $j, $col, "", $format);
                                if ($data['colspan']) {
                                    $this->innerWrite($sheet, $row - 1 + $j, $col + $data['colspan'] - 1, "", $format);
                                }
                            }
                            for ($i = 1; $i < $data['colspan']; $i++) {
                                $this->innerWrite($sheet, $row - 1, $col + $i, "", $format);
                                if ($data['rowspan']) {
                                    $this->innerWrite($sheet, $row - 2 + $data['rowspan'], $col + $i, "", $format);
                                }
                            }
                        }
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']), $format);
                    } else {
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']));
                    }
                }
            }

            if ($this->files) {
                foreach ($this->files as $img_one) {
                    if ($img_one['page_i'] != 2) {
                        continue;
                    }
                    $this->handleImageInsertion($sheet, $img_one);
                }
            }
        }

        if ($this->table_footer_templ) {
            $sheet = $xls_export->addWorksheet('Table Footer');
            $sheet->setInputEncoding('UTF-8');

            $sheet->setPaper($this->page_size);
            if ($this->orientation == '-L') {
                $sheet->setLandscape();
            } else {
                $sheet->setPortrait();
            }

            foreach ($this->table_footer_templ as $row => $value_arr) {
                foreach ($value_arr as $col => $data) {
                    if ((intval($col) . "") != ($col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    // Объединенные ячейки
                    if ($data['rowspan'] || $data['colspan']) {
                        $sheet->setMerge($row - 1, $col - 1, $row - 2 + ($data['rowspan'] ? $data['rowspan'] : 1),
                            $col + ($data['colspan'] ? $data['colspan'] : 1) - 2);
                    }
                }
            }
            foreach ($this->table_footer_templ as $row => $value_arr) {
                if ($value_arr == 'h_page_break') {
                    // ставим разрыв страницы
                    $sheet->setHPageBreaks(array($row));
                    continue;
                }

                foreach ($value_arr as $cur_col => $data) {
                    if ($cur_col == 'height') {
                        $sheet->setRow($row - 1, intval($data));
                        continue;
                    }
                    if ((intval($cur_col) . "") != ($cur_col . "")) {
                        continue;
                    } // Если не число, то пропускаем
                    $col = $cur_col - 1; // Возвращаем столбец в 0
                    if ($data['width']) {
                        $sheet->setColumn($col, $col,
                            (floatval($data['width']) - 0.72) * ($this->table_footer_templ[1][1]['scale'] ? $this->table_footer_templ[1][1]['scale'] : 1));
                    } else {
                        if ($row == 0) {
                            $sheet->setColumn($col, $col, 10.88);
                        }  // Ширина по умолчанию
                    }
                    if (isset($data['alighment']) || isset($data['border']) || isset($data['font']) || isset($data['fillcolor']) || (strpos($data['value'],
                                "\n") !== false)
                    ) { // Есть форматирование
                        $format = $xls_export->addFormat();
                        if ($data['alighment']['vertical'] == 'center' or $data['alighment']['vertical'] == 'justify') {
                            $valign = "v" . $data['alighment']['vertical'];
                            $format->setAlign($valign);
                        } else {
                            $format->setAlign($data['alighment']['vertical']);
                        }

                        $format->setAlign($data['alighment']['horizontal']);
                        if ($data['alighment']['wrapText'] || (strpos($data['value'], "\n") !== false)) {
                            $format->setTextWrap();
                        }
                        // рамки: 1- тонкая, 2 - средняя, 5 толстая
                        $format->setLeft($this->borders_style_xls($data['border']['leftstyle']));
                        $format->setRight($this->borders_style_xls($data['border']['rightstyle']));
                        $format->setTop($this->borders_style_xls($data['border']['topstyle']));
                        $format->setBottom($this->borders_style_xls($data['border']['bottomstyle']));


                        // цвет рамок
                        if ($data['border']['leftcolor']) {
                            $format->setLeftColor($this->color_pick($data['border']['leftcolor']));
                        }
                        if ($data['border']['rightcolor']) {
                            $format->setRightColor($this->color_pick($data['border']['rightcolor']));
                        }
                        if ($data['border']['topcolor']) {
                            $format->setTopColor($this->color_pick($data['border']['topcolor']));
                        }
                        if ($data['border']['bottomcolor']) {
                            $format->setBottomColor($this->color_pick($data['border']['bottomcolor']));
                        }

                        if ($data['font']['shrift']) {
                            $format->setFontFamily($data['font']['shrift']);
                        }
                        if ($data['font']['bold']) {
                            $format->setBold($data['font']['bold']);
                        }
                        if ($data['font']['italic']) {
                            $format->setItalic();
                        }
                        if ($data['font']['fontsize']) {
                            $format->setSize($data['font']['fontsize']);
                        }
                        if ($data['font']['underline']) {
                            $format->setUnderline($this->underline_for_spreadshit($data['font']['underline']));
                        }
                        if ($data['font']['fontcolor']) {
                            $format->setColor($this->color_pick($data['font']['fontcolor']));
                        }
                        if ($data['fillcolor'] && $data['fillcolor'] != 'FF000000') {
                            $format->setFgColor($this->color_pick(substr($data['fillcolor'], 2, 6)));
                            $format->setPattern(1);
                        }
                        $format->setNumFormat($data['format']);
                        if ($data['rowspan'] || $data['colspan']) {
                            for ($j = 1; $j < $data['rowspan']; $j++) {
                                $this->innerWrite($sheet, $row - 1 + $j, $col, "", $format);
                                if ($data['colspan']) {
                                    $this->innerWrite($sheet, $row - 1 + $j, $col + $data['colspan'] - 1, "", $format);
                                }
                            }
                            for ($i = 1; $i < $data['colspan']; $i++) {
                                $this->innerWrite($sheet, $row - 1, $col + $i, "", $format);
                                if ($data['rowspan']) {
                                    $this->innerWrite($sheet, $row - 2 + $data['rowspan'], $col + $i, "", $format);
                                }
                            }
                        }
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']), $format);
                    } else {
                        $this->innerWrite($sheet, $row - 1, $col, html_wash($data['value']));
                    }
                }
            }

            if ($this->files) {
                foreach ($this->files as $img_one) {
                    if ($img_one['page_i'] != 3) {
                        continue;
                    }
                    $this->handleImageInsertion($sheet, $img_one);
                }
            }
        }

        $xls_export->close();
    }

    private function out_phpexcel($templ, $file_name, $files)
    {
        $locale = 'ru';
        $validLocale = \PhpOffice\PhpSpreadsheet\Settings::setLocale($locale);
        $pExcel = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $pExcel->setActiveSheetIndex(0);
        $aSheet = $pExcel->getActiveSheet();
        if ($this->header_templ) {
            $aSheet->setTitle('Body');
        } else {
            $aSheet->setTitle('Binary Count');
        }

        foreach ($templ as $row => $value_arr) {
            if ($value_arr['height']) {
                $aSheet->getRowDimension($row)->setRowHeight($value_arr['height']);
            }
            foreach ($value_arr as $col => $data) {
                if ((intval($col) . "") != ($col . "")) {
                    continue;
                } // Если не число, то пропускаем
                if (!isset($data['empty'])) {
                    $col = $col-1;
                    $col_string = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($col);

                    if ($data['width']) {
                        $aSheet->getColumnDimension($col_string)->setWidth($data['width'] * ($this->templ[1][1]['scale'] ? $this->templ[1][1]['scale'] : 1));
                    }

                    if ($data['rowspan'] || $data['colspan']) {
                        $data['rowspan'] = $data['rowspan'] ? $data['rowspan'] : 1;
                        $data['colspan'] = $data['colspan'] ? $data['colspan'] : 1;
                        $merge_start = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($col) . ($row);
                        $merge_finish = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($col + $data['colspan'] - 1) . ($row + $data['rowspan'] - 1);
                        $aSheet->mergeCells($merge_start . ':' . $merge_finish);
                    }
                    $cell = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($col) . ($row);
                    if ($data['value'] != '') {
                        if ($data['value'][0] == '=') {
                            $qqq = \PhpOffice\PhpSpreadsheet\Calculation\Calculation::getInstance()->_translateFormulaToEnglish($data['value']);
                            $aSheet->getCell($cell)->setDataType(\PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_FORMULA)->setValue($qqq);
                        } else {
                            $aSheet->setCellValue($cell, html_wash($data['value']));
                        }
                    }
                    //format
                    $styleArray = array(
                        'font' => array(
                            'bold' => $data['font']['bold'],
                            'name' => $data['font']['shrift'],
                            'italic' => $data['font']['italic'],
                            'size' => $data['font']['fontsize'],
                            'color' => array('rgb' => $data['font']['fontcolor'])
                        ),
                        'alignment' => array(
                            'horizontal' => $data['alighment']['horizontal'],
                            'vertical' => $data['alighment']['vertical'],
                            'wraptext' => $data['alighment']['wrapText'],
                            'shrinktofit' => $data['alighment']['shrinkToFit'],

                        ),
                        'borders' => array(
                            'top' => array(
                                'style' => $data['border']['topstyle'],
                                'color' => array('rgb' => $data['border']['topcolor'])
                            ),
                            'right' => array(
                                'style' => $data['border']['rightstyle'],
                                'color' => array('rgb' => $data['border']['rightcolor'])
                            ),
                            'bottom' => array(
                                'style' => $data['border']['bottomstyle'],
                                'color' => array('rgb' => $data['border']['bottomcolor'])
                            ),
                            'left' => array(
                                'style' => $data['border']['leftstyle'],
                                'color' => array('rgb' => $data['border']['leftcolor'])
                            )

                        ),
                    );

                    $styleArray['fill'] = array(
                        'type' => $data['typefill'],
                        'startcolor' => array('argb' => $data['fillcolor'])
                    );
                    $aSheet->getStyle($cell)->applyFromArray($styleArray);
                    $aSheet->getStyle($cell)->getNumberFormat()->setFormatCode($data['format']);


                }
            }
        }
        if ($files) {
            foreach ($files as $img_one) {
                $coord = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($img_one['cell_x']) . ($img_one['cell_y']);
                $coord_file_name = $GLOBALS['config']['site_path'] . '/temp/' . $coord . '.png';
                if (!$img_one['img_file']) {
                    file_put_contents($coord_file_name, $img_one['img']);
                    $iDrowing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                    $iDrowing->setPath($coord_file_name, true);
                } else {
                    $iDrowing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                    $iDrowing->setPath($img_one['img_file'], true);
                }
                $iDrowing->setOffsetX($img_one['offset_x']);
                $iDrowing->setOffsetY($img_one['offset_y']);
                $iDrowing->setCoordinates($coord);
                $iDrowing->setResizeProportional(false);
                $iDrowing->setWidth($img_one['width'] * 0.8543);
                $iDrowing->setHeight($img_one['height'] * 0.9589);
                $iDrowing->setWorksheet($pExcel->getActiveSheet());
            }
        }

        $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($pExcel, 'Xls');
        $objWriter->save($file_name);
    }

    private function borders_style_xls($boderstyle = null)
    {
        if ($boderstyle && $boderstyle != 'none') {
            if ($boderstyle == 'medium') {
                return 2;
            } elseif ($boderstyle == 'thick') {
                return 5;
            } else {
                return 1;
            }
        }
    }

    private function color_pick($data)
    {
        $col_str = 'a:46:{s:6:"FFFFFF";d:9;s:6:"FF0000";d:10;s:6:"00FF00";d:11;s:6:"0000FF";d:39;s:6:"FFFF00";d:34;s:6:"FF00FF";d:33;s:6:"00FFFF";d:35;s:6:"000000";d:8;i:800000;d:37;s:6:"008000";d:17;s:6:"000080";d:32;i:808000;d:19;i:800080;d:36;s:6:"008080";d:38;s:6:"C0C0C0";d:22;i:808080;d:23;s:6:"9999FF";d:24;i:993366;d:61;s:6:"FFFFCC";d:26;s:6:"CCFFFF";d:41;i:660066;d:28;s:6:"FF8080";d:29;s:6:"0066CC";d:30;s:6:"CCCCFF";d:31;s:6:"00CCFF";d:40;s:6:"CCFFCC";d:42;s:6:"FFFF99";d:43;s:6:"99CCFF";d:44;s:6:"FF99CC";d:45;s:6:"CC99FF";d:46;s:6:"FFCC99";d:47;s:6:"3366FF";d:48;s:6:"33CCCC";d:49;s:6:"99CC00";d:50;s:6:"FFCC00";d:51;s:6:"FF9900";d:52;s:6:"FF6600";d:53;i:666699;d:54;i:969696;d:55;s:6:"003366";d:56;i:339966;d:57;s:6:"003300";d:58;i:333300;d:59;i:993300;d:60;i:333399;d:62;i:333333;d:63;};';

        $color = unserialize($col_str);
        $otk_old = 10000;
        if ($k = $color[$data]) {
            return $k;
        } else {
            $c1 = hexdec(substr($data, 0, 2));
            $c2 = hexdec(substr($data, 2, 2));
            $c3 = hexdec(substr($data, 4, 2));

            foreach ($color as $col => $key) {
                $o1 = abs($c1 - hexdec(substr($col, 0, 2)));
                $o2 = abs($c2 - hexdec(substr($col, 2, 2)));
                $o3 = abs($c3 - hexdec(substr($col, 4, 2)));
                $otk = $o1 + $o2 + $o3;
                if ($otk_old > $otk) {
                    $otk_old = $otk;
                    $new_key = $key;
                }
            }
            return $new_key;
        }
    }

    // функция использовалась при старом экспорте в .pdf
    private function style_td($xls, $row, $col)
    {
        if ($xls[$row][$col]['border'] || $xls[$row][$col]['font'] || $xls[$row][$col]['border']) {
            $str = " style=\"";
            if ($xls[$row][$col]['border']) {
                if ($xls[$row][$col]['border']['leftstyle'] && $xls[$row][$col]['border']['leftstyle'] != 'none') {
                    $px = $this->borders_style_xls($xls[$row][$col]['border']['leftstyle']);
                    $str .= "border-left: solid {$px}px #{$xls[$row][$col]['border']['leftcolor']};";
                }
                if ($xls[$row][$col]['border']['rightstyle'] && $xls[$row][$col]['border']['rightstyle'] != 'none') {
                    $px = $this->borders_style_xls($xls[$row][$col]['border']['rightstyle']);
                    $str .= "border-right: solid {$px}px #{$xls[$row][$col]['border']['rightcolor']};";
                }
                if ($xls[$row][$col]['border']['topstyle'] && $xls[$row][$col]['border']['topstyle'] != 'none') {
                    $px = $this->borders_style_xls($xls[$row][$col]['border']['topstyle']);
                    $str .= "border-top: solid {$px}px #{$xls[$row][$col]['border']['topcolor']};";
                }
                if ($xls[$row][$col]['border']['bottomstyle'] && $xls[$row][$col]['border']['bottomstyle'] != 'none') {
                    $px = $this->borders_style_xls($xls[$row][$col]['border']['bottomstyle']);
                    $str .= "border-bottom: solid {$px}px #{$xls[$row][$col]['border']['bottomcolor']};";
                }
            }
            if ($xls[$row][$col]['font']) {
                if ($xls[$row][$col]['font']['underline']) {
                    $font = "underline ";
                }
                if ($xls[$row][$col]['font']['italic']) {
                    $font .= " italic ";
                }

                $str .= "font:{$font}{$xls[$row][$col]['font']['fontsize']}pt serif;";
                if ($xls[$row][$col]['font']['fontsize']) {
                    $str .= "font-size: {$xls[$row][$col]['font']['fontsize']}pt;";
                }
                if ($xls[$row][$col]['font']['bold']) {
                    $str .= "font-weight:bold;";
                }
                if ($xls[$row][$col]['font']['shrift']) {
                    $str .= "font-family:{$xls[$row][$col]['font']['shrift']};";
                }
                if ($xls[$row][$col]['font']['fontcolor']) {
                    $str .= "color:#{$xls[$row][$col]['font']['fontcolor']};";
                }
            }
            if ($xls[$row][$col]['alighment']) {
                if ($xls[$row][$col]['alighment']['wrapText'] == 1) {
                    $str .= "white-space: pre-line;";
                } else {
                    $str .= "white-space: nowrap;";
                }
                $str .= "vertical-align: {$xls[$row][$col]['alighment']['vertical']};";
                $str .= "text-align: {$xls[$row][$col]['alighment']['horizontal']};";
            }

            $str .= "\"";
            return $str;

        }
    }

    // Сместить строки в шаблоне excel
    // $templ - шаблон excel
    // $start_row   - номер строки с которой произойдет смещение, не включительно.
    // $shift - количество строк на которое необходимо сместить строки, включая оригинальную строку
    private function shift_templ(& $templ, $start_row, $shift)
    {
        $templ[$start_row]['shifted'] += $shift;
        $shift--;
        // Сдвигаем номера которые ниже заданного стоблца
        $o_templ = $templ;
        foreach ($o_templ as $row => $value) {
            if ($row > $start_row) {
                $templ[$row + $shift] = $o_templ[$row];
                $templ[$row]['shift'] += $shift;
                if (!$o_templ[$row - $shift]) { // Затираем ячейку с сохранением шифта
                    $t_s = $templ[$row]['shift'];
                    unset($templ[$row]);
                    if ($t_s) {
                        $templ[$row]['shift'] = $t_s;
                    }
                }
            }
        }
        // Фиксируем пустоты копированием текущей строки
        for ($i = 1; $i <= $shift; $i++) {
            $templ[$start_row + $i] = $o_templ[$start_row];
            $templ[$start_row + $i]['shift'] += $i;
        }
        ksort($templ); // Пересотируем шаблон, чтобы соблюсти порядок записей
    }

    // Фукнция возвращает новую строку с измененными формулами в строки учитывая смещение строки
    // $templ - шаблон
    // $row   - строка ячейки с формулой
    // $col   - столбец ячейки с формулой
    private function shift_formula($templ, $row, $col)
    {
        $value = $templ[$row][$col]['value'];    // Сама формула
        // Необходимы для использования  columnIndexFromString
        if ($value[0] != "=") {
            return $value;
        }

        if (preg_match_all("/[A-ZА-Я]+\(([A-Z]+[0-9]+)\)/i", $value,
            $a)) { // Формула диапазон, например для подсчета сумм в подтаблице SUM(AB44), расширяется в диапазон с учетом $shift
            foreach ($a[1] as $key => $cell) {
                $cell_impl = $this->splitcell($cell);
                $cell_row = $cell_impl['row'];
                // Смотрим в данную ячейку
                if ($templ[$cell_row]['shifted']) {  // Ячейка является подтаблицей, применяем расширенние на всю подтаблицу
                    $new_cell = $cell . ':' . ($cell_impl['col']) . ($cell_row + $templ[$cell_row]['shifted'] - 1);
                    $value = str_replace("(" . $cell . ")", "(" . $new_cell . ")", $value);
                } else { // Ячейка не является подтаблицей, обычная ячейка на данные
                    // применяем смещение данной ячейки
                    $cell_shift = $templ[$cell_row]['shift'];
                    // Прибавляем данное смещение к строке и заменяем значение в формуле
                    $new_cell = $cell_impl['col'] . ($cell_row + $cell_shift);
                    $value = str_replace("(" . $cell . ")", "(" . $new_cell . ")", $value);
                }
            }
        } elseif (preg_match_all("/[A-ZА-Я]+\(([A-Z]+[0-9]+):([A-Z]+[0-9]+)\)/i", $value,
            $a)) { // Формула диапазон, например для подсчета сумм в подтаблице SUM(AB44), расширяется в диапазон с учетом $shift
            $cnt = count($a) - 1;
            for ($cnt_i = 1; $cnt_i <= $cnt; $cnt_i++) {
                foreach ($a[$cnt_i] as $key => $cell) {
                    $cell_impl = $this->splitcell($cell);
                    $cell_row = $cell_impl['row'];
                    if ($cnt_i == 1) {
                        $cell_row_shift = $cell_row;
                    }

                    $new_cell = $cell_impl['col'] . ($cell_row + $templ[$cell_row_shift]['shift']);

                    $value = str_replace($cell . ":", $new_cell . ":", $value);
                    $value = str_replace($cell . ")", $new_cell . ")", $value);
                }
            }
        } else {
            if (preg_match_all("/[A-Z]+[0-9]+/", $value, $a)) { // Формула обычного вида AB44 + DE33
                foreach ($a[0] as $cell) {
                    $cell_impl = $this->splitcell($cell);
                    $cell_row = $cell_impl['row'];
                    // Смотрим в данную ячейку
                    if ($templ[$cell_row]['shifted']) {  // Ячейка является подтаблицей, применяем смещение текущей строки
                        $cell_shift = $templ[$row]['shift'];
                    } else { // Ячейка не является подтаблицей, обычная ячейка на данные
                        // применяем смещение данной ячейки
                        $cell_shift = $templ[$cell_row]['shift'];
                    }
                    // Прибавляем данное смещение к строке и заменяем значение в формуле
                    $new_cell = $cell_impl['col'] . ($cell_row + $cell_shift);
                    $value = str_replace($cell, $new_cell, $value);
                }
            }
        }
        return $value;
    }

    private function splitcell($cell)
    {
        // в 0 - буква, в 1 цифра. До 2 букв только работает.
        if ($cell[1] > 0 and $cell[1] <= 9) {
            $pos = 1;
        } else {
            $pos = 2;
        }
        $cell_array['col'] = substr($cell, 0, $pos);
        $cell_array['row'] = substr($cell, $pos);

        return $cell_array;
    }

    public function serialize($var = null)
    {
        if ($var == bm_excel::USE_FILES) {
            $var = $this->files;
            if (count($var) > 0) {
                $this->img_for_excel = 1;
            }
        } else {
            $var = $this->templ;
        }

        return serialize($this->pre_serialize($var));
    }

    private function pre_serialize($arr)
    {
        $res = array();
        foreach ($arr as $k => $v) {
            if (is_array($v)) {
                $res[$k . ""] = $this->pre_serialize($v);
            } else {
                $res["" . $k] = $v . "";
            }
        }
        return $res;
    }

    /**
     * Получить параметры функции СуммаПоПолюНаСтранице
     * Возвращает массив: [ID-поля-для-суммирования, процент-ндс, p]
     */
    private function get_summ_fields($func) 
    {
        $result = [];

        preg_match_all('#.*\((.*?)\)#', $func, $fields);

        $all_fields = explode(',', $fields[1][0]);

        //Есть параметры для учета НДС
        if (!empty($all_fields[1]) && !empty($all_fields[2])) {
            $all_fields[1] = explode('.', $all_fields[1]);
            if ($all_fields[1][1]) {
                $all_fields[1] = $all_fields[1][1];
            }
            $all_fields[2] = explode('.', $all_fields[2]);
            if ($all_fields[2][1]) {
                $all_fields[2] = $all_fields[2][1];
            }
            // 0 - main field
            // 1 - if nds == yes
            // 2 - nds %

            foreach ($this->line_array_fields_advanced as $id => $arr) {
                if ($arr['name_field'] == $all_fields[1]) {
                    $field_id = $id;
                }
                if ($arr['name_field'] == $all_fields[2]) {
                    $field_id2 = $id;
                }
            }
            $percent = 0;
            if ($this->line_array_advanced['f' . $field_id] == 'Да' || $this->line_array_advanced['f' . $field_id] == 'Нет') {
                if ($this->line_array_advanced['f' . $field_id] == 'Нет') {
                    $p = 2;
                }
                $percent = $this->line_array_advanced['f' . $field_id2];
            }

            $result[1] = $percent;
            $result[2] = $p;
        }

        foreach ($this->line_array_fields as $id => $arr) {
            if ($arr['name_field'] == $all_fields[0]) {
                $field_id = $id;
            }
        }
        
        $result[0] = $field_id;

        return $result;
    }

    private function get_lines_info($func, $now_lines_out, $now_lines_in = 0, $line_i = 0, $page_i = 0, $if_nds = 0)
    {
        global $nds;

        if ($page_i == 1) {
            $now_lines_out--;
        }
        if ($now_lines_out > 1 && $page_i > 1) {
            $now_lines_out = $now_lines_out - $page_i + 1;
        }
        if ($now_lines_out > 0) {
            $now_lines_in = $now_lines_in - $page_i + 1;
        } else {
            $now_lines_in = $now_lines_in - $page_i;
        }
        if ($now_lines_out == $now_lines_in) {
            $now_lines_out++;
        }

        list($field_id) = $this->get_summ_fields($func);

        $return_sum = 0;
        $i = 0;
        foreach ($this->line_array[$line_i] as $id => $arr) {
            if ($now_lines_out > 0) {
                if ($i >= $now_lines_in && $i < $now_lines_out) {
                    $return_sum += $arr['f' . $field_id];
                }
            } else {
                if ($i >= $now_lines_in) {
                    $return_sum += $arr['f' . $field_id];
                }
            }

            $i++;
        }

        if ($nds && !$if_nds) {
            $return_sum += $nds;
        }

        return $return_sum;
    }

    //get_lines_info_advanced($v3['value'], $now_lines_out, $now_lines_in)
    private function get_lines_info_advanced(
        $func,
        $now_lines_out,
        $now_lines_in = 0,
        $param = 0,
        $line_i = 0,
        $page_i = 0
    ) {
        global $nds;

        if ($page_i == 1) {
            $now_lines_out--;
        }
        if ($now_lines_out > 1 && $page_i > 1) {
            $now_lines_out = $now_lines_out - $page_i + 1;
        }
        if ($now_lines_out > 0) {
            $now_lines_in = $now_lines_in - $page_i + 1;
        } else {
            $now_lines_in = $now_lines_in - $page_i;
        }
        if ($now_lines_out == $now_lines_in) {
            $now_lines_out++;
        }

        list($field_id, $percent, $p) = $this->get_summ_fields($func);

        $return_sum = 0;
        $i = 0;
        foreach ($this->line_array[$line_i] as $id => $arr) {
            if ($now_lines_out > 0) {
                if ($i >= $now_lines_in && $i < $now_lines_out) {
                    $return_sum += $arr['f' . $field_id];
                }
            } else {
                if ($i >= $now_lines_in) {
                    $return_sum += $arr['f' . $field_id];
                }
            }

            $i++;
        }

        if ($percent > 0) {
            if ($p == 2 && $param == 1) {
                $nds = $return_sum * $percent / 100;
                return $return_sum * $percent / 100;
            }
            if ($param == 1) {
                return $return_sum * $percent / (100 + $percent);
            }
            if ($p != 2) {
                $return_sum -= $return_sum * $percent / (100 + $percent);
            }
        } elseif ($param == 1) {
            return '';
        }

        return $return_sum;
    }

    /**
     * Выводить длинные числа как строки, чтобы обеспечить совместимость со старой логикой работы шаблонов
     */
    private function innerWrite($sheet, $row, $col, $token, $format = null)
    {
        if (isset($format) && $format->_num_format=='@') {
            $sheet->writeString($row, $col, $token, $format);
        } else {
            $sheet->write($row, $col, $token, $format);
        }
    }

    /**
     * Выполнить вставку картинки из БД в шаблон
     *
     * Функция создана для обобщения повторяющегося винтажного кода и исправления взаимодействия с сервисом Spreadsheet_Excel_Writer
     *
     * @param Spreadsheet_Excel_Writer_Worksheet $sheet Excel-лист, куда вставляем картинку
     * @param array $img_one информация о вставляемом изображении
     *
     * @return void
     */
    private function handleImageInsertion($sheet, $img_one)
    {
        $temp_file_name = $GLOBALS['config']['site_path'] . '/temp/' . uniqid('xlstmplttemp');
        if ($img_one['img_file']) {
            $img_png = imagecreatefrompng($img_one['img_file']);
        } else {
            file_put_contents($temp_file_name, $img_one['img']);
            $img_png = @imagecreatefrompng($temp_file_name);
        }
        if ($img_png) {
            $img_width = imagesx($img_png);
            $img_width_y = imagesy($img_png);
            if ($img_one['width']) {
                $resize_x = $img_one['width'] / $img_width;
            }
            if ($img_one['height']) {
                $resize_y = $img_one['height'] / $img_width_y;
            }
            $im = tools_BmpImage::GD2BMPstring($img_png);
            file_put_contents($temp_file_name, $im);
            $sheet->insertBitmap($img_one['cell_y'] - 1, $img_one['cell_x'], $temp_file_name, $img_one['offset_x'], $img_one['offset_y'], $resize_x, $resize_y);
            unlink($temp_file_name);
        }
    }
}

class bm_excel_ext
{
    // Число пропиьсю
    public function x_propis($str, $caps = 0)
    {
        return num2str($str, 'none', 'none', $caps);
    }

    // Сумма в рублях прописью
    public function x_propis_m($str, $currency = '', $cents = '', $caps = 1)
    {
        return num2str(round($str, 2), $currency, $cents, $caps);
    }

    // Magic Сумма подтаблицы по полю
    public function x_summ_field($str)
    {
        if (!strpos($str, ".")) {
            return "Invalid field";
        }
        global $deployed_tables;
        $total_count = 0;
        $table_name = substr($str, 0, strpos($str, "."));
        $field_name = substr($str, strpos($str, ".") + 1);
        $table_data = $deployed_tables[$table_name];
        if (!is_array($table_data)) {
            return 0;
        }
        foreach ($table_data as $one_line) {
            $total_count = $total_count + $one_line[$field_name];
        }
        return $total_count;
    }

    // Magic Сумма подтаблицы по полю на странице
    public function x_summ_field_page($str)
    {
        if (!strpos($str, ".")) {
            return "Invalid field";
        }
        global $deployed_tables;
        $total_count = 0;
        $table_name = substr($str, 0, strpos($str, "."));
        $field_name = substr($str, strpos($str, ".") + 1);
        $table_data = $deployed_tables[$table_name];
        if (!is_array($table_data)) {
            return 0;
        }
        foreach ($table_data as $one_line) {
            $total_count = $total_count + $one_line[$field_name];
        }
        return $total_count;
    }

    // Magic Количество строк в подтаблице
    public function x_lines_count($str)
    {
        global $deployed_tables;
        return count($deployed_tables[$str]);
    }

    // ПрописьюДата
    public function x_propis_date($str)
    {
        return data2str(strtotime(form_eng_time($str)));
    }

    // ПрописьюМесяц
    public function x_propis_month($str, $p = 1)
    {
        global $lang;
        return $lang[date("F", strtotime(form_eng_time($str)))];
    }

    // ДатаЧисло
    public function x_date_day($str)
    {
        return date("d", strtotime(form_eng_time($str)));
    }

    // ДатаМесяц
    public function x_date_month($str)
    {
        return date("m", strtotime(form_eng_time($str)));
    }

    // ДатаГод
    public function x_date_year($str)
    {
        return date("Y", strtotime(form_eng_time($str)));
    }

    // Вывод числа, с указанным форматом
    public function x_digit($str, $digits = 2, $nospace = 0)
    {
        global $lang;
        return number_format($str, $digits, $lang['float_delimiter'], $nospace ? ' ' : '');
    }

}
