export default class Model {
    public getData(url: string, params: object = {}): any {
        return fetch(url, params)
            .then((response: any) => {
                 return response.json();
            })
            .catch((): void => {
                throw new Error(`Error with loading data`);
            });
    }

    public setData(url: string, data: any, params: object = {
        method: `POST`,
        body: data
    }): any {
        return fetch(url, params)
            .then((res: Response) => {
                return res.json();
            })
            .catch((): void => {
                throw new Error(`Error with saving data`);
            })
    }

    public deleteLine(url: string, params: object = {
        method: `DELETE`
    }): any {
        return fetch(url, params)
            .catch((err: Error): void => {
                throw new Error(`Error with saving data, ${err}`);
            });
    }
}