const fields = {
  //Сопоставление таблиц КБ и объектов внешнего приложения
  tables: {
    name: {
      type: "input-text",
      default: "",
      is_list_name: "table",
      required: true,
      help: "gpt_table_name",
    },

    instant: {
      type: "dropdown",
      options: {
        0: "Отложенная обработка (по cron)",
        1: "Сразу после получения запроса",
      },
      default: 1,
      help: "gpt_table_instance",
    },

    internal_object_id: {
      type: "dropdown",
      optionsFrom: {
        source: "tables",
      },
      required: true,
      help: "gpt_internal_object",
    },

    status_service_field: {
      type: "dropdown",
      optionsFrom: {
        source: "fields",
        parent: "internal_object_id"
      },
      help: "gpt_status_service_field",
    },

    "external_action": {
      "type": "dropdown",
      "options": {
          "text_to_text": "Текст - Текст",
          "text_to_image": "Текст - Изображение",
          "txt_to_text": "Текстовый файл - Текст",
          "text_to_txt": "Текст - Текстовый файл",
          "word_to_text": "Word docx - Текст",
          "word_to_word": "Word docx - Word docx",
          "audio_to_text": "Аудио - Текст",
          "text_to_audio": "Текст - Аудио",
          "text_add_lines": "Текст - Добавление строк"
      },
      "required": true,
      "help": "clientbasegpt_external_action"
    },      

    calc: {
      type: "html",
      help: "integration_auto_calc"
    }
    /*
        'fields_mapping': {
            type: "fields-mapping",
            fieldsFrom: {
                app_object: "external_object_type",
                table: "internal_object_id"
            }
        }
*/
  },

  // Информация
  token_limit: {
    type: "text",
    default: "Использовано {{limit_token_request}} из {{limit_token_generate}}",
    help: "gpt_information_token_limit",
  },
};

export default fields;
