const fields = {

    "url": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "model": {
        "type": "dropdown",
        "size": "medium",
        "options": {
            "gpt-4o" : "gpt-4o",
            "gpt-4o-mini": "gpt-4o-mini",
            "gpt-3.5-turbo": "gpt-3.5-turbo",
            "gpt-4.1": "gpt-4.1",
            "gpt-4.1-mini": "gpt-4.1-mini",
            "gpt-4.1-nano": "gpt-4.1-nano",
            "o3-mini": "o3-mini",
            "o3-mini-high": "o3-mini-high",
        },
        "required": true
    },

    "api-key": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },
    "limit-cb-token": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "table-list": {
        "users-table": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "tables"
            },
            "required": true
        },
       
        "key-login": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "fields",
                "parent": "users-table",
            },
            "required": true
        },
        "modules": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "users-table",
            },
            "required": true
        },
        "count-used-cb-token": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "users-table",
            },
            "required": true
        },
        "tariff-name": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "users-table",
            },
            "required": true
        },
        "count-cb-token": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "users-table",
            },
            "required": true
        },
        "count-images-request": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "users-table",
            },
            "required": true
        },
        "count-symbol-request": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "users-table",
            },
            "required": true
        },
        "activation-date": {
                "type": "dropdown",
                "size": "medium",
                "optionsFrom": {
                "source": "fields",
                "parent": "users-table",
                },
                "required": true
        },
        "servise-count": {
                "type": "dropdown",
                "size": "medium",
                "optionsFrom": {
                "source": "fields",
                "parent": "users-table",
                },
                "required": true
        },
        "service-symbol-limit": {
                "type": "dropdown",
                "size": "medium",
                "optionsFrom": {
                "source": "fields",
                "parent": "users-table",
                },
                "required": true
        }
    },

    "model-php8": {
        "type": "dropdown",
        "size": "medium",
        "options": {
            "gpt-4o" : "gpt-4o",
            "gpt-4o-mini": "gpt-4o-mini",
            "gpt-3.5-turbo": "gpt-3.5-turbo",
            "gpt-4.1": "gpt-4.1",
            "gpt-4.1-mini": "gpt-4.1-mini",
            "gpt-4.1-nano": "gpt-4.1-nano",
            "o3-mini": "o3-mini",
            "o3-mini-high": "o3-mini-high",
        },
        "required": true
    },

    "api-key-php8": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },
    "limit-symbol-php8": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },
    "prompt": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },
    "role-php8": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "host": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "port": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "user": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "pass": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "vhost": {
        "type": "input-text",
        "size": "medium",
        "default": "",
    },

    "checkbox-groups": {
        "type": "checkbox",
        "optionsFrom": {
            "source": "groups"
        }
    }

}

export default fields;
