'use strict';

import { initWindow } from './../../../../stocks/telephony/scripts/initWindow.js';
import { createElement } from './../../../../stocks/telephony/scripts/common.js';
import { initStore } from './../../../../stocks/telephony/Vue/scripts/store.js';
import { localStorageListeners } from './../../../../stocks/telephony/Vue/scripts/localStorageListeners.js';
import storeFunctions from './../../../../stocks/telephony/Vue/Mixins/StoreFunctions.js';

import { CallButton } from './../../../../stocks/telephony/Vue/Components/CallButton.js';
import { CallBlock } from './../../../../stocks/telephony/Vue/Components/CallBlock.js';

import localeEn from './locale/en.js';
import localeRu from './locale/ru.js';

createElement('link', { rel: 'stylesheet', href: 'stocks/telephony/styles/style.css' }, document.head, 'append');

CB.styles.globed(/*css*/`
  #call-block__primatel_v2 {
    position: fixed;
    z-index: 9999;
  }
`);

document.addEventListener('DOMContentLoaded', async function(){
  createElement('div', { id: 'call-button__primatel_v2' }, document.querySelector('.header__user-item--user'), 'prepand');
  createElement('div', { id: 'call-block__primatel_v2' }, document.querySelector('body'), 'append');

  let elements = [
    {
      block: 'call-button__primatel_v2',
      el: CallButton
    },
    {
      block: 'call-block__primatel_v2',
      el: CallBlock
    }
  ];

  let telephony_options = {
    name: 'primatel_v2',
    api_name: 'iptel_primatel_v2',
    prefix: 'telephony_primatel_v2',
  };

  initStore(telephony_options.prefix);
  localStorageListeners(telephony_options.prefix);

  let current_locale = CB.globals.config.lang == "russian" ? "ru" : "en";
  const wallI18n = VueI18n.createI18n({
    locale: current_locale,
    fallbackLocale: 'en',
    messages: {
      en: localeEn,
      ru: localeRu,
    },
  });

  for(let el of elements){
    //Очищаем блок, если вдруг что-то в него добавилось
    document.getElementById(el.block).innerHTML = "";

    Vue.createApp(el.el(telephony_options))
      .mixin(storeFunctions(telephony_options.prefix))
      .use(CB.store.useStore())
      .use(wallI18n)
      .mount(`#${el.block}`);
  }

  CB.telephony_helper = {
    call(phone) {
      // показать "номер-набиратель"
      CB.store.dispatch('telephony_primatel_v2/setValue', {
        name: 'is_showed_call_block',
        data: true,
        useLS: true,
      });
      // заполнить номер в "номер-набиратель"
      CB.store.dispatch('telephony_primatel_v2/setValue', {
        name: 'phone_number',
        data: phone,
        useLS: true,
      });
      // совершить вызов
      CB.store.dispatch('telephony_primatel_v2/setValue', {
        name: 'goCall',
        data: true,
        useLS: true,
      });
    }
  }


  /** Проверка доступности окна телефонии */
  function telephonyWindowInterval() {
    // console.log("telephony window interval");
    let store = localforage.createInstance({
      name: "clientbase"
    });

    function checkTelephonyWindowStatus() {
      store.getItem('telephony_window_time').then(time => {
        if (time === null || time === "") {
          reopenTelephonyWindow();
        } else if(Date.parse(time) < Date.parse(new Date)) {
          reopenTelephonyWindow();
        }
      });
    }

    function reopenTelephonyWindow() {
      let current = new Date((new Date()).getTime() + 60000);

      store.setItem('telephony_window_time', current).then(time => {
        initWindow(telephony_options);
      });
    }

    checkTelephonyWindowStatus();
  }

  setInterval(telephonyWindowInterval, 10000);
  telephonyWindowInterval();
});
