import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import DeleteButtonStyles from './DeleteButtonStyles.js';

const DeleteButton = {
  template: /*html*/`
    <button
      :class="componentClass + hash"
      @click="onClick" 
      :title="$t('editform_button_delete')"
    >
      <img src="images/b_drop.png">
    </button>
  `,
  props: {
    index: Number,
  },
  data() {
    return {
      componentClass: 'delete-button',
    }
  },
  mixins: [useScopedStyleMixin, DeleteButtonStyles],
  name: 'delete-button',
  methods: {
    onClick(e) {
      e.preventDefault();
      this.$emit('click', this.index, e);
    },
  },
};

export default DeleteButton