/**
 * Компонент Редактор записи
 */
import { useRecordEditorStore } from '../storeRecordEditor.js'


const template = /*html*/`
<div class="card">
  <div v-for="col of columns" :field="col.int_name" :header="col.field_name" :key="col.id" class="field grid">
    <label :for="'fld_'+col.id" class="col-12 mb-2 md:col-2 md:mb-0">{{col.field_name}}</label>
    <div class="col-12 md:col-10">
      <input v-model="record[col.int_name]" :id="'fld_'+col.id" type="text" :disabled="col.field_type>=10"
        class="text-base text-color surface-overlay p-2 border-1 border-solid surface-border border-round appearance-none outline-none focus:border-primary w-full"
      />
    </div>
  </div>
  <div>
    <p-button @click="persistRecord()" class="p-button-outlined mr-2">Сохранить на сервер</p-button>
    <p-button @click="hideRecordEditor()" class="p-button-outlined mr-2">Закрыть</p-button>
  </div>
</div>
<!--
<pre v-pre>{{ record }}</pre>
<pre v-pre>{{ columns }}</pre>
-->
`;

export default {
  template,
  components: {
    "p-button": primevue.button,
  },

  setup() {
    const recordEditorStore = useRecordEditorStore()
    const { record, columns } = Pinia.storeToRefs(recordEditorStore)

    return {
      record,
      columns,
      persistRecord: recordEditorStore.persistRecord,
      hideRecordEditor: recordEditorStore.hideRecordEditor,
    }
  },
}

CB.styles.globed(/*css*/`
`);
