import { CellViewComponent } from "./CellViewComponent.js";
import useKOSearchBlockStore from "./../store/index.js";


export const TableComponent = {
  components: {
    'cell-view-component': CellViewComponent
  },

  props: ['rows'],

  setup(props, {emit}) {
    const store = useKOSearchBlockStore();

    Vue.onMounted(() => {
      setTimeout(() => $('.repconview__table_table').fixedTable(), 500)
    });

    return {
      store
    }
  },

  template: /*html*/`
    <table
      v-if='rows.length > 0'
      :id="store.block_name"
      :table_id="store.table_id"

      class="repconview__table_alignment_center"
      style="overflow: hidden;"
    >
      <thead>
        <tr>
          <template v-for='column in store.columns'>
            <th
              v-if='column.hidden'
            >{{ column.column_title }}</th>
          </template>
        </tr>
      </thead>

      <tbody>
        <tr v-for='row in rows'>
          <template v-for='column in store.columns'>
            <td
              v-if='column.hidden'
              :style="'text-align:'+ store.alignment"
            >
              <cell-view-component :column="column" :row="row" />
            </td>
          </template>
        </tr>
      </tbody>
    </table>
  `
}
