'use strict';

/** Блок клавиш в выпадающей секции номер набирателя */
export function Numpad(options) {
  return {
    name: 'numpad',

    setup() {
      const store = Vuex.useStore();
      const phone_number = Vue.computed(() => store.state[options.prefix].phone_number);
      const isCall = Vue.computed(() => store.state[options.prefix].Call.isCall || false);

      return {
        buttonClick(cur_symbol) {
          store.dispatch(`${options.prefix}/setValue`, {
            name: 'phone_number',
            data: `${phone_number.value}${cur_symbol}`,
            useLS: true,
          });

          store.dispatch(`${options.prefix}/setValue`, {  // TODO: хз, зачем это
            name: 'call_status',
            data: 'progress',
            useLS: true,
          });

          document.getElementById('call_block-tel_number').focus();
        },

        buttonClear() {
          if (isCall.value) {
            return;
          }

          store.dispatch(`${options.prefix}/setValue`, {
            name: 'phone_number',
            data: "",
            useLS: true,
          });

          document.getElementById('call_block-tel_number').focus();
        },

        buttonDelete() {
          if (isCall.value) {
            return;
          }

          store.dispatch(`${options.prefix}/setValue`, {
            name: 'phone_number',
            data: ((phone_number.value).slice(0, -1)),
            useLS: true,
          });

          document.getElementById('call_block-tel_number').focus();
        },
      }
    },

    template: /*html*/`
      <div style="position: relative; width: -webkit-fill-available; width: -moz-available;">
        <div>
          <div class="numberBlock">
            <div
              class="numberBlockElement"
              v-for="items in [[1,2,3], [4,5,6], [7,8,9], ['*',0,'#']]"
            >
              <div v-for="item in items" @click="buttonClick(item)">{{ item }}</div>
            </div>

            <div class="numberBlockElement">
              <div @click="buttonClear">CE</div>
              <div @click="buttonClick('+')">+</div>
              <div @click="buttonDelete()">C</div>
            </div>
          </div>
        </div>
      </div>
    `
  }
}
