(function () {

    /**
     *
     * @param attr
     * @returns {*}
     * @private
     */
    var _getDefaultParams = function (attr) {
        var form = $('#edit_button_form');
        var result = null;
        if (form.length > 0) {
            result = form.attr(attr);
        } else if ($('#calc_form').length > 0){
            result = $('#calc_form').attr(attr);
        }

        return result;
    };
    window._getDefaultParams = _getDefaultParams;

    /**
     *
     * @returns {boolean}
     * @private
     */
    var _checkForButtonName = function () {
        var nameField = $('#name_button');
        var correct = false;
        if (nameField.length > 0) {
            var nameValue = nameField.val();
            if (!nameValue.replace(/ /g, '')) {
                jalert(lang.must_enter_name_button);
            } else if (nameValue.length < 2) {
                jalert(lang.invalid_button_name);
            } else {
                correct = true;
            }
        }

        return correct;
    };

    /**
     *
     * @private
     */
    var _initParams = function () {
        var params = new ParamsConstruct();
        params.init();
    };

    var EditButton = function (loadParams = false) {
        this.loadParams = loadParams;
        this.onLoad();
    };

    /**
     *
     * @type {string}
     */
    EditButton.prototype.ajaxUrl = 'edit_button.php';

    /**
     *
     * @type {number}
     */
    EditButton.prototype.buttonId = parseInt(_getDefaultParams('button-id')) || -1;

    EditButton.prototype.paramsData = {};

    /**
     *
     * @type {number}
     */
    EditButton.prototype.tableId = parseInt(_getDefaultParams('table-id'));

    EditButton.prototype.initParamDataInput = function (data) {
        if (this.buttonId === -1) {
            var hiddenInput = $('#params-data-hidden');
            if (hiddenInput.length > 0) {
                hiddenInput.val(JSON.stringify(data));
            }
        }
    };

    EditButton.prototype.getFieldByType = function (type, parameters) {
        var field = null;
        var type_value = parameters['type_value'] ? Number(parameters['type_value']) : 0;
        var mult_value = parameters['mult_value'] ? Number(parameters['mult_value']) : 0;
        if (typeof type !== 'undefined') {
            type = parseInt(type);
            if (type === 1
             || type === 6
             || type === 9) {
                field = $('<input>')
            } else if (type === 2
                    || type === 12) {
                var class_attr = 'datepicker';
                if (type_value === 1) {
                    class_attr += ' datetime';
                }
                field = $('<input class="' + class_attr + '">');
            } else if (type === 4
                    || type === 7
                    || type === 14) {
                field = $('<select>');
            } else if (type === 3) {
                if (mult_value) {
                    field = $('<textarea>');
                } else {
                    field = $('<input>');
                }
            } else if (type === 5) {
                field = $('<select class="combobox">');
            }
        }

        return field;
    };

    /**
     *
     */
    EditButton.prototype.initParamDataInput = function () {
        if (this.buttonId === -1) {
            var hiddenInput = $('#params-data-hidden');
            if (hiddenInput.length > 0) {
                hiddenInput.val(JSON.stringify(this.paramsData));
            }
        }
    };

    /**
     *
     */
    EditButton.prototype.initEvents = function () {
        var form = $('#edit_button_form');
        if (form.length > 0) {
            form.submit(this.onFormSubmit.bind(this));
        }
    };

    /** Event`s callbacks */



    /**
     *
     * @returns {boolean}
     */
    EditButton.prototype.onFormSubmit = function () {
        var correct = true;
        //correct = _checkForButtonName();
        correct = _checkForParameters();
        if (!correct) {
            return false;
        }
        this.initParamDataInput();
    };

    var _checkForParameters = function () {
        var correct = false;
        var useParams = $('input[name=use_params]:checked');
        if (Number(useParams.val()) === 1) {
            var parameterName = $('#calc-param-name');
            var parameterSaveBtn = $('#calc_params_save-btn');
            var calcMode = $('input[name=calc_mode]:checked');
            var parameterSaveField = $('#calc-param-field-save');


            if (parameterName.length > 0 && parameterSaveBtn.length > 0 && calcMode.length > 0 && Number(calcMode.val()) === 0) {
                parameterSaveBtn.click();
                if (parameterName.val().trim() !== '') {
                    correct = true;
                }
                if (correct) {
                    correct = parameterSaveField.val() > 0;
                }
            } else {
                correct = true;
            }
        } else {
            correct = true;
        }
        return correct;
    };

    /** ================= */

    /**
     *
     */
    EditButton.prototype.onLoad = function () {
        if (this.loadParams) {
            _initParams();
        }
        this.initEvents();
    };

    window.EditButton = EditButton;

})();
