<?php
// Меняем тип поля
run_query("CREATE TABLE `" . $config['table_prefix'] . "acc_cats` (
            `cat_id` INT NOT NULL ,
            `group_id` INT NOT NULL ,
            `access` TINYINT NOT NULL,
            KEY `cat_id` (`cat_id`),
            KEY `group_id` (`group_id`)
            ) ENGINE = " . $config['db_engine']);
run_query("CREATE TABLE `" . $config['table_prefix'] . "acc_cats_par` (
            `cat_id` INT NOT NULL ,
            `group_id` INT NOT NULL ,
            `access` TINYINT NOT NULL,
            KEY `cat_id` (`cat_id`),
            KEY `group_id` (`group_id`)
            ) ENGINE = " . $config['db_engine']);


// Добавляем на таблицы общее право доступа
run_query("ALTER TABLE `" . $config['table_prefix'] . "acc_tables` ADD `acc` TINYINT( 1 ) NOT NULL AFTER `table_id`");
run_query("ALTER TABLE `" . $config['table_prefix'] . "acc_tables_par` ADD `acc` TINYINT( 1 ) NOT NULL AFTER `table_id`");

// Скомпилированный фильтр для каждой группы и таблицы, имеет смысл только при rule_id=0
run_query("ALTER TABLE `" . $config['table_prefix'] . "acc_tables` ADD `rule_filter` text CHARACTER SET utf8 NOT NULL");

// Таблица правил
run_query("CREATE TABLE IF NOT EXISTS `" . $config['table_prefix'] . "acc_rules` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `name` varchar(255) CHARACTER SET utf8 NOT NULL,
              `num` int(11) NOT NULL,
              `table_id` int(11) NOT NULL,
              `group_id` int(11) NOT NULL,
              `condition` text CHARACTER SET utf8 NOT NULL,
              `condition_php` text CHARACTER SET utf8 NOT NULL,
              `rights` text CHARACTER SET utf8 NOT NULL,
              PRIMARY KEY (`id`),
              KEY `group_id` (`group_id`),
              KEY `table_id` (`table_id`)
            ) ENGINE=" . $config['db_engine']);

// По умолчанию доступ на все таблицы разрешен
run_query("UPDATE `" . $config['table_prefix'] . "acc_tables` SET acc=1");

// Конвертируем права доступа на таблицы в права доступа на группы
$result = run_query("SELECT a.*, b.cat_id FROM `" . $config['table_prefix'] . "acc_tables` a, `" . $config['table_prefix'] . "tables` b WHERE a.table_id=b.id and a.vis_acc=1");
$allowed_cats = array(); // Разрешенные категории по таблицам
while ($acc_table = sql_fetch_assoc($result)) {
    $cat_id = $acc_table['cat_id'];
    $group_id = $acc_table['group_id'];
    if ($allowed_cats[$cat_id . "_" . $group_id]) {
        // Уже разрешена данная категория
    } else {
        $allowed_cats[$cat_id . "_" . $group_id] = $acc_table['id'];
        run_query("INSERT INTO `" . $config['table_prefix'] . "acc_cats` (`cat_id`,`group_id`,`access`) VALUES ('$cat_id', '$group_id', '1')");
    }
}
$result = run_query("SELECT a.*, b.cat_id FROM `" . $config['table_prefix'] . "acc_reports` a, `" . $config['table_prefix'] . "reports` b WHERE a.report_id=b.id and a.access=1");
while ($acc_table = sql_fetch_assoc($result)) {
    $cat_id = $acc_table['cat_id'];
    $group_id = $acc_table['group_id'];
    if ($allowed_cats[$cat_id . "_" . $group_id]) {
        // Уже разрешена данная категория
    } else {
        $allowed_cats[$cat_id . "_" . $group_id] = $acc_table['id'];
        run_query("INSERT INTO `" . $config['table_prefix'] . "acc_cats` (`cat_id`,`group_id`,`access`) VALUES ('$cat_id', '$group_id', '1')");
    }
}

// Не разрешенные категории - помечаем как скрытые
$all_cats = sql_select_array($config['table_prefix'] . "cats", "ALL_ROWS");
$all_groups = sql_select_array($config['table_prefix'] . "groups", "ALL_ROWS");
foreach ($all_cats as $cat) {
    foreach ($all_groups as $group) {
        $cat_id = $cat['id'];
        $group_id = $group['id'];
        if ($allowed_cats[$cat_id . "_" . $group_id]) {
            // Уже разрешена данная категория
        } else {
            $allowed_cats[$cat_id . "_" . $group_id] = 'h';
            run_query("INSERT INTO `" . $config['table_prefix'] . "acc_cats` (`cat_id`,`group_id`,`access`) VALUES ('$cat_id', '$group_id', '2')");
        }
    }
}
unset($all_cats);
unset($all_groups);
unset($allowed_cats);

// конвертируем старые права в новые
$q = run_query("SELECT * FROM `" . $config['table_prefix'] . "acc_fields_ex`");
while ($d = sql_fetch_assoc($q)) {
    $old_ex[$d['field_id']][$d['user_fid']] = $d;
}


// создаем таблицу для новой карты
run_query("CREATE TABLE `" . $config['table_prefix'] . "acc_fields_new` LIKE `" . $config['table_prefix'] . "acc_fields`");
$table_rule_nums = array();

$old_acc_q = run_query("SELECT * FROM `" . $config['table_prefix'] . "acc_fields`");
while ($old_acc = sql_fetch_assoc($old_acc_q)) {
    $view_tb = 0;
    $view = 0;
    $view_add = 0;
    $view_edit = 0;
    $read = 0;
    $write = 0;
    $f_ext = 0;

    if (is_array($old_ex[$old_acc['field_id']])) {
        foreach ($old_ex[$old_acc['field_id']] as $one_old_ex) {
            // Проверяем включена ли галочка расширенные права в поле
            $q = run_query("SELECT * FROM `" . $config['table_prefix'] . "fields` WHERE `id`=" . $one_old_ex['user_fid']);
            $d = sql_fetch_assoc($q);
            $f_name = $d['name_field'];
            $f_ext = explode("|", $d['type_value']);
            if ($f_ext[1]) {
                $f_ext = $f_ext[1];
            } else {
                $f_ext = 0;
            }

            $view_tb = $one_old_ex['read'] & $old_acc['view_tb'];
            $view = $one_old_ex['read'] & $old_acc['view'];
            $view_add = $one_old_ex['write'] & $old_acc['view_add'];
            $view_edit = $one_old_ex['write'] & $old_acc['view_edit'];
            $read = $one_old_ex['read'];
            $write = $one_old_ex['write'];

            if ($f_ext) {
                // Проверяем включена ли галочка расширенные права в таблице
                $fld = sql_select_array($config['table_prefix'] . 'fields', '`id`=', $old_acc['field_id']);
                $tbl_acc = sql_select_array($config['table_prefix'] . 'acc_tables', '`table_id`=', $fld['table_id'],
                    ' and `group_id`=', $old_acc['group_id']);
                if (!$tbl_acc['ext_acc']) {
                    $f_ext = 0;
                }
            }
            if ($f_ext) // если нужно правило
            {
                // создаем правило
                $cond = 'a:1:{i:1;a:7:{s:5:"field";s:' . strlen($one_old_ex['user_fid'] . "") . ':"' . $one_old_ex['user_fid'] . '";s:4:"term";s:1:"=";s:5:"value";s:9:"{current}";s:4:"oper";s:0:"";s:8:"interval";s:0:"";s:6:"period";s:0:"";s:5:"union";s:0:"";}}';
                $cond_php = '($line[\'' . form_int_name($one_old_ex['user_fid']) . '\']==$user[\'id\'])';
                $rights = array(
                    array("field" => $one_old_ex['field_id'], "view_tb" => $view_tb),
                    array("field" => $one_old_ex['field_id'], "view" => $view),
                    array("field" => $one_old_ex['field_id'], "view_add" => $view_add),
                    array("field" => $one_old_ex['field_id'], "view_edit" => $view_edit),
                    array("field" => $one_old_ex['field_id'], "read" => $read),
                    array("field" => $one_old_ex['field_id'], "write" => $write)
                );

                $temp = sql_select_array($config['table_prefix'] . "acc_rules", "`name`='", $f_name,
                    "' AND `table_id`=", $old_acc['table_id'], " AND `group_id`=", $old_acc['group_id']);
                if (!$temp['id']) {
                    // добавляем правило
                    $t_g = $old_acc['table_id'] . "_" . $old_acc['group_id'];
                    if (!$table_rule_nums[$t_g]) {
                        $table_rule_nums[$t_g] = 1;
                    } else {
                        $table_rule_nums[$t_g]++;
                    }
                    sql_insert($config['table_prefix'] . "acc_rules", array(
                        "name" => $f_name,
                        "table_id" => $old_acc['table_id'],
                        "group_id" => $old_acc['group_id'],
                        "`condition`" => $cond,
                        "condition_php" => $cond_php,
                        "rights" => serialize($rights),
                        "num" => $table_rule_nums[$t_g]
                    ));
                } else {
                    // обновляем правило
                    $temp_arr = unserialize($temp['rights']);
                    $rights = array_merge($rights, $temp_arr);

                    sql_update($config['table_prefix'] . "acc_rules", array(
                        "name" => $f_name,
                        "table_id" => $old_acc['table_id'],
                        "group_id" => $old_acc['group_id'],
                        "`condition`" => $cond,
                        "condition_php" => $cond_php,
                        "rights" => serialize($rights)
                    ), "id=" . $temp['id']);
                }
            }
        }
    }

    // Проверяем включена ли галочка расширенные права в таблице
    $fld = sql_select_array($config['table_prefix'] . 'fields', '`id`=', $old_acc['field_id']);
    $tbl_acc = sql_select_array($config['table_prefix'] . 'acc_tables', '`table_id`=', $fld['table_id'],
        ' and `group_id`=', $old_acc['group_id']);
    if (!$tbl_acc['ext_acc']) {
        $old_acc['read'] = 1;
        $old_acc['write'] = 1;
    }

    $view_tb = $old_acc['read'] & $old_acc['view_tb'];
    $view = $old_acc['read'] & $old_acc['view'];
    $view_add = $old_acc['write'] & $old_acc['view_add'];
    $view_edit = $old_acc['write'] & $old_acc['view_edit'];
    $read = $old_acc['read'];
    $write = $old_acc['write'];

    // Если есть расширенные права, подтаблица, разрешен просмотр в таблице и импорт, то разрешаем редактирование для совместимости с 1.9.7
    $tbl_info = sql_select_array($config['table_prefix'] . 'tables', '`id`=', $fld['table_id']);
    if ($tbl_acc['ext_acc'] && $tbl_info['subtable'] && $view_tb && $write) {
        $view_edit = 1;
    }

    sql_insert($config['table_prefix'] . "acc_fields_new", array(
        "group_id" => $old_acc['group_id'],
        "table_id" => $old_acc['table_id'],
        "field_id" => $old_acc['field_id'],
        "view_tb" => $view_tb,
        "view_add" => $view_add,
        "view_edit" => $view_edit,
        "view" => $view,
        "`read`" => $read,
        "`write`" => $write
    ));
}

// удаляем таблицу со старой картой и переименовываем новую
run_query("DROP TABLE `" . $config['table_prefix'] . "acc_fields`");
run_query("DROP TABLE `" . $config['table_prefix'] . "acc_fields_ex`");
run_query("RENAME TABLE `" . $config['table_prefix'] . "acc_fields_new` TO `" . $config['table_prefix'] . "acc_fields`");
?>