const fields = {    
    
      
    "apps": {

        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "app",
            "required": true,
            "help": "tbank_app_name"
        },

        "auth_token": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "tbank_app_token"         
        }
        
    },

//Сопоставление таблиц КБ и объектов внешнего приложения    
    "tables": {
        "internal_object_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "tables"
            },
            "required": true,
            "help": "tbank_internal_object"
        },
    },

    "connectors": {

        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "connector",
            "required": true,
            "help": "tbank_connector_name"
        },

        "external_app_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "list",
                field: "apps",
                value: "id",
                label: "name"
            },
            "required": true,
            "help": "tbank_app"   
        },        

        "external_action_params_accountNumber": {
            "type": "input-text",
            "required": true,
            "help": "tbank_account_number"
        },

        "external_action_params_categories": {
            "type": "dropdown",
            "required": true,
            "options": {
                incomePeople: "Все входящие платежи",
                selfTransferInner: "Перевод между своими счетами в T-Бизнесе",
                selfOutcomeOuter: "Перевод себе из другого банка",
                contragentIncome: "Пополнение от контрагента",
                acquiring: "Эквайринг",
                acquiringPos: "Торговый эквайринг",
                acquiringInternet: "Интернет‑эквайринг",
                incomeLoan: "Получение кредита",
                refundIn: "Возврат средств",
                cashIn: "Взнос наличных",
                cashInRevenue: "Взнос выручки из кассы",
                cashInOwn: "Взнос собственных средств",
                income: "Проценты на остаток по счету",
                depositPartWithdrawal: "Частичное изъятие средств депозита",
                depositFullWithdrawal: "Закрытие депозитного счета ЮЛ",
                creditPaymentInner: "Погашение кредита",
                otherIn: "Другие входящие",
                unspecifiedIn: "Входящие без категории",
                cardOperation: "Оплата картой",
                cashOut: "Снятие наличных",
                fee: "Услуги банка",
                penalty: "Штрафы",
                contragentPeople: "Все исходящие платежи",
                selfIncomeOuter: "Перевод себе в другой банк",
                selfTransferOuter: "Перевод между своими счетами в T‑Бизнесе",
                salary: "Выплаты",
                contragentOutcome: "Перевод контрагенту",
                contragentRefund: "Возврат контрагенту",
                budget: "Платежи в бюджет",
                tax: "Налоговые платежи",
                creditPaymentOuter: "Погашение кредита",
                "sme-c2c": "С карты на карту",
                otherOut: "Другие исходящие",
                unspecifiedOut: "Исходящие без категории"
              },
              "default": "contragentIncome",
              "help": "tbank_categories"
        },

        "cron_id_period": {
            "type": "dropdown",
            "required": true,
            "options": {
                '* * * * *': 'Ежеминутно',
                '1,15,30,45 * * * *': 'Каждые 15 минут',
                '1-59/5 * * * *': 'Каждые 5 минут',
                '1 12 * * *': 'Каждый день в 12 часов',
                '1 23 * * *': 'Каждый день в 23 часа',
                '1 3 * * *': 'Каждый день в 3 часа',
                '1 * * * *': 'Каждый час'
            },
            "default": '1 * * * *',
            "help": "tbank_cron_period"
        },   

        "cron": {
            type: "html",
            help: "integration_auto_cron"
        },        
        
        "from_start": {
            "type": "input-datetime",
            "required": true,
            "help": "tbank_from_start"
        }         
    }

}

export default fields;